/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Candidate;
import fm.icelink.ConnectionState;
import fm.icelink.ConnectionStats;
import fm.icelink.Dynamic;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IConnection;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IceGatheringState;
import fm.icelink.IceServer;
import fm.icelink.IceServerCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.Promise;
import fm.icelink.ProtocolType;
import fm.icelink.RemoteCandidatePromise;
import fm.icelink.SessionDescription;
import fm.icelink.SignallingState;
import fm.icelink.StreamBase;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.TrickleIcePolicy;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.Message;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectionBase<TConnection extends ConnectionBase<TConnection, TStream>, TStream extends StreamBase>
extends Dynamic
implements IConnection<TConnection, TStream> {
    private IceServerCollection __iceServers;
    private List<IAction1<TConnection>> __onGatheringStateChange = new ArrayList<IAction1<TConnection>>();
    private List<IAction2<TConnection, Candidate>> __onLocalCandidate = new ArrayList<IAction2<TConnection, Candidate>>();
    private List<IAction2<TConnection, SessionDescription>> __onLocalDescription = new ArrayList<IAction2<TConnection, SessionDescription>>();
    private List<IAction2<TConnection, Candidate>> __onRemoteCandidate = new ArrayList<IAction2<TConnection, Candidate>>();
    private List<IAction2<TConnection, SessionDescription>> __onRemoteDescription = new ArrayList<IAction2<TConnection, SessionDescription>>();
    private List<IAction1<TConnection>> __onSignallingStateChange = new ArrayList<IAction1<TConnection>>();
    private List<IAction1<TConnection>> __onStateChange = new ArrayList<IAction1<TConnection>>();
    private SignallingState __signallingState;
    private ConnectionState __state;
    private TrickleIcePolicy __trickleIcePolicy;
    private boolean __useTrickleIce = true;
    protected Object _connectionLock;
    private int _deadStreamTimeout;
    private ArrayList<RemoteCandidatePromise> _earlyRemoteCandidatePromises;
    private Error _error;
    private IceGatherPolicy _iceGatherPolicy;
    private String _id;
    private String _internalId;
    private IAction1<TConnection> _onGatheringStateChange = null;
    private IAction2<TConnection, Candidate> _onLocalCandidate = null;
    private IAction2<TConnection, SessionDescription> _onLocalDescription = null;
    private IAction2<TConnection, Candidate> _onRemoteCandidate = null;
    private IAction2<TConnection, SessionDescription> _onRemoteDescription = null;
    private IAction1<TConnection> _onSignallingStateChange = null;
    private IAction1<TConnection> _onStateChange = null;
    private String _tieBreaker;
    private int _timeout;

    @Override
    public void addIceServer(IceServer iceServer) {
        this.__iceServers.add(iceServer);
    }

    @Override
    public void addIceServers(IceServer[] iceServers) {
        this.__iceServers.addMany(iceServers);
    }

    @Override
    public void addOnGatheringStateChange(IAction1<TConnection> value) {
        if (value != null) {
            if (this._onGatheringStateChange == null) {
                this._onGatheringStateChange = new IAction1<TConnection>(){

                    @Override
                    public void invoke(TConnection p0) {
                        for (IAction1 action : new ArrayList(ConnectionBase.this.__onGatheringStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onGatheringStateChange.add(value);
        }
    }

    @Override
    public void addOnLocalCandidate(IAction2<TConnection, Candidate> value) {
        if (value != null) {
            if (this._onLocalCandidate == null) {
                this._onLocalCandidate = new IAction2<TConnection, Candidate>(){

                    @Override
                    public void invoke(TConnection p0, Candidate p1) {
                        for (IAction2 action : new ArrayList(ConnectionBase.this.__onLocalCandidate)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onLocalCandidate.add(value);
        }
    }

    @Override
    public void addOnLocalDescription(IAction2<TConnection, SessionDescription> value) {
        if (value != null) {
            if (this._onLocalDescription == null) {
                this._onLocalDescription = new IAction2<TConnection, SessionDescription>(){

                    @Override
                    public void invoke(TConnection p0, SessionDescription p1) {
                        for (IAction2 action : new ArrayList(ConnectionBase.this.__onLocalDescription)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onLocalDescription.add(value);
        }
    }

    @Override
    public void addOnRemoteCandidate(IAction2<TConnection, Candidate> value) {
        if (value != null) {
            if (this._onRemoteCandidate == null) {
                this._onRemoteCandidate = new IAction2<TConnection, Candidate>(){

                    @Override
                    public void invoke(TConnection p0, Candidate p1) {
                        for (IAction2 action : new ArrayList(ConnectionBase.this.__onRemoteCandidate)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onRemoteCandidate.add(value);
        }
    }

    @Override
    public void addOnRemoteDescription(IAction2<TConnection, SessionDescription> value) {
        if (value != null) {
            if (this._onRemoteDescription == null) {
                this._onRemoteDescription = new IAction2<TConnection, SessionDescription>(){

                    @Override
                    public void invoke(TConnection p0, SessionDescription p1) {
                        for (IAction2 action : new ArrayList(ConnectionBase.this.__onRemoteDescription)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onRemoteDescription.add(value);
        }
    }

    @Override
    public void addOnSignallingStateChange(IAction1<TConnection> value) {
        if (value != null) {
            if (this._onSignallingStateChange == null) {
                this._onSignallingStateChange = new IAction1<TConnection>(){

                    @Override
                    public void invoke(TConnection p0) {
                        for (IAction1 action : new ArrayList(ConnectionBase.this.__onSignallingStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onSignallingStateChange.add(value);
        }
    }

    @Override
    public void addOnStateChange(IAction1<TConnection> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<TConnection>(){

                    @Override
                    public void invoke(TConnection p0) {
                        for (IAction1 action : new ArrayList(ConnectionBase.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    @Override
    public Future<Candidate> addRemoteCandidate(Candidate remoteCandidate) {
        RemoteCandidatePromise item = new RemoteCandidatePromise(remoteCandidate);
        if (Global.equals((Object)this.getState(), (Object)ConnectionState.New) || Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) {
            this._earlyRemoteCandidatePromises.add(item);
            if (!Global.equals((Object)this.getState(), (Object)ConnectionState.New) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) {
                this._earlyRemoteCandidatePromises.clear();
                this.addRemoteCandidatePromise(item);
            }
            return item;
        }
        if (!this.getIsInTerminatingOrTerminatedState()) {
            this.addRemoteCandidatePromise(item);
        }
        return item;
    }

    private void addRemoteCandidatePromise(RemoteCandidatePromise remoteCandidatePromise) {
        try {
            this.raiseRemoteCandidate(remoteCandidatePromise.getRemoteCandidate());
            this.doAddRemoteCandidate(remoteCandidatePromise, remoteCandidatePromise.getRemoteCandidate());
        }
        catch (Exception exception) {
            remoteCandidatePromise.reject(exception);
        }
    }

    @Override
    public abstract void close();

    public ConnectionBase(Object sharedLock) {
        this.__iceServers = new IceServerCollection();
        this.__trickleIcePolicy = TrickleIcePolicy.FullTrickle;
        this._earlyRemoteCandidatePromises = new ArrayList();
        this._connectionLock = sharedLock;
        this.initializeBase();
    }

    @Override
    public Future<SessionDescription> createAnswer() {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.doCreateAnswer(promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    public Future<SessionDescription> createOffer() {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.doCreateOffer(promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    protected abstract void doAddRemoteCandidate(Promise<Candidate> var1, Candidate var2);

    protected abstract void doCreateAnswer(Promise<SessionDescription> var1);

    protected abstract boolean doCreateOffer(Promise<SessionDescription> var1);

    protected abstract void doSendCachedLocalCandidates();

    protected abstract void doSetLocalDescription(Promise<SessionDescription> var1, SessionDescription var2);

    protected abstract void doSetRemoteDescription(Promise<SessionDescription> var1, SessionDescription var2);

    @Override
    public int getDeadStreamTimeout() {
        return this._deadStreamTimeout;
    }

    @Override
    public Error getError() {
        return this._error;
    }

    @Override
    public abstract IceGatheringState getGatheringState();

    @Override
    public IceGatherPolicy getIceGatherPolicy() {
        return this._iceGatherPolicy;
    }

    @Override
    public IceServer getIceServer() {
        return (IceServer)this.__iceServers.getValue();
    }

    @Override
    public IceServer[] getIceServers() {
        return (IceServer[])this.__iceServers.getValues();
    }

    @Override
    public String getId() {
        return this._id;
    }

    protected abstract TConnection getInstance();

    String getInternalId() {
        return this._internalId;
    }

    boolean getIsInTerminatingOrTerminatedState() {
        return Global.equals((Object)this.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failed) || Global.equals((Object)this.getState(), (Object)ConnectionState.Failing);
    }

    @Override
    public abstract SessionDescription getLocalDescription();

    @Override
    public abstract SessionDescription getRemoteDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignallingState getSignallingState() {
        Object object = this._connectionLock;
        synchronized (object) {
            return this.__signallingState;
        }
    }

    @Override
    public ConnectionState getState() {
        return this.__state;
    }

    @Override
    public abstract Future<ConnectionStats> getStats();

    @Override
    public abstract TStream[] getStreams();

    @Override
    public String getTieBreaker() {
        return this._tieBreaker;
    }

    @Override
    public int getTimeout() {
        return this._timeout;
    }

    @Override
    public TrickleIcePolicy getTrickleIcePolicy() {
        return this.__trickleIcePolicy;
    }

    boolean getUseTrickleIce() {
        return this.__useTrickleIce;
    }

    private void initializeBase() {
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setInternalId(Guid.newGuid().toString().replace("-", ""));
        this.setTieBreaker(Guid.newGuid().toString().replace("-", ""));
        this.setState(ConnectionState.New);
        this.setTimeout(30000);
        this.setDeadStreamTimeout(15000);
        this.setIceGatherPolicy(IceGatherPolicy.All);
        this.setTrickleIcePolicy(TrickleIcePolicy.FullTrickle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Error processDescription(SessionDescription description, boolean isLocalDescription) {
        Object object = this._connectionLock;
        synchronized (object) {
            int num2;
            Message sdpMessage = description.getSdpMessage();
            if (sdpMessage == null) {
                return new Error(ErrorCode.LocalDescriptionError, new Exception(StringExtensions.format("{0} session description is empty.", isLocalDescription ? "Local" : "Remote")));
            }
            Object[] streams = this.getStreams();
            if (streams == null || ArrayExtensions.getLength(streams) == 0) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("At least one local stream is required for the connection to conduct signalling exchange."));
            }
            Object[] mediaDescriptions = sdpMessage.getMediaDescriptions();
            if (mediaDescriptions == null || ArrayExtensions.getLength(mediaDescriptions) == 0) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("At least one media description is required for the connection to conduct signalling exchange."));
            }
            int length = ArrayExtensions.getLength(streams);
            if (length != (num2 = ArrayExtensions.getLength(mediaDescriptions))) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("There is a mismatch between the number of local streams ({0}) and the number of media descriptions ({1}).", IntegerExtensions.toString(length), IntegerExtensions.toString(num2))));
            }
            boolean flag = true;
            boolean remoteSupportsTrickleIce = false;
            for (int i = 0; i < ArrayExtensions.getLength(streams); ++i) {
                Object stream = streams[i];
                Object sdpMediaDescription = mediaDescriptions[i];
                StreamType type = MediaType.toStreamType(((MediaDescription)sdpMediaDescription).getMedia().getMediaType());
                if (!Global.equals((Object)((StreamBase)stream).getType(), (Object)type)) {
                    return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("There is a media type mismatch between the local stream at index {0} ({1}) and the media description at index {0} ({2}).", IntegerExtensions.toString(i), ((StreamBase)stream).getType().toString(), type.toString())));
                }
                this.processSdpMediaDescription(stream, (MediaDescription)sdpMediaDescription, i, isLocalDescription, description.getRenegotiation());
                Error error = ((StreamBase)stream).processSdpMediaDescription(sdpMessage, (MediaDescription)sdpMediaDescription, isLocalDescription, description.getIsOffer(), description.getRenegotiation());
                if (error != null) {
                    return error;
                }
                remoteSupportsTrickleIce = ((StreamBase)stream).getRemoteSupportsTrickleIce();
                flag = flag && remoteSupportsTrickleIce;
            }
            if (!isLocalDescription && Global.equals((Object)this.getTrickleIcePolicy(), (Object)TrickleIcePolicy.HalfTrickle)) {
                Log.debug(StringExtensions.format("Peer supports Trickle-Ice. Trickle Ice will be enabled in all subsequent communications with the peer for the lifetime of connection {0}.", this.getId()));
                this.setUseTrickleIce(flag);
            }
            return null;
        }
    }

    protected abstract Error processSdpMediaDescription(TStream var1, MediaDescription var2, int var3, boolean var4, boolean var5);

    abstract void processStateChange();

    void raiseCachedCandidates() {
        for (RemoteCandidatePromise promise : this._earlyRemoteCandidatePromises) {
            this.addRemoteCandidatePromise(promise);
        }
        this._earlyRemoteCandidatePromises.clear();
        this.doSendCachedLocalCandidates();
    }

    protected void raiseGatheringStateChange(TConnection connection) {
        IAction1<TConnection> onGatheringStateChange = this._onGatheringStateChange;
        if (onGatheringStateChange != null) {
            onGatheringStateChange.invoke(connection);
        }
    }

    protected void raiseLocalCandidate(Candidate localCandidate) {
        IAction2<TConnection, Candidate> onLocalCandidate = this._onLocalCandidate;
        if (onLocalCandidate != null && !localCandidate.getDispatched()) {
            onLocalCandidate.invoke(this.getInstance(), localCandidate);
        }
        if (Global.equals((Object)localCandidate.getTurnTransportProtocol(), (Object)ProtocolType.Tcp)) {
            Log.debug(StringExtensions.format("Local candidate for stream {0} (over TCP):\n{1}", IntegerExtensions.toString(localCandidate.getSdpMediaIndex()), localCandidate.getSdpCandidateAttribute().toString()));
        } else {
            Log.debug(StringExtensions.format("Local candidate for stream {0}:\n{1}", IntegerExtensions.toString(localCandidate.getSdpMediaIndex()), localCandidate.getSdpCandidateAttribute().toString()));
        }
    }

    private void raiseLocalDescription(SessionDescription localDescription) {
        IAction2<TConnection, SessionDescription> onLocalDescription = this._onLocalDescription;
        if (onLocalDescription != null) {
            onLocalDescription.invoke(this.getInstance(), localDescription);
        }
    }

    private void raiseRemoteCandidate(Candidate remoteCandidate) {
        IAction2<TConnection, Candidate> onRemoteCandidate = this._onRemoteCandidate;
        if (onRemoteCandidate != null) {
            onRemoteCandidate.invoke(this.getInstance(), remoteCandidate);
        }
        Log.debug(StringExtensions.format("Remote candidate for stream {0}:\n{1}", IntegerExtensions.toString(remoteCandidate.getSdpMediaIndex()), remoteCandidate.getSdpCandidateAttribute().toString()));
    }

    private void raiseRemoteDescription(SessionDescription remoteDescription) {
        IAction2<TConnection, SessionDescription> onRemoteDescription = this._onRemoteDescription;
        if (onRemoteDescription != null) {
            onRemoteDescription.invoke(this.getInstance(), remoteDescription);
        }
    }

    private void raiseStateChange() {
        IAction1<TConnection> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this.getInstance());
        }
    }

    @Override
    public void removeIceServer(IceServer iceServer) {
        this.__iceServers.remove(iceServer);
    }

    @Override
    public void removeIceServers(IceServer[] iceServers) {
        this.__iceServers.removeMany(iceServers);
    }

    @Override
    public void removeOnGatheringStateChange(IAction1<TConnection> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onGatheringStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onGatheringStateChange.remove(value);
        if (this.__onGatheringStateChange.size() == 0) {
            this._onGatheringStateChange = null;
        }
    }

    @Override
    public void removeOnLocalCandidate(IAction2<TConnection, Candidate> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onLocalCandidate, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onLocalCandidate.remove(value);
        if (this.__onLocalCandidate.size() == 0) {
            this._onLocalCandidate = null;
        }
    }

    @Override
    public void removeOnLocalDescription(IAction2<TConnection, SessionDescription> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onLocalDescription, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onLocalDescription.remove(value);
        if (this.__onLocalDescription.size() == 0) {
            this._onLocalDescription = null;
        }
    }

    @Override
    public void removeOnRemoteCandidate(IAction2<TConnection, Candidate> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onRemoteCandidate, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onRemoteCandidate.remove(value);
        if (this.__onRemoteCandidate.size() == 0) {
            this._onRemoteCandidate = null;
        }
    }

    @Override
    public void removeOnRemoteDescription(IAction2<TConnection, SessionDescription> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onRemoteDescription, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onRemoteDescription.remove(value);
        if (this.__onRemoteDescription.size() == 0) {
            this._onRemoteDescription = null;
        }
    }

    @Override
    public void removeOnSignallingStateChange(IAction1<TConnection> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSignallingStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSignallingStateChange.remove(value);
        if (this.__onSignallingStateChange.size() == 0) {
            this._onSignallingStateChange = null;
        }
    }

    @Override
    public void removeOnStateChange(IAction1<TConnection> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    @Override
    public void setDeadStreamTimeout(int value) {
        this._deadStreamTimeout = value;
    }

    protected void setError(Error value) {
        this._error = value;
    }

    protected abstract void setGatheringState(IceGatheringState var1);

    @Override
    public void setIceGatherPolicy(IceGatherPolicy value) {
        this._iceGatherPolicy = value;
    }

    @Override
    public void setIceServer(IceServer value) {
        this.__iceServers.setValue(value);
    }

    @Override
    public void setIceServers(IceServer[] value) {
        this.__iceServers.replace(value);
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    private void setInternalId(String value) {
        this._internalId = value;
    }

    @Override
    public Future<SessionDescription> setLocalDescription(SessionDescription localDescription) {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.raiseLocalDescription(localDescription);
            this.doSetLocalDescription(promise, localDescription);
            Log.debug(StringExtensions.format("Local session description ({0}):\n{1}", StringExtensions.toLower(localDescription.getType().toString()), localDescription.getSdpMessage().toString().replace("\r\n", "\n")));
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    public Future<SessionDescription> setRemoteDescription(SessionDescription remoteDescription) {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.raiseRemoteDescription(remoteDescription);
            if (this.verifySessionIdAndVersion(promise, remoteDescription)) {
                this.doSetRemoteDescription(promise, remoteDescription);
                Log.debug(StringExtensions.format("Remote session description ({0}):\n{1}", StringExtensions.toLower(remoteDescription.getType().toString()), remoteDescription.getSdpMessage().toString().replace("\r\n", "\n")));
            }
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSignallingState(SignallingState value) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__signallingState, (Object)value)) {
                this.__signallingState = value;
                IAction1<TConnection> onSignallingStateChange = this._onSignallingStateChange;
                if (onSignallingStateChange != null) {
                    onSignallingStateChange.invoke(this.getInstance());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(ConnectionState value) {
        boolean flag = false;
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                if ((Global.equals((Object)value, (Object)ConnectionState.Closed) || Global.equals((Object)value, (Object)ConnectionState.Closing)) && (Global.equals((Object)this.__state, (Object)ConnectionState.Failing) || Global.equals((Object)this.__state, (Object)ConnectionState.Failed))) {
                    String str = Global.equals((Object)this.__state, (Object)ConnectionState.Failing) ? "Failing" : "Failed";
                    Log.debug(StringExtensions.format("Connection {0} is currently in the {1} state. Will not transition to {2} state.", this.getId(), str, value.toString()));
                    return;
                }
                if (Global.equals((Object)value, (Object)ConnectionState.Closed)) {
                    if (!Global.equals((Object)this.__state, (Object)ConnectionState.Closing)) {
                        Log.info(StringExtensions.format("Setting Connection state to Closing for Connection {0}.", this.getId(), value.toString()));
                        this.__state = ConnectionState.Closing;
                        this.raiseStateChange();
                    }
                } else if (Global.equals((Object)value, (Object)ConnectionState.Failed)) {
                    if (!Global.equals((Object)this.__state, (Object)ConnectionState.Closing) && !Global.equals((Object)this.__state, (Object)ConnectionState.Failing)) {
                        if (this.getError() == null) {
                            this.setError(new Error(ErrorCode.ConnectionInternalError, new Exception("Connection is failing.")));
                        }
                        Log.info(StringExtensions.format("Setting Connection state to Failing for Connection {0}.", this.getId(), value.toString()));
                        this.__state = ConnectionState.Failing;
                        this.raiseStateChange();
                    }
                } else if (Global.equals((Object)value, (Object)ConnectionState.Connecting)) {
                    flag = true;
                }
                Log.info(StringExtensions.format("Setting Connection state to {1} for Connection {0}.", this.getId(), value.toString()));
                this.__state = value;
                this.raiseStateChange();
                this.processStateChange();
            }
        }
        if (flag) {
            this.raiseCachedCandidates();
        }
    }

    private void setTieBreaker(String value) {
        this._tieBreaker = value;
    }

    @Override
    public void setTimeout(int value) {
        this._timeout = value;
    }

    @Override
    public void setTrickleIcePolicy(TrickleIcePolicy value) {
        this.__trickleIcePolicy = value;
        if (Global.equals((Object)value, (Object)TrickleIcePolicy.FullTrickle)) {
            this.setUseTrickleIce(true);
        } else if (Global.equals((Object)value, (Object)TrickleIcePolicy.NotSupported)) {
            this.setUseTrickleIce(false);
        } else if (Global.equals((Object)value, (Object)TrickleIcePolicy.HalfTrickle)) {
            this.setUseTrickleIce(false);
        }
    }

    void setUseTrickleIce(boolean value) {
        this.__useTrickleIce = value;
    }

    private boolean verifySessionIdAndVersion(Promise<SessionDescription> promise, SessionDescription remoteDescription) {
        if (this.getRemoteDescription() != null) {
            long sessionId = this.getRemoteDescription().getSessionId();
            long num2 = remoteDescription.getSessionId();
            long sessionVersion = this.getRemoteDescription().getSessionVersion();
            long num4 = remoteDescription.getSessionVersion();
            if (sessionId != num2) {
                promise.reject(new Exception(StringExtensions.format("Received new remote description with session id {0} and session version {1}, but current remote description has id {2} and version {3}. Cannot set remote description.", new Object[]{LongExtensions.toString(num2), LongExtensions.toString(num4), LongExtensions.toString(sessionId), LongExtensions.toString(sessionVersion)})));
                return false;
            }
            if (sessionVersion >= num4) {
                promise.reject(new Exception(StringExtensions.format("Received new remote description with session id {0} and session version {1}, but current remote description has id {2} and version {3}. Cannot set remote description.", new Object[]{LongExtensions.toString(num2), LongExtensions.toString(num4), LongExtensions.toString(sessionId), LongExtensions.toString(sessionVersion)})));
                return false;
            }
        }
        return true;
    }
}

