/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicMutex;
import fm.icelink.DateExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ILog;
import fm.icelink.LogConfiguration;
import fm.icelink.LogLevel;
import fm.icelink.LogProvider;
import fm.icelink.LogQueueItem;
import fm.icelink.ManagedAutoResetEvent;
import fm.icelink.ManagedConcurrentQueue;
import fm.icelink.ManagedThread;

class AsyncLogger
implements ILog {
    private static ManagedAutoResetEvent __event;
    private static boolean __logging;
    private static AtomicMutex __threadLock;
    private static boolean __threadRunning;
    private static ManagedConcurrentQueue<LogQueueItem> _logQueue;
    private static ManagedThread _loopThread;
    private String _tag;

    public AsyncLogger(String tag) {
        this.setTag(tag);
    }

    @Override
    public void debug(String message) {
        this.doLog(LogLevel.Debug, message, null);
    }

    @Override
    public void debug(String message, Exception ex) {
        this.doLog(LogLevel.Debug, message, ex);
    }

    private void doLog(LogLevel level, String msg, Exception ex) {
        if (LogConfiguration.getHaveProviders()) {
            if (!__threadRunning && __threadLock.tryLock()) {
                if (!__threadRunning) {
                    __threadRunning = true;
                    _loopThread.start();
                }
                __threadLock.release();
            }
            _logQueue.enqueue(new LogQueueItem(DateExtensions.getNow(), this.getTag(), level, msg, ex));
            __event.set();
        }
    }

    @Override
    public void error(String message) {
        this.doLog(LogLevel.Error, message, null);
    }

    @Override
    public void error(String message, Exception ex) {
        this.doLog(LogLevel.Error, message, ex);
    }

    @Override
    public void fatal(String message, Exception ex) {
        this.doLog(LogLevel.Fatal, message, ex);
    }

    @Override
    public void fatal(String message) {
        this.doLog(LogLevel.Fatal, message, null);
    }

    @Override
    public void flush() {
        while (__logging || !_logQueue.getIsEmpty()) {
            ManagedThread.sleep(10);
        }
    }

    @Override
    public boolean getIsDebugEnabled() {
        return this.isLogEnabled(LogLevel.Debug);
    }

    @Override
    public boolean getIsErrorEnabled() {
        return this.isLogEnabled(LogLevel.Error);
    }

    @Override
    public boolean getIsFatalEnabled() {
        return this.isLogEnabled(LogLevel.Fatal);
    }

    @Override
    public boolean getIsInfoEnabled() {
        return this.isLogEnabled(LogLevel.Info);
    }

    @Override
    public boolean getIsVerboseEnabled() {
        return this.isLogEnabled(LogLevel.Verbose);
    }

    @Override
    public boolean getIsWarnEnabled() {
        return this.isLogEnabled(LogLevel.Warn);
    }

    @Override
    public String getTag() {
        return this._tag;
    }

    @Override
    public void info(String message) {
        this.doLog(LogLevel.Info, message, null);
    }

    @Override
    public void info(String message, Exception ex) {
        this.doLog(LogLevel.Info, message, ex);
    }

    @Override
    public boolean isLogEnabled(LogLevel level) {
        return LogConfiguration.getTagLogLevel(this.getTag()).getAssignedValue() <= level.getAssignedValue();
    }

    @Override
    public void log(String message) {
        this.doLog(LogLevel.Info, message, null);
    }

    private static void logLoop(ManagedThread thread) {
        while (__threadRunning) {
            __logging = true;
            while (!_logQueue.getIsEmpty()) {
                if (_logQueue.getCount() > 50) {
                    // empty if block
                }
                LogQueueItem item = null;
                Holder<Object> _var0 = new Holder<Object>(item);
                boolean _var1 = _logQueue.tryDequeue(_var0);
                item = _var0.getValue();
                if (LogConfiguration.getTagLogLevel(item.getTag()).getAssignedValue() > item.getLogLevel().getAssignedValue()) continue;
                for (LogProvider provider : LogConfiguration.getLogProviders()) {
                    provider.log(item.getTimeStamp(), item.getLogLevel(), item.getTag(), item.getMessage(), item.getException());
                }
            }
            __logging = false;
            __event.waitOne();
        }
    }

    private void setTag(String value) {
        this._tag = value;
    }

    @Override
    public void verbose(String message) {
        this.doLog(LogLevel.Verbose, message, null);
    }

    @Override
    public void verbose(String message, Exception ex) {
        this.doLog(LogLevel.Verbose, message, ex);
    }

    @Override
    public void warn(String message, Exception ex) {
        this.doLog(LogLevel.Warn, message, ex);
    }

    @Override
    public void warn(String message) {
        this.doLog(LogLevel.Warn, message, null);
    }

    static {
        _logQueue = new ManagedConcurrentQueue();
        __event = new ManagedAutoResetEvent();
        _loopThread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.AsyncLogger.logLoop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                AsyncLogger.logLoop(thread);
            }
        });
        __threadLock = new AtomicMutex();
    }
}

