/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Global;
import fm.StringComparison;
import fm.StringExtensions;
import fm.websync.MessageType;

public abstract class MetaChannels {
    public static String _bind = "/meta/bind";
    public static String _connect = "/meta/connect";
    public static String _disconnect = "/meta/disconnect";
    public static String _handshake = "/meta/handshake";
    public static String _metaPrefix = "/meta/";
    public static String _notify = "/meta/notify";
    public static String _servicePrefix = "/service/";
    public static String _subscribe = "/meta/subscribe";
    public static String _unbind = "/meta/unbind";
    public static String _unsubscribe = "/meta/unsubscribe";

    public static String convertChannelFromServiced(String channel) {
        if (!MetaChannels.isServiceChannel(channel)) {
            return channel;
        }
        return channel.substring(StringExtensions.getLength((String)"/service/") - 1);
    }

    public static String convertChannelToServiced(String channel) {
        if (channel == null || StringExtensions.getLength((String)channel) < 1) {
            return "/service/";
        }
        return StringExtensions.concat((String)"/service/", (String)channel.substring(1));
    }

    static MessageType getMessageType(String bayeuxChannel) {
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/handshake")) {
            return MessageType.Connect;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/connect")) {
            return MessageType.Stream;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/disconnect")) {
            return MessageType.Disconnect;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/bind")) {
            return MessageType.Bind;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/unbind")) {
            return MessageType.Unbind;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/subscribe")) {
            return MessageType.Subscribe;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/unsubscribe")) {
            return MessageType.Unsubscribe;
        }
        if (Global.equals((Object)bayeuxChannel, (Object)"/meta/notify")) {
            return MessageType.Notify;
        }
        if (MetaChannels.isServiceChannel(bayeuxChannel)) {
            return MessageType.Service;
        }
        if (!MetaChannels.isMetaChannel(bayeuxChannel)) {
            return MessageType.Publish;
        }
        return MessageType.Unknown;
    }

    public static boolean isMetaChannel(String channel) {
        return channel != null && StringExtensions.startsWith((String)channel, (String)"/meta/", (StringComparison)StringComparison.Ordinal);
    }

    public static boolean isReservedChannel(String channel) {
        return MetaChannels.isMetaChannel(channel) || MetaChannels.isServiceChannel(channel);
    }

    public static boolean isServiceChannel(String channel) {
        return channel != null && StringExtensions.startsWith((String)channel, (String)"/service/", (StringComparison)StringComparison.Ordinal);
    }
}

