/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    Connect(1),
    Disconnect(2),
    Bind(3),
    Unbind(4),
    Subscribe(5),
    Unsubscribe(6),
    Publish(7),
    Notify(8),
    Service(9),
    Stream(10),
    Unknown(11);

    private final int value;
    private static final Map<Integer, MessageType> lookup;

    private MessageType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static MessageType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, MessageType>();
        for (MessageType s : EnumSet.allOf(MessageType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

