/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp8;

import fm.icelink.DataBuffer;
import fm.icelink.Log;

class Packet {
    private DataBuffer _buffer;

    public DataBuffer getBuffer() {
        return this._buffer;
    }

    public boolean getExtendedControlBitsPresent() {
        return this.getBuffer().read1(0, 0);
    }

    public int getFixedHeaderLength() {
        return 1;
    }

    public DataBuffer getHeader() {
        return this.getBuffer().subset(0, this.getHeaderLength());
    }

    public int getHeaderLength() {
        return this.getFixedHeaderLength() + this.getVariableHeaderLength();
    }

    public byte getKeyIndex() {
        int offset = this.getPictureIndexExtensionPresent() ? 5 : 4;
        return this.getKeyIndexPresent() ? (byte)this.getBuffer().read5(offset, 3) : (byte)0;
    }

    public boolean getKeyIndexPresent() {
        return this.getExtendedControlBitsPresent() ? this.getBuffer().read1(1, 3) : false;
    }

    public boolean getLayerSync() {
        int offset = this.getPictureIndexExtensionPresent() ? 5 : 4;
        return this.getTemporalLevelZeroIndexPresent() ? this.getBuffer().read1(offset, 2) : false;
    }

    public boolean getNonReferenceFrame() {
        return this.getBuffer().read1(0, 2);
    }

    public byte getPartitionIndex() {
        return (byte)this.getBuffer().read4(0, 3);
    }

    public DataBuffer getPayload() {
        return this.getPayloadLength() > 0 ? this.getBuffer().subset(this.getPayloadOffset()) : null;
    }

    public int getPayloadLength() {
        return this.getBuffer() == null || this.getBuffer().getLength() - this.getHeaderLength() > 0 ? this.getBuffer().getLength() - this.getHeaderLength() : 0;
    }

    public int getPayloadOffset() {
        return this.getHeaderLength();
    }

    public short getPictureIndex() {
        if (this.getPictureIndexPresent()) {
            return this.getPictureIndexExtensionPresent() ? (short)(this.getBuffer().read16(2) & 0x7F) : (short)this.getBuffer().read7(2, 1);
        }
        return 0;
    }

    public boolean getPictureIndexExtensionPresent() {
        return this.getPictureIndexPresent() ? this.getBuffer().read1(2, 0) : false;
    }

    public boolean getPictureIndexPresent() {
        return this.getExtendedControlBitsPresent() ? this.getBuffer().read1(1, 0) : false;
    }

    public boolean getStartOfPartition() {
        return this.getBuffer().read1(0, 3);
    }

    public byte getTemporalLayerIndex() {
        int offset = this.getPictureIndexExtensionPresent() ? 5 : 4;
        return this.getTemporalLevelZeroIndexPresent() ? (byte)this.getBuffer().read2(offset, 0) : (byte)0;
    }

    public boolean getTemporalLayerIndexPresent() {
        return this.getExtendedControlBitsPresent() ? this.getBuffer().read1(1, 2) : false;
    }

    public byte getTemporalLevelZeroIndex() {
        int offset = this.getPictureIndexExtensionPresent() ? 4 : 3;
        return this.getTemporalLevelZeroIndexPresent() ? (byte)this.getBuffer().read8(offset) : (byte)0;
    }

    public boolean getTemporalLevelZeroIndexPresent() {
        return this.getExtendedControlBitsPresent() ? this.getBuffer().read1(1, 1) : false;
    }

    public int getVariableHeaderLength() {
        return (this.getExtendedControlBitsPresent() ? 1 : 0) + (this.getPictureIndexPresent() ? 1 : 0) + (this.getPictureIndexExtensionPresent() ? 1 : 0) + (this.getTemporalLevelZeroIndexPresent() ? 1 : 0) + (this.getKeyIndexPresent() || this.getTemporalLayerIndexPresent() ? 1 : 0);
    }

    public Packet() {
    }

    public Packet(DataBuffer payload, boolean startOfPartition) {
        this.setBuffer(DataBuffer.allocate(payload.getLength() + this.getFixedHeaderLength()));
        this.getBuffer().write(payload, this.getFixedHeaderLength());
        this.setPayload(this.getBuffer().subset(this.getFixedHeaderLength()));
        this.setStartOfPartition(startOfPartition);
    }

    public Packet(DataBuffer payload, boolean startOfPartition, boolean nonReferenceFrame) {
        this(payload, startOfPartition);
        this.setNonReferenceFrame(nonReferenceFrame);
    }

    public Packet(DataBuffer payload, boolean startOfPartition, boolean nonReferenceFrame, byte partitionIndex) {
        this(payload, startOfPartition, nonReferenceFrame);
        this.setPartitionIndex(partitionIndex);
    }

    private void setBuffer(DataBuffer value) {
        this._buffer = value;
    }

    private void setExtendedControlBitsPresent(boolean value) {
        this.getBuffer().write1(value, 0, 0);
    }

    private void setKeyIndex(byte value) {
        int offset = this.getPictureIndexExtensionPresent() ? 5 : 4;
        this.getBuffer().write5(value, offset, 3);
    }

    private void setKeyIndexPresent(boolean value) {
        this.getBuffer().write1(value, 1, 3);
    }

    private void setLayerSync(boolean value) {
        int offset = this.getPictureIndexExtensionPresent() ? 5 : 4;
        this.getBuffer().write1(value, offset, 2);
    }

    public void setNonReferenceFrame(boolean value) {
        this.getBuffer().write1(value, 0, 2);
    }

    public void setPartitionIndex(byte value) {
        this.getBuffer().write4(value, 0, 3);
    }

    public void setPayload(DataBuffer value) {
        if (value.getLength() > this.getBuffer().getLength()) {
            DataBuffer header = this.getHeader();
            this.setPayload(value);
            this.setBuffer(value.clone());
            this.getBuffer().prepend(header);
        } else if (this.getBuffer().getLength() == this.getHeaderLength()) {
            this.getBuffer().append(this.getPayload());
        } else {
            if (this.getHeaderLength() + value.getLength() > this.getBuffer().getLength()) {
                this.getBuffer().resize(this.getHeaderLength() + value.getLength());
            }
            this.getBuffer().write(value, this.getHeaderLength());
        }
    }

    private void setPictureIndex(short value) {
        if (this.getPictureIndexExtensionPresent()) {
            this.getBuffer().setLittleEndian(false);
            this.getBuffer().write16(value + 256, 2);
        } else {
            this.getBuffer().write7(value, 2, 1);
        }
    }

    private void setPictureIndexExtensionPresent(boolean value) {
        this.getBuffer().write1(value, 2, 0);
    }

    private void setPictureIndexPresent(boolean value) {
        this.getBuffer().write1(value, 1, 0);
    }

    public void setStartOfPartition(boolean value) {
        this.getBuffer().write1(value, 0, 3);
    }

    private void setTemporalLayerIndex(byte value) {
        int offset = this.getPictureIndexExtensionPresent() ? 5 : 4;
        this.getBuffer().write2(value, offset, 0);
    }

    private void setTemporalLayerIndexPresent(boolean value) {
        this.getBuffer().write1(value, 1, 2);
    }

    private void setTemporalLevelZeroIndex(byte value) {
        int offset = this.getPictureIndexExtensionPresent() ? 4 : 3;
        this.getBuffer().write8(value, offset);
    }

    private void setTemporalLevelZeroIndexPresent(boolean value) {
        this.getBuffer().write1(value, 1, 1);
    }

    public static Packet wrap(DataBuffer packetBuffer) {
        try {
            int offset = 0;
            Packet packet = new Packet();
            packet.setBuffer(packetBuffer);
            ++offset;
            if (packet.getExtendedControlBitsPresent()) {
                ++offset;
                if (packet.getPictureIndexPresent()) {
                    offset = packet.getPictureIndexExtensionPresent() ? (offset += 2) : ++offset;
                }
                if (packet.getTemporalLevelZeroIndexPresent()) {
                    ++offset;
                }
                if (packet.getTemporalLayerIndexPresent() || packet.getKeyIndexPresent()) {
                    ++offset;
                }
            }
            if (offset + 1 > packetBuffer.getLength()) {
                Log.error("VP8 packet payload must be at least 1 byte.");
                return null;
            }
            packet.setPayload(packetBuffer.subset(offset));
            return packet;
        }
        catch (Exception exception) {
            Log.error("Malformed VP8 packet.", exception);
            return null;
        }
    }
}

