/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtp;

import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import java.util.ArrayList;
import java.util.HashMap;

class FeedbackAttributeCollection {
    private HashMap<String, FeedbackAttribute> __attributes = new HashMap();

    public boolean addAttribute(FeedbackAttribute attribute) {
        String key = this.calculateFeedbackAttributeKey(attribute.getPayloadType(), attribute.getType(), attribute.getSubType());
        if (!this.__attributes.containsKey(key)) {
            HashMapExtensions.add(this.__attributes, key, attribute);
            return true;
        }
        return false;
    }

    private String calculateFeedbackAttributeKey(int payloadType, String feedbackAttributeType, String subType) {
        String str = StringExtensions.isNullOrEmpty(feedbackAttributeType) ? "null" : feedbackAttributeType;
        String str2 = StringExtensions.isNullOrEmpty(subType) ? "null" : subType;
        String str3 = IntegerExtensions.toString(payloadType);
        return StringExtensions.concat(new String[]{str, "&", str2, "&", str3});
    }

    public void clear() {
        this.__attributes.clear();
    }

    public boolean remove(FeedbackAttribute attribute) {
        String key = this.calculateFeedbackAttributeKey(attribute.getPayloadType(), attribute.getType(), attribute.getSubType());
        return HashMapExtensions.remove(this.__attributes, key);
    }

    public FeedbackAttribute[] toArray() {
        ArrayList<FeedbackAttribute> list = new ArrayList<FeedbackAttribute>();
        for (FeedbackAttribute attribute : HashMapExtensions.getValues(this.__attributes)) {
            list.add(attribute);
        }
        return list.toArray(new FeedbackAttribute[0]);
    }

    public boolean tryGetFeedbackAttribute(int payloadType, String feedbackAttributeType, String subType, Holder<FeedbackAttribute> feedbackAttribute) {
        FeedbackAttribute attribute = null;
        String key = this.calculateFeedbackAttributeKey(payloadType, feedbackAttributeType, subType);
        Holder<Object> _var0 = new Holder<Object>(attribute);
        boolean _var1 = HashMapExtensions.tryGetValue(this.__attributes, key, _var0);
        attribute = _var0.getValue();
        if (_var1) {
            feedbackAttribute.setValue(attribute);
            return true;
        }
        feedbackAttribute.setValue(null);
        return false;
    }
}

