/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.RtpAbsSendTime;
import fm.icelink.RtpHeaderExtensionForm;
import fm.icelink.RtpHeaderExtensionRegistry;
import fm.icelink.RtpHeaderExtensionType;
import fm.icelink.RtpUnknownHeaderExtensionElement;
import fm.icelink.StringExtensions;

abstract class RtpHeaderExtensionElement {
    private RtpHeaderExtensionForm _form;
    private int _id;
    private RtpHeaderExtensionType _type;

    abstract void fillBytes(DataBuffer var1, int var2, IntegerHolder var3);

    public RtpHeaderExtensionForm getForm() {
        return this._form;
    }

    public int getId() {
        return this._id;
    }

    public int getLength() {
        return 1;
    }

    public RtpHeaderExtensionType getType() {
        return this._type;
    }

    static RtpHeaderExtensionElement parseBytes(DataBuffer buf, int offset, RtpHeaderExtensionForm form, RtpHeaderExtensionRegistry registry, IntegerHolder bytesRead) {
        int id;
        int n = id = Global.equals((Object)form, (Object)RtpHeaderExtensionForm.OneByte) ? buf.read4(offset, 0) : buf.read12(offset, 0);
        if (id == 0) {
            bytesRead.setValue(1);
            return null;
        }
        RtpHeaderExtensionType type = registry.registeredTypeForRtpHeaderExtensionId(id);
        RtpHeaderExtensionType type2 = type;
        if (!Global.equals((Object)type2, (Object)RtpHeaderExtensionType.AbsSendTime)) {
            if (!Global.equals((Object)type2, (Object)RtpHeaderExtensionType.Unknown)) {
                throw new RuntimeException(new Exception(StringExtensions.format("Error parsing an RTP Header Extension element of type {0}.", type.toString())));
            }
        } else {
            RtpAbsSendTime _var0 = RtpAbsSendTime.parseBytes(buf, offset, bytesRead);
            return _var0;
        }
        RtpUnknownHeaderExtensionElement _var1 = RtpUnknownHeaderExtensionElement.parseBytes(buf, offset, form, bytesRead);
        return _var1;
    }

    protected RtpHeaderExtensionElement() {
    }

    protected void setForm(RtpHeaderExtensionForm value) {
        this._form = value;
    }

    public void setId(int value) {
        this._id = value;
    }

    protected void setType(RtpHeaderExtensionType value) {
        this._type = value;
    }
}

