/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum LogLevel {
    Verbose(1),
    Debug(2),
    Info(3),
    Warn(4),
    Error(5),
    Fatal(6),
    None(7);

    private final int value;
    private static final Map<Integer, LogLevel> lookup;

    private LogLevel(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static LogLevel getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, LogLevel>();
        for (LogLevel s : EnumSet.allOf(LogLevel.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

