/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataChannelBase;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.IDataStream;
import fm.icelink.IStream;
import fm.icelink.Stream;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;

public abstract class DataStreamBase<TDataChannel extends DataChannelBase<TDataChannel>>
extends Stream
implements IDataStream<TDataChannel>,
IStream {
    @Override
    public Error changeDirection(StreamDirection newDirection) {
        return new Error(ErrorCode.DataStreamDirectionCannotBeChanged, new Exception("Changes to Stream Direction of Data Streams are not permitted."));
    }

    public DataStreamBase() {
        super(StreamType.Application);
    }

    @Override
    public abstract TDataChannel[] getChannels();

    @Override
    public StreamDirection getDirection() {
        return StreamDirection.SendReceive;
    }

    @Override
    StreamDirection getDirectionCapabilities() {
        return StreamDirection.SendReceive;
    }

    @Override
    public String getLabel() {
        return "Data Stream";
    }

    @Override
    public StreamDirection getLocalDirection() {
        return StreamDirection.SendReceive;
    }

    @Override
    public StreamDirection getRemoteDirection() {
        return StreamDirection.SendReceive;
    }

    @Override
    public void setLocalDirection(StreamDirection value) {
        if (!Global.equals((Object)value, (Object)StreamDirection.SendReceive)) {
            throw new RuntimeException(new Exception("Local direction other than SendReceive for DataStreams is not currently supported."));
        }
    }

    @Override
    protected void setRemoteDirection(StreamDirection value) {
        if (!Global.equals((Object)value, (Object)StreamDirection.SendReceive)) {
            throw new RuntimeException(new Exception("Remote direction other than SendReceive for DataStreams is not currently supported."));
        }
    }
}

