/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IntegerHolder;
import fm.icelink.stun.AlternateServerAttribute;
import fm.icelink.stun.Attribute;
import fm.icelink.stun.BindingIndication;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.MessageType;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.SoftwareAttribute;
import fm.icelink.stun.TransactionTransmitCounterAttribute;
import fm.icelink.stun.UnknownAttributesAttribute;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;
import fm.icelink.stun.ice.PriorityAttribute;
import fm.icelink.stun.ice.UseCandidateAttribute;
import fm.icelink.stun.turn.AllocateRequest;
import fm.icelink.stun.turn.AllocateResponse;
import fm.icelink.stun.turn.ChannelBindRequest;
import fm.icelink.stun.turn.ChannelBindResponse;
import fm.icelink.stun.turn.ChannelNumberAttribute;
import fm.icelink.stun.turn.ConnectRequest;
import fm.icelink.stun.turn.ConnectResponse;
import fm.icelink.stun.turn.ConnectionAttemptIndication;
import fm.icelink.stun.turn.ConnectionBindRequest;
import fm.icelink.stun.turn.ConnectionBindResponse;
import fm.icelink.stun.turn.ConnectionIdAttribute;
import fm.icelink.stun.turn.CreatePermissionRequest;
import fm.icelink.stun.turn.CreatePermissionResponse;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DataIndication;
import fm.icelink.stun.turn.DontFragmentAttribute;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RefreshRequest;
import fm.icelink.stun.turn.RefreshResponse;
import fm.icelink.stun.turn.RequestedAddressFamilyAttribute;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.ReservationTokenAttribute;
import fm.icelink.stun.turn.SendIndication;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;
import java.util.ArrayList;

public abstract class Message {
    private ArrayList<Attribute> _attributeList;
    private static byte[] _magicCookieBytes;
    private MessageType _messageType;
    private DataBuffer _transactionId;

    public static Message createMessage(int method, MessageType messageType, DataBuffer transactionId) {
        if (method == Message.getBindingMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new BindingRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.Indication)) {
                return new BindingIndication();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new BindingResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new BindingResponse(transactionId, false);
            }
        } else if (method == Message.getAllocateMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new AllocateRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new AllocateResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new AllocateResponse(transactionId, false);
            }
        } else if (method == Message.getRefreshMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new RefreshRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new RefreshResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new RefreshResponse(transactionId, false);
            }
        } else if (method == Message.getSendMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Indication)) {
                return new SendIndication();
            }
        } else if (method == Message.getDataMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Indication)) {
                return new DataIndication();
            }
        } else if (method == Message.getCreatePermissionMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new CreatePermissionRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new CreatePermissionResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new CreatePermissionResponse(transactionId, false);
            }
        } else if (method == Message.getChannelBindMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new ChannelBindRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new ChannelBindResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new ChannelBindResponse(transactionId, false);
            }
        } else if (method == Message.getConnectMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new ConnectRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new ConnectResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new ConnectResponse(transactionId, false);
            }
        } else if (method == Message.getConnectionBindMethod()) {
            if (Global.equals((Object)messageType, (Object)MessageType.Request)) {
                return new ConnectionBindRequest();
            }
            if (Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
                return new ConnectionBindResponse(transactionId, true);
            }
            if (Global.equals((Object)messageType, (Object)MessageType.ErrorResponse)) {
                return new ConnectionBindResponse(transactionId, false);
            }
        } else if (method == Message.getConnectionAttemptMethod() && Global.equals((Object)messageType, (Object)MessageType.Indication)) {
            return new ConnectionAttemptIndication();
        }
        return null;
    }

    protected static DataBuffer generateTransactionId() {
        return DataBuffer.wrap(Guid.newGuid().toByteArray(), 0, 12);
    }

    public static int getAllocateMethod() {
        return 3;
    }

    public AlternateServerAttribute getAlternateServer() {
        return (AlternateServerAttribute)this.getAttribute(Attribute.getAlternateServerType());
    }

    private Attribute getAttribute(int typeValue) {
        for (Attribute attribute : this.getAttributeList()) {
            if (attribute.getTypeValue() != typeValue) continue;
            return attribute;
        }
        return null;
    }

    private ArrayList<Attribute> getAttributeList() {
        return this._attributeList;
    }

    public Attribute[] getAttributes() {
        return this.getAttributeList().toArray(new Attribute[0]);
    }

    public static int getBindingMethod() {
        return 1;
    }

    public static int getChannelBindMethod() {
        return 9;
    }

    public ChannelNumberAttribute getChannelNumber() {
        return (ChannelNumberAttribute)this.getAttribute(Attribute.getChannelNumberType());
    }

    public static int getConnectionAttemptMethod() {
        return 12;
    }

    public static int getConnectionBindMethod() {
        return 11;
    }

    public ConnectionIdAttribute getConnectionId() {
        return (ConnectionIdAttribute)this.getAttribute(Attribute.getConnectionIdType());
    }

    public static int getConnectMethod() {
        return 10;
    }

    public static int getCreatePermissionMethod() {
        return 8;
    }

    public DataAttribute getData() {
        return (DataAttribute)this.getAttribute(Attribute.getDataType());
    }

    public static int getDataMethod() {
        return 7;
    }

    public DontFragmentAttribute getDontFragment() {
        return (DontFragmentAttribute)this.getAttribute(Attribute.getDontFragmentType());
    }

    public ErrorCodeAttribute getErrorCode() {
        return (ErrorCodeAttribute)this.getAttribute(Attribute.getErrorCodeType());
    }

    public EvenPortAttribute getEvenPort() {
        return (EvenPortAttribute)this.getAttribute(Attribute.getEvenPortType());
    }

    public FingerprintAttribute getFingerprint() {
        return (FingerprintAttribute)this.getAttribute(Attribute.getFingerprintType());
    }

    public ControlledAttribute getIceControlled() {
        return (ControlledAttribute)this.getAttribute(Attribute.getControlledType());
    }

    public ControllingAttribute getIceControlling() {
        return (ControllingAttribute)this.getAttribute(Attribute.getControllingType());
    }

    public int getLength() {
        return 20 + this.getPayloadLength();
    }

    public LifetimeAttribute getLifetime() {
        return (LifetimeAttribute)this.getAttribute(Attribute.getLifetimeType());
    }

    public static byte[] getMagicCookieBytes() {
        return _magicCookieBytes;
    }

    public static long getMagicCookieValue() {
        return 554869826L;
    }

    public MappedAddressAttribute getMappedAddress() {
        return (MappedAddressAttribute)this.getAttribute(Attribute.getMappedAddressType());
    }

    public MessageIntegrityAttribute getMessageIntegrity() {
        return (MessageIntegrityAttribute)this.getAttribute(Attribute.getMessageIntegrityType());
    }

    public MessageType getMessageType() {
        return this._messageType;
    }

    public abstract int getMethod();

    public NonceAttribute getNonce() {
        return (NonceAttribute)this.getAttribute(Attribute.getNonceType());
    }

    public int getPayloadLength() {
        int num = 0;
        for (Attribute attribute : this.getAttributeList()) {
            num += attribute.getLength();
        }
        return num;
    }

    public PriorityAttribute getPriority() {
        return (PriorityAttribute)this.getAttribute(Attribute.getPriorityType());
    }

    public RealmAttribute getRealm() {
        return (RealmAttribute)this.getAttribute(Attribute.getRealmType());
    }

    public static int getRefreshMethod() {
        return 4;
    }

    public RequestedAddressFamilyAttribute getRequestedAddressFamily() {
        return (RequestedAddressFamilyAttribute)this.getAttribute(Attribute.getRequestedAddressFamilyType());
    }

    public RequestedTransportAttribute getRequestedTransport() {
        return (RequestedTransportAttribute)this.getAttribute(Attribute.getRequestedTransportType());
    }

    public ReservationTokenAttribute getReservationToken() {
        return (ReservationTokenAttribute)this.getAttribute(Attribute.getReservationTokenType());
    }

    public static int getSendMethod() {
        return 6;
    }

    public SoftwareAttribute getSoftware() {
        return (SoftwareAttribute)this.getAttribute(Attribute.getSoftwareType());
    }

    public DataBuffer getTransactionId() {
        return this._transactionId;
    }

    public TransactionTransmitCounterAttribute getTransactionTransmitCounter() {
        return (TransactionTransmitCounterAttribute)this.getAttribute(Attribute.getTransactionTransmitCounterType());
    }

    public UnknownAttributesAttribute getUnknownAttributes() {
        return (UnknownAttributesAttribute)this.getAttribute(Attribute.getUnknownAttributesType());
    }

    public UseCandidateAttribute getUseCandidate() {
        return (UseCandidateAttribute)this.getAttribute(Attribute.getUseCandidateType());
    }

    public UsernameAttribute getUsername() {
        return (UsernameAttribute)this.getAttribute(Attribute.getUsernameType());
    }

    public XorMappedAddressAttribute getXorMappedAddress() {
        return (XorMappedAddressAttribute)this.getAttribute(Attribute.getXorMappedAddressType());
    }

    public XorPeerAddressAttribute getXorPeerAddress() {
        return (XorPeerAddressAttribute)this.getAttribute(Attribute.getXorPeerAddressType());
    }

    public XorRelayedAddressAttribute getXorRelayedAddress() {
        return (XorRelayedAddressAttribute)this.getAttribute(Attribute.getXorRelayedAddressType());
    }

    protected Message(MessageType messageType, DataBuffer transactionId) {
        if (transactionId.getLength() != 12) {
            throw new RuntimeException(new Exception("transactionId must be exactly 12 bytes."));
        }
        this.setMessageType(messageType);
        this.setTransactionId(transactionId);
        this.setAttributeList(new ArrayList<Attribute>());
    }

    public static Message readFrom(DataBuffer buffer) {
        return Message.readFrom(buffer, 0);
    }

    public static Message readFrom(DataBuffer buffer, int offset) {
        int length = 0;
        IntegerHolder _var0 = new IntegerHolder(length);
        Message _var1 = Message.readFrom(buffer, offset, _var0);
        length = _var0.getValue();
        return _var1;
    }

    public static Message readFrom(DataBuffer buffer, int offset, IntegerHolder length) {
        if (buffer == null || buffer.getLength() < 20 || buffer.read8(offset) > 1) {
            length.setValue(0);
            return null;
        }
        int num = offset;
        IntegerHolder _var0 = new IntegerHolder(offset);
        int _var1 = buffer.read8(offset, _var0);
        offset = _var0.getValue();
        int num2 = _var1 & 1;
        int method = buffer.read8(offset) & 0xF;
        IntegerHolder _var2 = new IntegerHolder(offset);
        int _var3 = buffer.read8(offset, _var2);
        offset = _var2.getValue();
        int num4 = _var3 & 0x10;
        MessageType request = MessageType.Request;
        if (num2 == 1 && num4 == 0) {
            request = MessageType.SuccessResponse;
        } else if (num2 == 1 && num4 == 16) {
            request = MessageType.ErrorResponse;
        } else if (num2 == 0 && num4 == 16) {
            request = MessageType.Indication;
        }
        IntegerHolder _var4 = new IntegerHolder(offset);
        int _var5 = buffer.read16(offset, _var4);
        offset = _var4.getValue();
        int num5 = _var5;
        length.setValue(20 + num5);
        if (length.getValue() > buffer.getLength()) {
            return null;
        }
        IntegerHolder _var6 = new IntegerHolder(offset);
        long _var7 = buffer.read32(offset, _var6);
        offset = _var6.getValue();
        if (_var7 != Message.getMagicCookieValue()) {
            return null;
        }
        DataBuffer transactionId = buffer.subset(offset, 12);
        offset += 12;
        Message message = Message.createMessage(method, request, transactionId);
        message.setTransactionId(transactionId);
        int num6;
        while ((num6 = offset - num) != length.getValue() && Attribute.nextLength(buffer, offset) != -1) {
            IntegerHolder _var8 = new IntegerHolder(offset);
            Attribute _var9 = Attribute.readFrom(buffer, offset, _var8, transactionId, buffer.subset(num, offset));
            offset = _var8.getValue();
            Attribute attribute = _var9;
            if (attribute == null) continue;
            message.setAttribute(attribute);
        }
        return message;
    }

    public void setAlternateServer(AlternateServerAttribute attribute) {
        this.setAttribute(attribute);
    }

    private void setAttribute(Attribute attribute) {
        for (int i = 0; i < ArrayListExtensions.getCount(this.getAttributeList()); ++i) {
            Attribute attribute2 = ArrayListExtensions.getItem(this.getAttributeList()).get(i);
            if (attribute2.getTypeValue() != attribute.getTypeValue()) continue;
            ArrayListExtensions.removeAt(this.getAttributeList(), i);
            --i;
        }
        this.getAttributeList().add(attribute);
    }

    private void setAttributeList(ArrayList<Attribute> value) {
        this._attributeList = value;
    }

    public void setChannelNumber(ChannelNumberAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setConnectionId(ConnectionIdAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setData(DataAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setDontFragment(DontFragmentAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setErrorCode(ErrorCodeAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setEvenPort(EvenPortAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setFingerprint(FingerprintAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setIceControlled(ControlledAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setIceControlling(ControllingAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setLifetime(LifetimeAttribute attribute) {
        this.setAttribute(attribute);
    }

    private static void setMagicCookieBytes(byte[] value) {
        _magicCookieBytes = value;
    }

    public void setMappedAddress(MappedAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setMessageIntegrity(MessageIntegrityAttribute attribute) {
        this.setAttribute(attribute);
    }

    private void setMessageType(MessageType value) {
        this._messageType = value;
    }

    public void setNonce(NonceAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setPriority(PriorityAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setRealm(RealmAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setRequestedAddressFamily(RequestedAddressFamilyAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setRequestedTransport(RequestedTransportAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setReservationToken(ReservationTokenAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setSoftware(SoftwareAttribute attribute) {
        this.setAttribute(attribute);
    }

    private void setTransactionId(DataBuffer value) {
        this._transactionId = value;
    }

    public void setTransactionTransmitCounter(TransactionTransmitCounterAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setUnknownAttributes(UnknownAttributesAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setUseCandidate(UseCandidateAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setUsername(UsernameAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setXorMappedAddress(XorMappedAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setXorPeerAddress(XorPeerAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setXorRelayedAddress(XorRelayedAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void writeTo(DataBuffer buffer) {
        this.writeTo(buffer, 0);
    }

    public void writeTo(DataBuffer buffer, int offset) {
        int num = offset;
        if (Global.equals((Object)this.getMessageType(), (Object)MessageType.Request) || Global.equals((Object)this.getMessageType(), (Object)MessageType.Indication)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            boolean _var1 = buffer.write8(0, offset, _var0);
            offset = _var0.getValue();
        } else {
            IntegerHolder _var2 = new IntegerHolder(offset);
            boolean _var3 = buffer.write8(1, offset, _var2);
            offset = _var2.getValue();
        }
        if (Global.equals((Object)this.getMessageType(), (Object)MessageType.Request) || Global.equals((Object)this.getMessageType(), (Object)MessageType.SuccessResponse)) {
            IntegerHolder _var4 = new IntegerHolder(offset);
            boolean _var5 = buffer.write8(this.getMethod(), offset, _var4);
            offset = _var4.getValue();
        } else {
            IntegerHolder _var6 = new IntegerHolder(offset);
            boolean _var7 = buffer.write8(this.getMethod() | 0x10, offset, _var6);
            offset = _var6.getValue();
        }
        IntegerHolder _var8 = new IntegerHolder(offset);
        boolean _var9 = buffer.write16(this.getPayloadLength(), offset, _var8);
        offset = _var8.getValue();
        IntegerHolder _var10 = new IntegerHolder(offset);
        boolean _var11 = buffer.write32(Message.getMagicCookieValue(), offset, _var10);
        offset = _var10.getValue();
        IntegerHolder _var12 = new IntegerHolder(offset);
        buffer.write(this.getTransactionId(), offset, _var12);
        offset = _var12.getValue();
        MessageIntegrityAttribute messageIntegrity = this.getMessageIntegrity();
        FingerprintAttribute fingerprint = this.getFingerprint();
        for (Attribute attribute3 : this.getAttributeList()) {
            if (Global.equals(attribute3, messageIntegrity) || Global.equals(attribute3, fingerprint)) continue;
            IntegerHolder _var13 = new IntegerHolder(offset);
            attribute3.writeTo(buffer, offset, _var13);
            offset = _var13.getValue();
        }
        if (messageIntegrity != null) {
            messageIntegrity.setMessageBuffer(buffer.subset(num, offset));
            IntegerHolder _var14 = new IntegerHolder(offset);
            messageIntegrity.writeTo(buffer, offset, _var14);
            offset = _var14.getValue();
        }
        if (fingerprint != null) {
            fingerprint.setMessageBuffer(buffer.subset(num, offset));
            IntegerHolder _var15 = new IntegerHolder(offset);
            fingerprint.writeTo(buffer, offset, _var15);
            offset = _var15.getValue();
        }
    }

    public void writeTo(DataBuffer buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + this.getLength());
        this.writeTo(buffer, offset);
    }

    static {
        Message.setMagicCookieBytes(new byte[]{33, 18, -92, 66});
    }
}

