/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;

class SctpGapAckBlock {
    private int _gapAckBlockEnd;
    private int _gapAckBlockStart;

    public byte[] getBytes() {
        return SctpGapAckBlock.getBytes(this);
    }

    public static byte[] getBytes(SctpGapAckBlock chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(chunk.getGapAckBlockStart(), false));
        bytes.addRange(Binary.toBytes16(chunk.getGapAckBlockEnd(), false));
        return bytes.toArray();
    }

    public int getGapAckBlockEnd() {
        return this._gapAckBlockEnd;
    }

    public int getGapAckBlockStart() {
        return this._gapAckBlockStart;
    }

    public static SctpGapAckBlock parseBytes(byte[] value, int startIndex, IntegerHolder offsetPlus) {
        try {
            byte[] destination = new byte[ArrayExtensions.getLength(value) - startIndex];
            BitAssistant.copy(value, startIndex, destination, 0, ArrayExtensions.getLength(destination));
            int start = Binary.fromBytes16(destination, 0, false);
            int end = Binary.fromBytes16(destination, 2, false);
            offsetPlus.setValue(4);
            return new SctpGapAckBlock(start, end);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpGapAckBlock(int start, int end) {
        this.setGapAckBlockStart(start);
        this.setGapAckBlockEnd(end);
    }

    public void setGapAckBlockEnd(int value) {
        this._gapAckBlockEnd = value;
    }

    public void setGapAckBlockStart(int value) {
        this._gapAckBlockStart = value;
    }
}

