/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecContext;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;
import fm.icelink.AudioTrack;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioOutput;
import fm.icelink.IVideoInput;
import fm.icelink.IViewSinkableMedia;
import fm.icelink.IViewableMedia;
import fm.icelink.Log;
import fm.icelink.MediaSink;
import fm.icelink.MediaTrack;
import fm.icelink.RemoteMedia;
import fm.icelink.SoundConverter;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoTrack;
import fm.icelink.ViewSink;
import fm.icelink.pcmu.Decoder;
import fm.icelink.vp8.Depacketizer;
import java.util.ArrayList;
import java.util.List;

public abstract class RtcRemoteMedia<TView>
extends RemoteMedia
implements IViewSinkableMedia<TView, ViewSink<TView>>,
IViewableMedia<TView> {
    private ArrayList<AudioSink> __audioRecorders;
    private boolean __initialized = false;
    private Object __initializeLock;
    private List<IAction1<AudioPipe>> __onActiveAudioConverterChange = new ArrayList<IAction1<AudioPipe>>();
    private List<IAction1<AudioDecoder>> __onActiveAudioDecoderChange = new ArrayList<IAction1<AudioDecoder>>();
    private List<IAction1<AudioPipe>> __onActiveAudioDepacketizerChange = new ArrayList<IAction1<AudioPipe>>();
    private List<IAction1<AudioSink>> __onActiveAudioSinkChange = new ArrayList<IAction1<AudioSink>>();
    private List<IAction1<VideoPipe>> __onActiveVideoConverterChange = new ArrayList<IAction1<VideoPipe>>();
    private List<IAction1<VideoDecoder>> __onActiveVideoDecoderChange = new ArrayList<IAction1<VideoDecoder>>();
    private List<IAction1<VideoPipe>> __onActiveVideoDepacketizerChange = new ArrayList<IAction1<VideoPipe>>();
    private AudioConfig __opusConfig = new AudioConfig(48000, 2);
    private AudioConfig __pcmaConfig;
    private AudioConfig __pcmuConfig = new AudioConfig(8000, 1);
    private ArrayList<VideoSink> __videoRecorders;
    private AudioPipe _activeAudioConverter;
    private AudioDecoder _activeAudioDecoder;
    private AudioPipe _activeAudioDepacketizer;
    private AudioSink _activeAudioSink;
    private VideoPipe _activeVideoConverter;
    private VideoDecoder _activeVideoDecoder;
    private VideoPipe _activeVideoDepacketizer;
    private AecContext _aecContext;
    private boolean _audioDisabled;
    private Object _audioRecordingLock;
    private VideoPipe _h264Converter;
    private VideoDecoder _h264Decoder;
    private VideoPipe _h264Depacketizer;
    private IAction1<AudioPipe> _onActiveAudioConverterChange = null;
    private IAction1<AudioDecoder> _onActiveAudioDecoderChange = null;
    private IAction1<AudioPipe> _onActiveAudioDepacketizerChange = null;
    private IAction1<AudioSink> _onActiveAudioSinkChange = null;
    private IAction1<VideoPipe> _onActiveVideoConverterChange = null;
    private IAction1<VideoDecoder> _onActiveVideoDecoderChange = null;
    private IAction1<VideoPipe> _onActiveVideoDepacketizerChange = null;
    private AudioPipe _opusConverter;
    private AudioDecoder _opusDecoder;
    private AudioPipe _opusDepacketizer;
    private AudioSink _opusSink;
    private AudioPipe _pcmaConverter;
    private AudioDecoder _pcmaDecoder;
    private AudioPipe _pcmaDepacketizer;
    private AudioSink _pcmaSink;
    private AudioPipe _pcmuConverter;
    private AudioDecoder _pcmuDecoder;
    private AudioPipe _pcmuDepacketizer;
    private AudioSink _pcmuSink;
    private boolean _videoDisabled;
    private Object _videoRecordingLock;
    private ViewSink<TView> _viewSink;
    private VideoPipe _vp8Converter;
    private VideoDecoder _vp8Decoder;
    private VideoPipe _vp8Depacketizer;
    private VideoPipe _vp9Converter;
    private VideoDecoder _vp9Decoder;
    private VideoPipe _vp9Depacketizer;

    public void addOnActiveAudioConverterChange(IAction1<AudioPipe> value) {
        if (value != null) {
            if (this._onActiveAudioConverterChange == null) {
                this._onActiveAudioConverterChange = new IAction1<AudioPipe>(){

                    @Override
                    public void invoke(AudioPipe p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveAudioConverterChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioConverterChange.add(value);
        }
    }

    public void addOnActiveAudioDecoderChange(IAction1<AudioDecoder> value) {
        if (value != null) {
            if (this._onActiveAudioDecoderChange == null) {
                this._onActiveAudioDecoderChange = new IAction1<AudioDecoder>(){

                    @Override
                    public void invoke(AudioDecoder p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveAudioDecoderChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioDecoderChange.add(value);
        }
    }

    public void addOnActiveAudioDepacketizerChange(IAction1<AudioPipe> value) {
        if (value != null) {
            if (this._onActiveAudioDepacketizerChange == null) {
                this._onActiveAudioDepacketizerChange = new IAction1<AudioPipe>(){

                    @Override
                    public void invoke(AudioPipe p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveAudioDepacketizerChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioDepacketizerChange.add(value);
        }
    }

    public void addOnActiveAudioSinkChange(IAction1<AudioSink> value) {
        if (value != null) {
            if (this._onActiveAudioSinkChange == null) {
                this._onActiveAudioSinkChange = new IAction1<AudioSink>(){

                    @Override
                    public void invoke(AudioSink p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveAudioSinkChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveAudioSinkChange.add(value);
        }
    }

    public void addOnActiveVideoConverterChange(IAction1<VideoPipe> value) {
        if (value != null) {
            if (this._onActiveVideoConverterChange == null) {
                this._onActiveVideoConverterChange = new IAction1<VideoPipe>(){

                    @Override
                    public void invoke(VideoPipe p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveVideoConverterChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveVideoConverterChange.add(value);
        }
    }

    public void addOnActiveVideoDecoderChange(IAction1<VideoDecoder> value) {
        if (value != null) {
            if (this._onActiveVideoDecoderChange == null) {
                this._onActiveVideoDecoderChange = new IAction1<VideoDecoder>(){

                    @Override
                    public void invoke(VideoDecoder p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveVideoDecoderChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveVideoDecoderChange.add(value);
        }
    }

    public void addOnActiveVideoDepacketizerChange(IAction1<VideoPipe> value) {
        if (value != null) {
            if (this._onActiveVideoDepacketizerChange == null) {
                this._onActiveVideoDepacketizerChange = new IAction1<VideoPipe>(){

                    @Override
                    public void invoke(VideoPipe p0) {
                        for (IAction1 action : new ArrayList(RtcRemoteMedia.this.__onActiveVideoDepacketizerChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onActiveVideoDepacketizerChange.add(value);
        }
    }

    protected abstract AudioSink createAudioRecorder(AudioFormat var1);

    protected abstract AudioSink createAudioSink(AudioConfig var1);

    private AudioTrack createAudioTrack(final AudioPipe depacketizer, final AudioDecoder decoder, final AudioPipe converter, final AudioSink sink) {
        IAction1<AudioFrame> action = null;
        IAction1<AudioFrame> action2 = null;
        AudioTrack track = new AudioTrack(depacketizer);
        depacketizer.addOnProcessFrame(new IAction1<AudioFrame>(){

            @Override
            public void invoke(AudioFrame frame) {
                if (!Global.equals(RtcRemoteMedia.this.getActiveAudioDepacketizer(), depacketizer)) {
                    RtcRemoteMedia.this.setActiveAudioDepacketizer(depacketizer);
                    IAction1 onActiveAudioDepacketizerChange = RtcRemoteMedia.this._onActiveAudioDepacketizerChange;
                    if (onActiveAudioDepacketizerChange != null) {
                        onActiveAudioDepacketizerChange.invoke(depacketizer);
                    }
                }
            }
        });
        ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        AudioSink audioRecorder = this.getAudioRecorder((AudioFormat)depacketizer.getOutputFormat());
        if (audioRecorder != null) {
            list.add(new AudioTrack(audioRecorder));
        }
        AudioTrack item = new AudioTrack(decoder);
        decoder.addOnProcessFrame(new IAction1<AudioFrame>(){

            @Override
            public void invoke(AudioFrame frame) {
                if (!Global.equals(RtcRemoteMedia.this.getActiveAudioDecoder(), decoder)) {
                    RtcRemoteMedia.this.setActiveAudioDecoder(decoder);
                    IAction1 onActiveAudioDecoderChange = RtcRemoteMedia.this._onActiveAudioDecoderChange;
                    if (onActiveAudioDecoderChange != null) {
                        onActiveAudioDecoderChange.invoke(decoder);
                    }
                }
            }
        });
        if (this.getAecDisabled()) {
            if (action == null) {
                action = new IAction1<AudioFrame>(){

                    @Override
                    public void invoke(AudioFrame frame) {
                        if (!Global.equals(RtcRemoteMedia.this.getActiveAudioSink(), sink)) {
                            RtcRemoteMedia.this.setActiveAudioSink(sink);
                            IAction1 onActiveAudioSinkChange = RtcRemoteMedia.this._onActiveAudioSinkChange;
                            if (onActiveAudioSinkChange != null) {
                                onActiveAudioSinkChange.invoke(sink);
                            }
                        }
                    }
                };
            }
            sink.addOnProcessFrame(action);
            item = (AudioTrack)item.next(sink);
        } else {
            if (action2 == null) {
                action2 = new IAction1<AudioFrame>(){

                    @Override
                    public void invoke(AudioFrame frame) {
                        if (!Global.equals(RtcRemoteMedia.this.getActiveAudioConverter(), converter)) {
                            RtcRemoteMedia.this.setActiveAudioConverter(converter);
                            IAction1 onActiveAudioConverterChange = RtcRemoteMedia.this._onActiveAudioConverterChange;
                            if (onActiveAudioConverterChange != null) {
                                onActiveAudioConverterChange.invoke(converter);
                            }
                        }
                    }
                };
            }
            converter.addOnProcessFrame(action2);
            item = (AudioTrack)((AudioTrack)item.next(converter)).next(new AudioTrack[]{this.getAecContext().getOutputTrack()});
            this.setActiveAudioSink(this.getAecContext().getOutputMixerSink());
        }
        list.add(item);
        return (AudioTrack)track.next((MediaTrack[])list.toArray(new AudioTrack[0]));
    }

    protected abstract VideoDecoder createH264Decoder();

    protected VideoPipe createH264Depacketizer() {
        return new fm.icelink.h264.Depacketizer();
    }

    protected abstract VideoPipe createImageConverter(VideoFormat var1);

    protected abstract AudioDecoder createOpusDecoder(AudioConfig var1);

    protected AudioPipe createOpusDepacketizer(AudioConfig config) {
        return new fm.icelink.opus.Depacketizer(config);
    }

    protected AudioDecoder createPcmaDecoder(AudioConfig config) {
        return new fm.icelink.pcma.Decoder(config);
    }

    protected AudioPipe createPcmaDepacketizer(AudioConfig config) {
        return new fm.icelink.pcma.Depacketizer(config);
    }

    protected AudioDecoder createPcmuDecoder(AudioConfig config) {
        return new Decoder(config);
    }

    protected AudioPipe createPcmuDepacketizer(AudioConfig config) {
        return new fm.icelink.pcmu.Depacketizer(config);
    }

    protected AudioPipe createSoundConverter(AudioConfig config) {
        return new SoundConverter(config);
    }

    protected abstract VideoSink createVideoRecorder(VideoFormat var1);

    private VideoTrack createVideoTrack(final VideoPipe depacketizer, final VideoDecoder decoder, final VideoPipe converter) {
        VideoTrack track = new VideoTrack(depacketizer);
        depacketizer.addOnProcessFrame(new IAction1<VideoFrame>(){

            @Override
            public void invoke(VideoFrame frame) {
                if (!Global.equals(RtcRemoteMedia.this.getActiveVideoDepacketizer(), depacketizer)) {
                    RtcRemoteMedia.this.setActiveVideoDepacketizer(depacketizer);
                    IAction1 onActiveVideoDepacketizerChange = RtcRemoteMedia.this._onActiveVideoDepacketizerChange;
                    if (onActiveVideoDepacketizerChange != null) {
                        onActiveVideoDepacketizerChange.invoke(depacketizer);
                    }
                }
            }
        });
        ArrayList<VideoTrack> list = new ArrayList<VideoTrack>();
        VideoSink videoRecorder = this.getVideoRecorder((VideoFormat)depacketizer.getOutputFormat());
        if (videoRecorder != null) {
            list.add(new VideoTrack(videoRecorder));
        }
        VideoTrack item = new VideoTrack(decoder);
        decoder.addOnProcessFrame(new IAction1<VideoFrame>(){

            @Override
            public void invoke(VideoFrame frame) {
                if (!Global.equals(RtcRemoteMedia.this.getActiveVideoDecoder(), decoder)) {
                    RtcRemoteMedia.this.setActiveVideoDecoder(decoder);
                    IAction1 onActiveVideoDecoderChange = RtcRemoteMedia.this._onActiveVideoDecoderChange;
                    if (onActiveVideoDecoderChange != null) {
                        onActiveVideoDecoderChange.invoke(decoder);
                    }
                }
            }
        });
        item = (VideoTrack)item.next(converter);
        converter.addOnProcessFrame(new IAction1<VideoFrame>(){

            @Override
            public void invoke(VideoFrame frame) {
                if (!Global.equals(RtcRemoteMedia.this.getActiveVideoConverter(), converter)) {
                    RtcRemoteMedia.this.setActiveVideoConverter(converter);
                    IAction1 onActiveVideoConverterChange = RtcRemoteMedia.this._onActiveVideoConverterChange;
                    if (onActiveVideoConverterChange != null) {
                        onActiveVideoConverterChange.invoke(converter);
                    }
                }
            }
        });
        list.add(item);
        return (VideoTrack)track.next((MediaTrack[])list.toArray(new VideoTrack[0]));
    }

    protected abstract ViewSink<TView> createViewSink();

    protected abstract VideoDecoder createVp8Decoder();

    protected VideoPipe createVp8Depacketizer() {
        return new Depacketizer();
    }

    protected abstract VideoDecoder createVp9Decoder();

    protected VideoPipe createVp9Depacketizer() {
        return new fm.icelink.vp9.Depacketizer();
    }

    @Override
    public void destroy() {
        if (!this.getAecDisabled()) {
            for (IAudioOutput output : (IAudioOutput[])((AudioTrack)super.getAudioTrack()).getOutputs()) {
                output.removeOutput(this.getAecContext().getOutputMixer());
            }
        }
        for (AudioSink sink : this.__audioRecorders) {
            if (sink.getPersistent()) continue;
            sink.destroy();
        }
        for (VideoSink sink2 : this.__videoRecorders) {
            if (sink2.getPersistent()) continue;
            sink2.destroy();
        }
        super.destroy();
    }

    public AudioPipe getActiveAudioConverter() {
        return this._activeAudioConverter;
    }

    public AudioDecoder getActiveAudioDecoder() {
        return this._activeAudioDecoder;
    }

    public AudioPipe getActiveAudioDepacketizer() {
        return this._activeAudioDepacketizer;
    }

    public AudioSink getActiveAudioSink() {
        return this._activeAudioSink;
    }

    public VideoPipe getActiveVideoConverter() {
        return this._activeVideoConverter;
    }

    public VideoDecoder getActiveVideoDecoder() {
        return this._activeVideoDecoder;
    }

    public VideoPipe getActiveVideoDepacketizer() {
        return this._activeVideoDepacketizer;
    }

    public AecContext getAecContext() {
        return this._aecContext;
    }

    public boolean getAecDisabled() {
        return this.getAecContext() == null || this.getAudioDisabled();
    }

    public boolean getAudioDisabled() {
        return this._audioDisabled;
    }

    public IAudioInput[] getAudioInputs() {
        return (IAudioInput[])((AudioTrack)super.getAudioTrack()).getInputs();
    }

    private AudioSink getAudioRecorder(AudioFormat inputFormat) {
        AudioSink item = this.createAudioRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__audioRecorders.add(item);
        }
        return item;
    }

    public VideoPipe getH264Converter() {
        return this._h264Converter;
    }

    public VideoDecoder getH264Decoder() {
        return this._h264Decoder;
    }

    public VideoPipe getH264Depacketizer() {
        return this._h264Depacketizer;
    }

    public AudioPipe getOpusConverter() {
        return this._opusConverter;
    }

    public AudioDecoder getOpusDecoder() {
        return this._opusDecoder;
    }

    public AudioPipe getOpusDepacketizer() {
        return this._opusDepacketizer;
    }

    public AudioSink getOpusSink() {
        return this._opusSink;
    }

    public AudioPipe getPcmaConverter() {
        return this._pcmaConverter;
    }

    public AudioDecoder getPcmaDecoder() {
        return this._pcmaDecoder;
    }

    public AudioPipe getPcmaDepacketizer() {
        return this._pcmaDepacketizer;
    }

    public AudioSink getPcmaSink() {
        return this._pcmaSink;
    }

    public AudioPipe getPcmuConverter() {
        return this._pcmuConverter;
    }

    public AudioDecoder getPcmuDecoder() {
        return this._pcmuDecoder;
    }

    public AudioPipe getPcmuDepacketizer() {
        return this._pcmuDepacketizer;
    }

    public AudioSink getPcmuSink() {
        return this._pcmuSink;
    }

    public boolean getVideoDisabled() {
        return this._videoDisabled;
    }

    public IVideoInput[] getVideoInputs() {
        return (IVideoInput[])((VideoTrack)super.getVideoTrack()).getInputs();
    }

    private VideoSink getVideoRecorder(VideoFormat inputFormat) {
        VideoSink item = this.createVideoRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__videoRecorders.add(item);
        }
        return item;
    }

    @Override
    public TView getView() {
        return this.getViewSink() == null ? null : (TView)((ViewSink)this.getViewSink()).getView();
    }

    @Override
    public ViewSink<TView> getViewSink() {
        return this._viewSink;
    }

    public VideoPipe getVp8Converter() {
        return this._vp8Converter;
    }

    public VideoDecoder getVp8Decoder() {
        return this._vp8Decoder;
    }

    public VideoPipe getVp8Depacketizer() {
        return this._vp8Depacketizer;
    }

    public VideoPipe getVp9Converter() {
        return this._vp9Converter;
    }

    public VideoDecoder getVp9Decoder() {
        return this._vp9Decoder;
    }

    public VideoPipe getVp9Depacketizer() {
        return this._vp9Depacketizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        Object object = this.__initializeLock;
        synchronized (object) {
            if (this.__initialized) {
                return false;
            }
            this.__initialized = true;
        }
        try {
            VideoTrack track2;
            AudioTrack track;
            if (this.getAudioDisabled()) {
                track = new AudioTrack();
            } else {
                track = new AudioTrack();
                ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
                this.setOpusDecoder(this.createOpusDecoder(this.__opusConfig));
                if (this.getOpusDecoder() != null) {
                    this.setOpusDepacketizer(this.createOpusDepacketizer(this.getOpusDecoder().getInputConfig()));
                    if (this.getAecDisabled()) {
                        this.setOpusSink(this.createAudioSink(this.getOpusDecoder().getOutputConfig()));
                    } else {
                        this.setOpusConverter(this.createSoundConverter(this.getAecContext().getConfig()));
                        this.setOpusSink(this.getAecContext().getOutputMixerSink());
                    }
                    list.add(this.createAudioTrack(this.getOpusDepacketizer(), this.getOpusDecoder(), this.getOpusConverter(), this.getOpusSink()));
                }
                this.setPcmuDecoder(this.createPcmuDecoder(this.__pcmuConfig));
                if (this.getPcmuDecoder() != null) {
                    this.setPcmuDepacketizer(this.createPcmuDepacketizer(this.getPcmuDecoder().getInputConfig()));
                    if (this.getAecDisabled()) {
                        this.setPcmuSink(this.createAudioSink(this.getPcmuDecoder().getOutputConfig()));
                    } else {
                        this.setPcmuConverter(this.createSoundConverter(this.getAecContext().getConfig()));
                        this.setPcmuSink(this.getAecContext().getOutputMixerSink());
                    }
                    list.add(this.createAudioTrack(this.getPcmuDepacketizer(), this.getPcmuDecoder(), this.getPcmuConverter(), this.getPcmuSink()));
                }
                this.setPcmaDecoder(this.createPcmaDecoder(this.__pcmaConfig));
                if (this.getPcmaDecoder() != null) {
                    this.setPcmaDepacketizer(this.createPcmaDepacketizer(this.getPcmaDecoder().getInputConfig()));
                    if (this.getAecDisabled()) {
                        this.setPcmaSink(this.createAudioSink(this.getPcmaDecoder().getOutputConfig()));
                    } else {
                        this.setPcmaConverter(this.createSoundConverter(this.getAecContext().getConfig()));
                        this.setPcmaSink(this.getAecContext().getOutputMixerSink());
                    }
                    list.add(this.createAudioTrack(this.getPcmaDepacketizer(), this.getPcmaDecoder(), this.getPcmaConverter(), this.getPcmaSink()));
                }
                if (ArrayListExtensions.getCount(list) > 0) {
                    track = (AudioTrack)track.next((MediaTrack[])list.toArray(new AudioTrack[0]));
                }
            }
            this.addAudioTrack(track);
            if (this.getVideoDisabled()) {
                track2 = new VideoTrack();
            } else {
                track2 = new VideoTrack();
                ArrayList<VideoTrack> list2 = new ArrayList<VideoTrack>();
                this.setViewSink(this.createViewSink());
                this.setVp8Decoder(this.createVp8Decoder());
                if (this.getVp8Decoder() != null) {
                    this.setVp8Depacketizer(this.createVp8Depacketizer());
                    if (this.getViewSink() != null) {
                        this.setVp8Converter(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat()));
                    }
                    list2.add(this.createVideoTrack(this.getVp8Depacketizer(), this.getVp8Decoder(), this.getVp8Converter()));
                }
                this.setH264Decoder(this.createH264Decoder());
                if (this.getH264Decoder() != null) {
                    this.setH264Depacketizer(this.createH264Depacketizer());
                    if (this.getViewSink() != null) {
                        this.setH264Converter(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat()));
                    }
                    list2.add(this.createVideoTrack(this.getH264Depacketizer(), this.getH264Decoder(), this.getH264Converter()));
                }
                this.setVp9Decoder(this.createVp9Decoder());
                if (this.getVp9Decoder() != null) {
                    this.setVp9Depacketizer(this.createVp9Depacketizer());
                    if (this.getViewSink() != null) {
                        this.setVp9Converter(this.createImageConverter((VideoFormat)((MediaSink)((Object)this.getViewSink())).getInputFormat()));
                    }
                    list2.add(this.createVideoTrack(this.getVp9Depacketizer(), this.getVp9Decoder(), this.getVp9Converter()));
                }
                if (ArrayListExtensions.getCount(list2) > 0) {
                    track2 = (VideoTrack)track2.next((MediaTrack[])list2.toArray(new VideoTrack[0]));
                }
                if (this.getViewSink() != null) {
                    track2 = (VideoTrack)track2.next(this.getViewSink());
                }
            }
            this.addVideoTrack(track2);
        }
        catch (Exception exception) {
            Log.error("Error occured while initializing remote media.", exception);
            throw new RuntimeException(exception);
        }
        return true;
    }

    public void removeOnActiveAudioConverterChange(IAction1<AudioPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioConverterChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioConverterChange.remove(value);
        if (this.__onActiveAudioConverterChange.size() == 0) {
            this._onActiveAudioConverterChange = null;
        }
    }

    public void removeOnActiveAudioDecoderChange(IAction1<AudioDecoder> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioDecoderChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioDecoderChange.remove(value);
        if (this.__onActiveAudioDecoderChange.size() == 0) {
            this._onActiveAudioDecoderChange = null;
        }
    }

    public void removeOnActiveAudioDepacketizerChange(IAction1<AudioPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioDepacketizerChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioDepacketizerChange.remove(value);
        if (this.__onActiveAudioDepacketizerChange.size() == 0) {
            this._onActiveAudioDepacketizerChange = null;
        }
    }

    public void removeOnActiveAudioSinkChange(IAction1<AudioSink> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveAudioSinkChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveAudioSinkChange.remove(value);
        if (this.__onActiveAudioSinkChange.size() == 0) {
            this._onActiveAudioSinkChange = null;
        }
    }

    public void removeOnActiveVideoConverterChange(IAction1<VideoPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveVideoConverterChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveVideoConverterChange.remove(value);
        if (this.__onActiveVideoConverterChange.size() == 0) {
            this._onActiveVideoConverterChange = null;
        }
    }

    public void removeOnActiveVideoDecoderChange(IAction1<VideoDecoder> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveVideoDecoderChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveVideoDecoderChange.remove(value);
        if (this.__onActiveVideoDecoderChange.size() == 0) {
            this._onActiveVideoDecoderChange = null;
        }
    }

    public void removeOnActiveVideoDepacketizerChange(IAction1<VideoPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onActiveVideoDepacketizerChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onActiveVideoDepacketizerChange.remove(value);
        if (this.__onActiveVideoDepacketizerChange.size() == 0) {
            this._onActiveVideoDepacketizerChange = null;
        }
    }

    public RtcRemoteMedia(boolean disableAudio, boolean disableVideo) {
        this(disableAudio, disableVideo, null);
    }

    public RtcRemoteMedia(boolean disableAudio, boolean disableVideo, AecContext aecContext) {
        this.__pcmaConfig = new AudioConfig(8000, 1);
        this.__audioRecorders = new ArrayList();
        this.__videoRecorders = new ArrayList();
        this.__initializeLock = new Object();
        this._audioRecordingLock = new Object();
        this._videoRecordingLock = new Object();
        this.setAudioDisabled(disableAudio);
        this.setVideoDisabled(disableVideo);
        this.setAecContext(aecContext);
    }

    private void setActiveAudioConverter(AudioPipe value) {
        this._activeAudioConverter = value;
    }

    private void setActiveAudioDecoder(AudioDecoder value) {
        this._activeAudioDecoder = value;
    }

    private void setActiveAudioDepacketizer(AudioPipe value) {
        this._activeAudioDepacketizer = value;
    }

    private void setActiveAudioSink(AudioSink value) {
        this._activeAudioSink = value;
    }

    private void setActiveVideoConverter(VideoPipe value) {
        this._activeVideoConverter = value;
    }

    private void setActiveVideoDecoder(VideoDecoder value) {
        this._activeVideoDecoder = value;
    }

    private void setActiveVideoDepacketizer(VideoPipe value) {
        this._activeVideoDepacketizer = value;
    }

    private void setAecContext(AecContext value) {
        this._aecContext = value;
    }

    private void setAudioDisabled(boolean value) {
        this._audioDisabled = value;
    }

    private void setH264Converter(VideoPipe value) {
        this._h264Converter = value;
    }

    private void setH264Decoder(VideoDecoder value) {
        this._h264Decoder = value;
    }

    private void setH264Depacketizer(VideoPipe value) {
        this._h264Depacketizer = value;
    }

    private void setOpusConverter(AudioPipe value) {
        this._opusConverter = value;
    }

    private void setOpusDecoder(AudioDecoder value) {
        this._opusDecoder = value;
    }

    private void setOpusDepacketizer(AudioPipe value) {
        this._opusDepacketizer = value;
    }

    private void setOpusSink(AudioSink value) {
        this._opusSink = value;
    }

    private void setPcmaConverter(AudioPipe value) {
        this._pcmaConverter = value;
    }

    private void setPcmaDecoder(AudioDecoder value) {
        this._pcmaDecoder = value;
    }

    private void setPcmaDepacketizer(AudioPipe value) {
        this._pcmaDepacketizer = value;
    }

    private void setPcmaSink(AudioSink value) {
        this._pcmaSink = value;
    }

    private void setPcmuConverter(AudioPipe value) {
        this._pcmuConverter = value;
    }

    private void setPcmuDecoder(AudioDecoder value) {
        this._pcmuDecoder = value;
    }

    private void setPcmuDepacketizer(AudioPipe value) {
        this._pcmuDepacketizer = value;
    }

    private void setPcmuSink(AudioSink value) {
        this._pcmuSink = value;
    }

    private void setVideoDisabled(boolean value) {
        this._videoDisabled = value;
    }

    private void setViewSink(ViewSink<TView> value) {
        this._viewSink = value;
    }

    private void setVp8Converter(VideoPipe value) {
        this._vp8Converter = value;
    }

    private void setVp8Decoder(VideoDecoder value) {
        this._vp8Decoder = value;
    }

    private void setVp8Depacketizer(VideoPipe value) {
        this._vp8Depacketizer = value;
    }

    private void setVp9Converter(VideoPipe value) {
        this._vp9Converter = value;
    }

    private void setVp9Decoder(VideoDecoder value) {
        this._vp9Decoder = value;
    }

    private void setVp9Depacketizer(VideoPipe value) {
        this._vp9Depacketizer = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAudioRecording() {
        Object object = this._audioRecordingLock;
        synchronized (object) {
            super.setIsRecordingAudio(!super.getIsRecordingAudio());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingVideo() || super.getIsRecordingAudio());
            }
            for (AudioSink sink : this.__audioRecorders) {
                sink.setDisabled(!super.getIsRecordingAudio());
            }
            return super.getIsRecordingAudio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleVideoRecording() {
        Object object = this._videoRecordingLock;
        synchronized (object) {
            super.setIsRecordingVideo(!super.getIsRecordingVideo());
            if (this.getViewSink() != null) {
                ((ViewSink)this.getViewSink()).setIsRecording(super.getIsRecordingVideo() || super.getIsRecordingAudio());
            }
            for (VideoSink sink : this.__videoRecorders) {
                sink.setDisabled(!super.getIsRecordingVideo());
            }
            return super.getIsRecordingVideo();
        }
    }
}

