/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioTrack;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.MediaBase;
import fm.icelink.MediaTrack;
import fm.icelink.Promise;
import fm.icelink.Size;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoTrack;
import java.util.ArrayList;
import java.util.List;

public abstract class Media<TAudioTrack extends AudioTrack, TVideoTrack extends VideoTrack>
extends MediaBase<TAudioTrack, TVideoTrack> {
    private ArrayList<TAudioTrack> __audioTracks;
    private List<IAction0> __onAudioDestroyed = new ArrayList<IAction0>();
    private List<IAction1<Double>> __onAudioLevel = new ArrayList<IAction1<Double>>();
    private List<IAction0> __onVideoDestroyed = new ArrayList<IAction0>();
    private List<IAction1<Size>> __onVideoSize = new ArrayList<IAction1<Size>>();
    private ArrayList<TVideoTrack> __videoTracks;
    private boolean _isRecordingAudio;
    private boolean _isRecordingVideo;
    private IAction0 _onAudioDestroyed = null;
    private IAction1<Double> _onAudioLevel = null;
    private IAction0 _onVideoDestroyed = null;
    private IAction1<Size> _onVideoSize = null;

    protected void addAudioTrack(TAudioTrack audioTrack) {
        if (audioTrack != null && ArrayListExtensions.getCount(this.__audioTracks) == 0) {
            ((MediaTrack)audioTrack).addOnDestroyed(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.audioTrack_OnDestroyed";
                }

                @Override
                public void invoke() {
                    Media.this.audioTrack_OnDestroyed();
                }
            });
            ((AudioTrack)audioTrack).addOnPcmBuffer((IAction1<AudioBuffer>)new IActionDelegate1<AudioBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.audioTrack_OnPcmBuffer";
                }

                @Override
                public void invoke(AudioBuffer pcmBuffer) {
                    Media.this.audioTrack_OnPcmBuffer(pcmBuffer);
                }
            });
        }
        this.__audioTracks.add(audioTrack);
    }

    @Override
    public void addOnAudioDestroyed(IAction0 value) {
        if (value != null) {
            if (this._onAudioDestroyed == null) {
                this._onAudioDestroyed = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(Media.this.__onAudioDestroyed)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onAudioDestroyed.add(value);
        }
    }

    @Override
    public void addOnAudioLevel(IAction1<Double> value) {
        if (value != null) {
            if (this._onAudioLevel == null) {
                this._onAudioLevel = new IAction1<Double>(){

                    @Override
                    public void invoke(Double p0) {
                        for (IAction1 action : new ArrayList(Media.this.__onAudioLevel)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onAudioLevel.add(value);
        }
    }

    @Override
    public void addOnVideoDestroyed(IAction0 value) {
        if (value != null) {
            if (this._onVideoDestroyed == null) {
                this._onVideoDestroyed = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(Media.this.__onVideoDestroyed)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onVideoDestroyed.add(value);
        }
    }

    @Override
    public void addOnVideoSize(IAction1<Size> value) {
        if (value != null) {
            if (this._onVideoSize == null) {
                this._onVideoSize = new IAction1<Size>(){

                    @Override
                    public void invoke(Size p0) {
                        for (IAction1 action : new ArrayList(Media.this.__onVideoSize)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onVideoSize.add(value);
        }
    }

    protected void addVideoTrack(TVideoTrack videoTrack) {
        if (videoTrack != null && ArrayListExtensions.getCount(this.__videoTracks) == 0) {
            ((MediaTrack)videoTrack).addOnDestroyed(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.videoTrack_OnDestroyed";
                }

                @Override
                public void invoke() {
                    Media.this.videoTrack_OnDestroyed();
                }
            });
            ((VideoTrack)videoTrack).addOnSize((IAction1<Size>)new IActionDelegate1<Size>(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.videoTrack_OnSize";
                }

                @Override
                public void invoke(Size size) {
                    Media.this.videoTrack_OnSize(size);
                }
            });
        }
        this.__videoTracks.add(videoTrack);
    }

    protected abstract TAudioTrack[] arrayFromAudioTracks(ArrayList<TAudioTrack> var1);

    protected abstract TVideoTrack[] arrayFromVideoTracks(ArrayList<TVideoTrack> var1);

    private void audioTrack_OnDestroyed() {
        IAction0 onAudioDestroyed = this._onAudioDestroyed;
        if (onAudioDestroyed != null) {
            onAudioDestroyed.invoke();
        }
    }

    private void audioTrack_OnPcmBuffer(AudioBuffer pcmBuffer) {
        IAction1<Double> onAudioLevel = this._onAudioLevel;
        if (onAudioLevel != null) {
            onAudioLevel.invoke(pcmBuffer.calculateLevel());
        }
    }

    protected abstract ArrayList<TAudioTrack> createAudioTrackCollection();

    protected abstract ArrayList<TVideoTrack> createVideoTrackCollection();

    @Override
    public void destroy() {
        for (AudioTrack audioTrack : this.getAudioTracks()) {
            if (audioTrack.getPersistent()) continue;
            audioTrack.destroy();
        }
        for (MediaTrack mediaTrack : this.getVideoTracks()) {
            if (mediaTrack.getPersistent()) continue;
            mediaTrack.destroy();
        }
    }

    @Override
    public TAudioTrack[] getAudioTracks() {
        return this.arrayFromAudioTracks(this.__audioTracks);
    }

    public boolean getIsRecordingAudio() {
        return this._isRecordingAudio;
    }

    public boolean getIsRecordingVideo() {
        return this._isRecordingVideo;
    }

    @Override
    public Size getVideoSize() {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.getSize();
        }
        return new Size(0, 0);
    }

    @Override
    public TVideoTrack[] getVideoTracks() {
        return this.arrayFromVideoTracks(this.__videoTracks);
    }

    @Override
    public Future<VideoBuffer> grabVideoFrame() {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.grabFrame();
        }
        Promise<VideoBuffer> promise = new Promise<VideoBuffer>();
        promise.reject(new Exception("No video track."));
        return promise;
    }

    public Media() {
        this.__audioTracks = this.createAudioTrackCollection();
        this.__videoTracks = this.createVideoTrackCollection();
    }

    protected boolean removeAudioTrack(TAudioTrack audioTrack) {
        if (audioTrack != null) {
            ((MediaTrack)audioTrack).removeOnDestroyed(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.audioTrack_OnDestroyed";
                }

                @Override
                public void invoke() {
                    Media.this.audioTrack_OnDestroyed();
                }
            });
            ((AudioTrack)audioTrack).removeOnPcmBuffer((IAction1<AudioBuffer>)new IActionDelegate1<AudioBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.audioTrack_OnPcmBuffer";
                }

                @Override
                public void invoke(AudioBuffer pcmBuffer) {
                    Media.this.audioTrack_OnPcmBuffer(pcmBuffer);
                }
            });
        }
        return this.__audioTracks.remove(audioTrack);
    }

    @Override
    public void removeOnAudioDestroyed(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onAudioDestroyed, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onAudioDestroyed.remove(value);
        if (this.__onAudioDestroyed.size() == 0) {
            this._onAudioDestroyed = null;
        }
    }

    @Override
    public void removeOnAudioLevel(IAction1<Double> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onAudioLevel, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onAudioLevel.remove(value);
        if (this.__onAudioLevel.size() == 0) {
            this._onAudioLevel = null;
        }
    }

    @Override
    public void removeOnVideoDestroyed(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onVideoDestroyed, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onVideoDestroyed.remove(value);
        if (this.__onVideoDestroyed.size() == 0) {
            this._onVideoDestroyed = null;
        }
    }

    @Override
    public void removeOnVideoSize(IAction1<Size> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onVideoSize, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onVideoSize.remove(value);
        if (this.__onVideoSize.size() == 0) {
            this._onVideoSize = null;
        }
    }

    protected boolean removeVideoTrack(TVideoTrack videoTrack) {
        if (videoTrack != null) {
            ((MediaTrack)videoTrack).removeOnDestroyed(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.videoTrack_OnDestroyed";
                }

                @Override
                public void invoke() {
                    Media.this.videoTrack_OnDestroyed();
                }
            });
            ((VideoTrack)videoTrack).removeOnSize((IAction1<Size>)new IActionDelegate1<Size>(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.videoTrack_OnSize";
                }

                @Override
                public void invoke(Size size) {
                    Media.this.videoTrack_OnSize(size);
                }
            });
        }
        return this.__videoTracks.remove(videoTrack);
    }

    protected void setIsRecordingAudio(boolean value) {
        this._isRecordingAudio = value;
    }

    protected void setIsRecordingVideo(boolean value) {
        this._isRecordingVideo = value;
    }

    private void videoTrack_OnDestroyed() {
        IAction0 onVideoDestroyed = this._onVideoDestroyed;
        if (onVideoDestroyed != null) {
            onVideoDestroyed.invoke();
        }
    }

    private void videoTrack_OnSize(Size size) {
        IAction1<Size> onVideoSize = this._onVideoSize;
        if (onVideoSize != null) {
            onVideoSize.invoke(size);
        }
    }
}

