/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;

public class ManagedTimer {
    private IAction0 __callback;
    private ManagedThread __thread;
    private int _interval;
    private boolean _running;

    public int getInterval() {
        return this._interval;
    }

    public boolean getRunning() {
        return this._running;
    }

    private void innerLoop(ManagedThread thread) {
        ManagedStopwatch stopwatch = new ManagedStopwatch();
        long num = 0L;
        stopwatch.start();
        while (this.getRunning()) {
            int millisecondsTimeout;
            thread.loopBegin();
            int num2 = (int)(stopwatch.getElapsedMilliseconds() - num);
            if (num2 >= this.getInterval()) {
                this.__callback.invoke();
                num += (long)this.getInterval();
            }
            int n = millisecondsTimeout = num2 == 0 ? this.getInterval() : num2 % this.getInterval();
            if (millisecondsTimeout > 0) {
                ManagedThread.sleep(millisecondsTimeout);
            }
            thread.loopEnd();
        }
    }

    public ManagedTimer(int interval, IAction0 callback) {
        this.setInterval(interval);
        this.__callback = callback;
    }

    public static int perSecondInterval(int timesPerSecond) {
        return 1000 / timesPerSecond;
    }

    private void setInterval(int value) {
        this._interval = value;
    }

    private void setRunning(boolean value) {
        this._running = value;
    }

    public void start() {
        if (this.getRunning()) {
            throw new RuntimeException(new Exception("Already running."));
        }
        this.setRunning(true);
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.ManagedTimer.innerLoop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                ManagedTimer.this.innerLoop(thread);
            }
        });
        this.__thread.start();
    }

    public void stop() {
        this.setRunning(false);
        this.__thread = null;
    }
}

