/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IceGatherPolicy {
    All(1),
    NoHost(2),
    Relay(3);

    private final int value;
    private static final Map<Integer, IceGatherPolicy> lookup;

    private IceGatherPolicy(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static IceGatherPolicy getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, IceGatherPolicy>();
        for (IceGatherPolicy s : EnumSet.allOf(IceGatherPolicy.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

