/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vpx;

import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.ManagedThread;
import fm.icelink.MediaFrame;
import fm.icelink.Promise;
import fm.icelink.PromiseBase;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.vpx.Decoder;
import fm.icelink.vpx.Encoder;
import java.util.ArrayList;

public class Utility {
    private static void doInitialize(final Encoder encoder, final Decoder decoder, final Promise<Object> promise) {
        decoder.addOnRaiseFrame((IAction1)new IAction1<VideoFrame>(){

            public void invoke(VideoFrame frame) {
                promise.resolve(null);
                ManagedThread.dispatch((IAction0)new IAction0(){

                    public void invoke() {
                        encoder.destroy();
                        decoder.destroy();
                    }
                });
            }
        });
        encoder.addOnRaiseFrame((IAction1)new IAction1<VideoFrame>(){

            public void invoke(VideoFrame encodedFrame) {
                try {
                    decoder.processFrame((MediaFrame)new VideoFrame((VideoBuffer)encodedFrame.getLastBuffer()));
                }
                catch (Exception exception) {
                    promise.reject(exception);
                }
            }
        });
        encoder.processFrame(new VideoFrame(VideoBuffer.createBlack((int)160, (int)120, (String)VideoFormat.getI420Name())));
    }

    private static Future<Object> initialize(Encoder encoder, Decoder decoder) {
        Promise promise = new Promise();
        try {
            Utility.doInitialize(encoder, decoder, (Promise<Object>)promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public static Future<Object> initialize() {
        ArrayList<Future<Object>> list = new ArrayList<Future<Object>>();
        list.add(Utility.initialize(new fm.icelink.vp8.Encoder(), new fm.icelink.vp8.Decoder()));
        list.add(Utility.initialize(new fm.icelink.vp9.Encoder(), new fm.icelink.vp9.Decoder()));
        return PromiseBase.all((Future[])list.toArray(new Future[0]));
    }
}

