/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Convert;
import fm.Encoding;
import fm.Holder;
import java.security.MessageDigest;
import java.util.regex.Pattern;

public class Crypto {
    private static Pattern base64Regex = Pattern.compile("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");

    public static byte[] sha1Hash(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.reset();
            md.update(Encoding.getUTF8().getBytes(s));
            return md.digest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base64Encode(byte[] b) {
        if (b == null) {
            return null;
        }
        return Convert.toBase64String(b);
    }

    public static byte[] base64Decode(String s) {
        if (s == null) {
            return null;
        }
        if (!base64Regex.matcher(s).matches()) {
            return null;
        }
        return Convert.fromBase64String(s);
    }

    public static Boolean tryBase64Encode(byte[] b, Holder<String> encoded) {
        try {
            String output = Crypto.base64Encode(b);
            if (output == null) {
                return false;
            }
            encoded.setValue(output);
            return true;
        }
        catch (Exception ex) {
            encoded.setValue(null);
            return false;
        }
    }

    public static Boolean tryBase64Decode(String s, Holder<byte[]> decoded) {
        try {
            byte[] output = Crypto.base64Decode(s);
            if (output == null) {
                return false;
            }
            decoded.setValue(output);
            return true;
        }
        catch (Exception ex) {
            decoded.setValue(null);
            return false;
        }
    }
}

