/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Crypto;
import fm.Holder;
import fm.Serializer;
import fm.websync.BaseSuccessArgs;
import fm.websync.ConnectionType;

public abstract class BaseReceiveArgs
extends BaseSuccessArgs {
    ConnectionType __connectionType = ConnectionType.LongPolling;
    byte[] __dataBytes;
    String __dataJson;
    private int _reconnectAfter;

    public BaseReceiveArgs(String dataJson, byte[] dataBytes, ConnectionType connectionType, int reconnectAfter) {
        this.__dataJson = dataJson;
        this.__dataBytes = dataBytes;
        this.__connectionType = connectionType;
        this.setReconnectAfter(reconnectAfter);
    }

    public ConnectionType getConnectionType() {
        return this.__connectionType;
    }

    public byte[] getDataBytes() throws Exception {
        byte[] decoded = this.__dataBytes;
        String valueJson = this.__dataJson;
        if (decoded != null) {
            return decoded;
        }
        if (valueJson != null) {
            Holder _var0 = new Holder((Object)decoded);
            boolean _var1 = Crypto.tryBase64Decode((String)Serializer.deserializeString((String)valueJson), (Holder)_var0);
            decoded = (byte[])_var0.getValue();
            if (!_var1) {
                decoded = null;
            }
            this.__dataBytes = decoded;
            return decoded;
        }
        return null;
    }

    public String getDataJson() {
        String str = this.__dataJson;
        byte[] b = this.__dataBytes;
        if (str != null) {
            return str;
        }
        if (b != null) {
            this.__dataJson = str = Serializer.serializeString((String)Crypto.base64Encode((byte[])b));
            return str;
        }
        return null;
    }

    public boolean getIsBinary() throws Exception {
        return this.getDataBytes() != null;
    }

    public int getReconnectAfter() {
        return this._reconnectAfter;
    }

    public String getTag() throws Exception {
        return Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag"));
    }

    public void setReconnectAfter(int value) {
        this._reconnectAfter = value;
    }
}

