/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.DataBuffer;
import fm.icelink.IMediaOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.MediaBuffer;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.h264.Format;
import fm.icelink.h264.Utility;
import fm.icelink.openh264.DecoderConfig;
import fm.icelink.openh264.Native;

public class Decoder
extends VideoDecoder {
    private DecoderConfig __codecConfig;
    private Native __decoder = new Native(false);

    public Decoder(IVideoOutput input) {
        this();
        super.addInput((IMediaOutput)input);
    }

    public Decoder() {
        super((VideoFormat)new Format(), VideoFormat.getI420());
        DecoderConfig config = new DecoderConfig();
        this.setCodecConfig(config);
    }

    protected void doDestroy() {
        this.__decoder.destroy();
        this.__decoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        super.doProcessFrame(frame, inputBuffer);
        if (!super.getDelayDecode()) {
            VideoBuffer buffer = this.__decoder.decode(inputBuffer, (VideoFormat)super.getOutputFormat());
            if (buffer != null) {
                frame.addBuffer((MediaBuffer)buffer);
                this.raiseFrame(frame);
                buffer.getDataBuffer().free();
            }
            if (this.getNeedsKeyFrame()) {
                super.sendKeyFrameRequest("H.264 decoder needs a keyframe.");
            }
        }
    }

    public DecoderConfig getCodecConfig() {
        return this.__codecConfig.deepCopy();
    }

    public String getLabel() {
        return "OpenH264 Decoder";
    }

    public boolean getNeedsKeyFrame() {
        return this.__decoder.getNeedsKeyFrame();
    }

    protected boolean isKeyFrame(DataBuffer dataBuffer) {
        return Utility.isKeyFrame((DataBuffer)dataBuffer);
    }

    public int setCodecConfig(DecoderConfig config) {
        int num = this.__decoder.setDecoderConfig(config.getNativeConfig());
        if (num == 0) {
            this.__codecConfig = config.deepCopy();
        }
        return num;
    }

    private void setNeedsKeyFrame(boolean value) {
        this.__decoder.setNeedsKeyFrame(value);
    }
}

