/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.Promise;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoSource;
import fm.icelink.android.ImageUtility;
import java.nio.ByteBuffer;

@SuppressLint(value={"NewApi"})
public class MediaProjectionSource
extends VideoSource {
    private MediaProjection _projection;
    private Context _context;
    private int _frameRate;
    private Point _size;
    private ImageReader _imageReader;
    private VirtualDisplay _display;
    private volatile boolean isCapturing = false;
    private volatile boolean isStopped = true;
    private Image latestImage = null;

    public String getLabel() {
        return "Android MediaProjection Source";
    }

    public MediaProjectionSource(MediaProjection projection, Context context, int frameRate) {
        super(VideoFormat.getArgb());
        this._projection = projection;
        this._context = context;
        this._frameRate = frameRate;
        this._size = new Point();
    }

    protected Future<Object> doStart() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    DisplayMetrics metrics = new DisplayMetrics();
                    WindowManager wm = (WindowManager)MediaProjectionSource.this._context.getSystemService("window");
                    Display d = wm.getDefaultDisplay();
                    d.getMetrics(metrics);
                    d.getSize(MediaProjectionSource.this._size);
                    MediaProjectionSource.this.latestImage = null;
                    MediaProjectionSource.this._imageReader = ImageReader.newInstance((int)((MediaProjectionSource)MediaProjectionSource.this)._size.x, (int)((MediaProjectionSource)MediaProjectionSource.this)._size.y, (int)1, (int)2);
                    MediaProjectionSource.this._display = MediaProjectionSource.this._projection.createVirtualDisplay("screencapture", ((MediaProjectionSource)MediaProjectionSource.this)._size.x, ((MediaProjectionSource)MediaProjectionSource.this)._size.y, metrics.densityDpi, 16, MediaProjectionSource.this._imageReader.getSurface(), null, null);
                    MediaProjectionSource.this.isCapturing = true;
                    MediaProjectionSource.this.isStopped = false;
                    ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

                        public void invoke(ManagedThread thread) {
                            MediaProjectionSource.this.captureLoop(thread);
                        }
                    });
                    thread.start();
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    protected Future<Object> doStop() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    MediaProjectionSource.this.isCapturing = false;
                    while (!MediaProjectionSource.this.isStopped) {
                        ManagedThread.sleep((int)10);
                    }
                    if (MediaProjectionSource.this._display != null) {
                        MediaProjectionSource.this._display.release();
                        MediaProjectionSource.this._display = null;
                    }
                    if (MediaProjectionSource.this._imageReader != null) {
                        MediaProjectionSource.this._imageReader.close();
                        MediaProjectionSource.this._imageReader = null;
                    }
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureLoop(ManagedThread thread) {
        while (this.isCapturing) {
            long start;
            block10: {
                int width = this._size.x;
                int height = this._size.y;
                start = System.nanoTime();
                if (width > 0 && height > 0) {
                    while (width % 2 != 0) {
                        --width;
                    }
                    while (height % 2 != 0) {
                        --height;
                    }
                    try {
                        Image image = this._imageReader.acquireLatestImage();
                        if (image == null) break block10;
                        try {
                            Image.Plane[] planes = image.getPlanes();
                            if (planes != null && planes.length == 1) {
                                Image.Plane plane = planes[0];
                                ByteBuffer byteBuffer = plane.getBuffer();
                                int stride = plane.getRowStride() / plane.getPixelStride();
                                int[] data = new int[stride * height];
                                byteBuffer.asIntBuffer().get(data);
                                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                bitmap.setPixels(data, 0, stride, 0, 0, width, height);
                                VideoBuffer buffer = ImageUtility.bitmapToBuffer(bitmap);
                                this.raiseFrame(new VideoFrame(buffer));
                            }
                        }
                        finally {
                            image.close();
                            this.latestImage = null;
                        }
                    }
                    catch (Exception ex) {
                        Log.error((String)"Could not raise screen image.", (Exception)ex);
                    }
                }
            }
            long finish = System.nanoTime();
            ManagedThread.sleep((int)MathAssistant.max((int)0, (int)((int)(1000.0 / (double)this._frameRate - (double)((finish - start) / 1000000L)))));
        }
        this.isStopped = true;
    }
}

