/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.opus.ApplicationType;
import fm.icelink.opus.Bandwidth;
import fm.icelink.opus.ExpertFrameDuration;
import fm.icelink.opus.NativeEncoderConfig;
import fm.icelink.opus.OpusAuto;
import fm.icelink.opus.Signal;

public class EncoderConfig {
    private ApplicationType __application;
    private Bandwidth __bandwidth;
    private NativeEncoderConfig __config = new NativeEncoderConfig();
    private ExpertFrameDuration __expertFrameDuration;
    private Bandwidth __maxBandwidth;
    private Signal __signal;

    public EncoderConfig deepCopy() {
        EncoderConfig config = new EncoderConfig();
        config.__application = this.__application;
        config.__signal = this.__signal;
        config.__expertFrameDuration = this.__expertFrameDuration;
        config.__maxBandwidth = this.__maxBandwidth;
        config.__bandwidth = this.__bandwidth;
        config.__config = this.__config.deepCopy();
        return config;
    }

    public EncoderConfig() {
        this.__application = ApplicationType.getVoip();
        this.__signal = Signal.getVoice();
        this.__expertFrameDuration = ExpertFrameDuration.getArgument();
        this.__maxBandwidth = Bandwidth.getFullBand();
        this.__bandwidth = Bandwidth.getFullBand();
    }

    public ApplicationType getApplication() {
        return this.__application;
    }

    public static int getAuto() {
        return OpusAuto.getValue();
    }

    public Bandwidth getBandwidth() {
        return this.__bandwidth;
    }

    public int getComplexity() {
        return this.__config.getComplexity();
    }

    public int getDtx() {
        return this.__config.getDtx();
    }

    public ExpertFrameDuration getExpertFrameDuration() {
        return this.__expertFrameDuration;
    }

    public int getForceChannels() {
        return this.__config.getForceChannels();
    }

    public boolean getForwardErrorCorrection() {
        return this.__config.getForwardErrorCorrection() == 1;
    }

    public boolean getIsPredictionDisabled() {
        return this.__config.getIsPredictionDisabled() == 1;
    }

    public boolean getIsVbr() {
        return this.__config.getIsVbr() == 1;
    }

    public Bandwidth getMaxBandwidth() {
        return this.__maxBandwidth;
    }

    NativeEncoderConfig getNativeConfig() {
        return this.__config;
    }

    public int getPacketLossPercent() {
        return this.__config.getPacketLossPercent();
    }

    public Signal getSignal() {
        return this.__signal;
    }

    public boolean getUseConstrainedVBR() {
        return this.__config.getUseConstrainedVBR() == 1;
    }

    public void setApplication(ApplicationType value) {
        this.__application = value;
        this.__config.setApplication(value.getValue());
    }

    public void setBandwidth(Bandwidth value) {
        this.__bandwidth = value;
        this.__config.setBandwidth(value.getValue());
    }

    public void setComplexity(int value) {
        this.__config.setComplexity(value);
    }

    public void setDtx(int value) {
        this.__config.setDtx(value);
    }

    public void setExpertFrameDuration(ExpertFrameDuration value) {
        this.__expertFrameDuration = value;
        this.__config.setExpertFrameDuration(value.getValue());
    }

    public void setForceChannels(int value) {
        this.__config.setForceChannels(value);
    }

    public void setForwardErrorCorrection(boolean value) {
        this.__config.setForwardErrorCorrection(value ? 1 : 0);
    }

    public void setIsPredictionDisabled(boolean value) {
        this.__config.setIsPredictionDisabled(value ? 1 : 0);
    }

    public void setIsVbr(boolean value) {
        this.__config.setIsVbr(value ? 1 : 0);
    }

    public void setMaxBandwidth(Bandwidth value) {
        this.__maxBandwidth = value;
        this.__config.setMaxBandwidth(value.getValue());
    }

    public void setPacketLossPercent(int value) {
        this.__config.setPacketLossPercent(value);
    }

    public void setSignal(Signal value) {
        this.__signal = value;
        this.__config.setSignal(value.getValue());
    }

    public void setUseConstrainedVBR(boolean value) {
        this.__config.setUseConstrainedVBR(value ? 1 : 0);
    }
}

