/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioEncoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Error;
import fm.icelink.Holder;
import fm.icelink.IAudioOutput;
import fm.icelink.IMediaOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.ParseAssistant;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import fm.icelink.StringExtensions;
import fm.icelink.opus.EncoderConfig;
import fm.icelink.opus.Format;
import fm.icelink.opus.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.rtp.MapAttribute;

public class Encoder
extends AudioEncoder {
    private EncoderConfig __codecConfig = new EncoderConfig();
    private int __currentChannelCount = -1;
    private int __currentClockRate = -1;
    private double __currentPacketTime = -1.0;
    private Native __encoder;
    private int __encoderBitrate = 32;
    private double __lastPercentLoss = 0.0;
    private double __percentLossAlpha = 0.75;
    private double __percentLossVariance = -1.0;
    private boolean __remoteSupportsFec = false;
    private long __reportsReceived = 0L;
    private double __smoothedFractionLoss = 0.0;
    private int __userSetBitrate = -1;
    private boolean _disableFec;

    protected void doDestroy() {
        if (this.__encoder != null) {
            this.__encoder.destroy();
            this.__encoder = null;
        }
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        if (this.__encoder != null) {
            EncoderConfig codecConfig = this.getCodecConfig();
            boolean flag = false;
            for (MediaControlFrame frame : controlFrames) {
                if (!(frame instanceof ReportControlFrame)) continue;
                ++this.__reportsReceived;
                ReportControlFrame frame2 = (ReportControlFrame)frame;
                for (ReportBlock block : frame2.getReportBlocks()) {
                    this.__percentLossVariance = MathAssistant.abs((double)(block.getPercentLost() - this.__lastPercentLoss));
                    this.__smoothedFractionLoss = this.__percentLossAlpha * this.__smoothedFractionLoss + (1.0 - this.__percentLossAlpha) * this.__percentLossVariance;
                    codecConfig.setPacketLossPercent((int)(this.__smoothedFractionLoss * 100.0));
                    if (this.getDisableFec() || codecConfig.getForwardErrorCorrection() || !this.__remoteSupportsFec || !(this.__smoothedFractionLoss * 100.0 >= (double)this.getPercentLossToTriggerFEC())) continue;
                    Log.debug((String)"Activating FEC for outbound Opus audio stream.");
                    codecConfig.setForwardErrorCorrection(true);
                    flag = true;
                }
            }
            if (flag) {
                this.setCodecConfig(codecConfig);
            }
        }
        super.doProcessControlFrames(controlFrames);
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        AudioBuffer buffer = this.encode(inputBuffer, (AudioFormat)super.getOutputFormat(), frame.getDuration(), this.__remoteSupportsFec);
        if (buffer != null) {
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame(frame);
            buffer.getDataBuffer().free();
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        MapAttribute attribute = mediaDescription.getRtpMapAttribute(((AudioFormat)super.getOutputFormat()).getName(), ((AudioFormat)super.getOutputFormat()).getClockRate(), ((AudioFormat)super.getOutputFormat()).getParameters());
        if (attribute != null) {
            FormatParametersAttribute relatedFormatParametersAttribute = attribute.getRelatedFormatParametersAttribute();
            if (!isLocalDescription && relatedFormatParametersAttribute != null) {
                String str = null;
                Holder _var0 = new Holder(str);
                boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("useinbandfec", _var0);
                str = (String)_var0.getValue();
                if (_var1) {
                    int intResult = 0;
                    IntegerHolder _var2 = new IntegerHolder(intResult);
                    boolean _var3 = ParseAssistant.tryParseIntegerValue((String)str, (IntegerHolder)_var2);
                    intResult = _var2.getValue();
                    if (_var3) {
                        this.__remoteSupportsFec = intResult > 0;
                    }
                }
            }
        }
        return null;
    }

    private AudioBuffer encode(AudioBuffer buffer, AudioFormat outputFormat, double bufferDuration, boolean enableFec) {
        AudioBuffer buffer2;
        int maxOutputBitrate;
        if (this.__encoder == null || bufferDuration != this.__currentPacketTime) {
            if (this.__encoder != null) {
                this.__encoder.destroy();
            }
            this.__currentClockRate = ((AudioFormat)buffer.getFormat()).getClockRate();
            this.__currentChannelCount = ((AudioFormat)buffer.getFormat()).getChannelCount();
            this.__currentPacketTime = bufferDuration;
            Log.debug((String)"(Re)creating new Opus native encoder.");
            this.__encoder = new Native(true, this.__currentClockRate, this.__currentChannelCount, this.__currentPacketTime);
            EncoderConfig codecConfig = this.getCodecConfig();
            codecConfig.setForwardErrorCorrection(enableFec);
            this.setCodecConfig(codecConfig);
            this.__encoder.setBitrate(this.__encoderBitrate);
        }
        if ((maxOutputBitrate = this.getMaxOutputBitrate()) > 0 && maxOutputBitrate != this.__encoderBitrate) {
            Log.debug((String)StringExtensions.concat((String)"Changing Opus encoder bitrate from ", (String)IntegerExtensions.toString((Integer)this.__encoderBitrate), (String)" to ", (String)IntegerExtensions.toString((Integer)maxOutputBitrate)));
            this.__encoder.setBitrate(maxOutputBitrate);
            this.__encoderBitrate = maxOutputBitrate;
        }
        if ((buffer2 = this.__encoder.encode(buffer, outputFormat)) != null) {
            buffer2.getDataBuffer().setLittleEndian(outputFormat.getLittleEndian());
            return buffer2;
        }
        return null;
    }

    public Encoder(IAudioOutput input) {
        this(input.getConfig());
        super.addInput((IMediaOutput)input);
    }

    public Encoder() {
        this(Format.getDefaultConfig());
    }

    public Encoder(AudioConfig config) {
        super((AudioFormat)new fm.icelink.pcm.Format(config), (AudioFormat)new Format(config));
    }

    public int getBitrate() {
        return this.__encoderBitrate;
    }

    public EncoderConfig getCodecConfig() {
        return this.__codecConfig.deepCopy();
    }

    public boolean getDisableFec() {
        return this._disableFec;
    }

    public String getLabel() {
        return "Opus Encoder";
    }

    public int getMaxOutputBitrate() {
        int maxOutputBitrate = super.getMaxOutputBitrate();
        return this.__userSetBitrate < 0 ? maxOutputBitrate : (maxOutputBitrate < 0 ? this.__userSetBitrate : MathAssistant.min((int)this.__userSetBitrate, (int)maxOutputBitrate));
    }

    public int getPercentLossToTriggerFEC() {
        return this.__codecConfig.getPacketLossPercent();
    }

    public double getQuality() {
        return (double)this.__codecConfig.getComplexity() / 10.0;
    }

    public void setBitrate(int value) {
        this.__encoderBitrate = this.__userSetBitrate = value;
    }

    public int setCodecConfig(EncoderConfig config) {
        int num = 0;
        if (this.__encoder != null) {
            num = this.__encoder.setEncoderConfig(config.getNativeConfig());
        }
        if (num == 0) {
            this.__codecConfig = config.deepCopy();
        }
        return num;
    }

    public void setDisableFec(boolean value) {
        this._disableFec = value;
    }

    public void setPercentLossToTriggerFEC(int value) {
        EncoderConfig codecConfig = this.getCodecConfig();
        codecConfig.setPacketLossPercent(value);
        if (this.__encoder != null) {
            this.setCodecConfig(codecConfig);
        }
    }

    public void setQuality(double value) {
        EncoderConfig codecConfig = this.getCodecConfig();
        double num = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        codecConfig.setComplexity((int)(num * 10.0));
        if (this.__encoder != null) {
            this.setCodecConfig(codecConfig);
        }
    }
}

