/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp9;

import fm.icelink.DataBuffer;

public class Utility {
    public static int deriveHeight(DataBuffer buffer) {
        return Utility.getDimension(buffer, 8);
    }

    public static int deriveWidth(DataBuffer buffer) {
        return Utility.getDimension(buffer, 6);
    }

    private static int getDimension(DataBuffer buffer, int offset) {
        if (Utility.isKeyFrame(buffer) && buffer.getLength() >= 10) {
            int num = buffer.read8(offset) >> 6 & 3;
            int num2 = buffer.read8(offset) & 0x3F;
            int num3 = buffer.read8(offset + 1) & 0xFF;
            int num4 = num3 * 256 + num2;
            int _var0 = num;
            if (_var0 == 0) {
                return num4 / 1;
            }
            if (_var0 == 1) {
                return num4 * 2 / 1;
            }
            if (_var0 == 2) {
                return num4 * 5 / 4;
            }
            if (_var0 == 3) {
                num4 = num4 * 5 / 3;
            }
            return num4;
        }
        return 0;
    }

    public static boolean isKeyFrame(DataBuffer buffer) {
        if (buffer != null && buffer.getLength() > 2) {
            int offset = 0;
            int bitOffset = 0;
            buffer.read2(offset, bitOffset);
            bitOffset += 2;
            boolean flag = buffer.read1(offset, bitOffset++);
            boolean flag2 = buffer.read1(offset, bitOffset++);
            if (!flag || flag2) {
                // empty if block
            }
            int n = ++bitOffset;
            ++bitOffset;
            if (buffer.read1(offset, n)) {
                return false;
            }
            while (bitOffset >= 8) {
                ++offset;
                bitOffset -= 8;
            }
            return !buffer.read1(offset, bitOffset);
        }
        return false;
    }
}

