/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.Crc32;
import fm.icelink.DataBuffer;
import fm.icelink.stun.Attribute;

public class FingerprintAttribute
extends Attribute {
    private static Crc32 __crc32;
    private DataBuffer _messageBuffer;
    private static long _xorValue;

    private static long getCheckSum(DataBuffer messageBuffer) {
        return __crc32.compute(messageBuffer.getData(), messageBuffer.getIndex(), messageBuffer.getLength());
    }

    public DataBuffer getMessageBuffer() {
        return this._messageBuffer;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getFingerprintType();
    }

    @Override
    protected int getValueLength() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FingerprintAttribute readValueFrom(DataBuffer buffer, int offset, DataBuffer messageBuffer) {
        FingerprintAttribute attribute = new FingerprintAttribute();
        int num = 2;
        int num2 = messageBuffer.read16(num);
        try {
            messageBuffer.write16(messageBuffer.getLength() - 20 + attribute.getLength(), num);
            if ((buffer.read32(offset) ^ _xorValue) != FingerprintAttribute.getCheckSum(messageBuffer)) {
                throw new RuntimeException(new Exception("Supplied checksum does not match calculated checksum."));
            }
        }
        finally {
            messageBuffer.write16(num2, num);
        }
        return attribute;
    }

    public void setMessageBuffer(DataBuffer value) {
        this._messageBuffer = value;
    }

    public String toString() {
        return "FINGERPRINT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        if (this.getMessageBuffer() == null) {
            throw new RuntimeException(new Exception("Message buffer must be set before writing fingerprint attribute."));
        }
        int num = 2;
        int num2 = this.getMessageBuffer().read16(num);
        try {
            this.getMessageBuffer().write16(this.getMessageBuffer().getLength() - 20 + super.getLength(), num);
            buffer.write32(FingerprintAttribute.getCheckSum(this.getMessageBuffer()) ^ _xorValue, offset);
        }
        finally {
            this.getMessageBuffer().write16(num2, num);
        }
    }

    static {
        _xorValue = 1398035790L;
        __crc32 = new Crc32(Crc32.getCrc32Polynomial());
    }
}

