/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ClassExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.AttributeCreationArgs;
import fm.icelink.sdp.AttributeRegistration;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.CategoryAttribute;
import fm.icelink.sdp.CharacterSetAttribute;
import fm.icelink.sdp.ConferenceTypeAttribute;
import fm.icelink.sdp.CryptoAttribute;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.FrameRateAttribute;
import fm.icelink.sdp.InactiveAttribute;
import fm.icelink.sdp.KeywordsAttribute;
import fm.icelink.sdp.LanguageAttribute;
import fm.icelink.sdp.MaxPacketTimeAttribute;
import fm.icelink.sdp.MediaStreamIdAttribute;
import fm.icelink.sdp.MediaStreamIdSemanticAttribute;
import fm.icelink.sdp.OrientationAttribute;
import fm.icelink.sdp.PacketTimeAttribute;
import fm.icelink.sdp.QualityAttribute;
import fm.icelink.sdp.ReceiveOnlyAttribute;
import fm.icelink.sdp.SdpLanguageAttribute;
import fm.icelink.sdp.SendOnlyAttribute;
import fm.icelink.sdp.SendReceiveAttribute;
import fm.icelink.sdp.SetupAttribute;
import fm.icelink.sdp.ToolAttribute;
import fm.icelink.sdp.UnknownAttribute;
import fm.icelink.sdp.ice.CandidateAttribute;
import fm.icelink.sdp.ice.FingerprintAttribute;
import fm.icelink.sdp.ice.LiteAttribute;
import fm.icelink.sdp.ice.MismatchAttribute;
import fm.icelink.sdp.ice.OptionsAttribute;
import fm.icelink.sdp.ice.PasswordAttribute;
import fm.icelink.sdp.ice.RemoteCandidatesAttribute;
import fm.icelink.sdp.ice.UfragAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import fm.icelink.sdp.rtcp.MuxAttribute;
import fm.icelink.sdp.rtp.ExtMapAttribute;
import fm.icelink.sdp.rtp.MapAttribute;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.sctp.MaxMessageSizeAttribute;
import java.util.HashMap;

public abstract class Attribute {
    private AttributeType _attributeType;
    private static HashMap<String, AttributeRegistration> _registeredAttributes = new HashMap();
    private static Object _registeredAttributesLock = new Object();
    private static String _unknownAttributeTypeName = ClassExtensions.getFullName(UnknownAttribute.class);

    protected Attribute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute createAttribute(String name, String value) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(_registeredAttributes)) {
                AttributeRegistration registration = HashMapExtensions.getItem(_registeredAttributes).get(str);
                if (!Global.equals(registration.getName(), name)) continue;
                return registration.getCreationDelegate().invoke(new AttributeCreationArgs(value));
            }
        }
        return new UnknownAttribute(name, value);
    }

    private static Attribute createSDPCandidateAttribute(AttributeCreationArgs e) {
        return CandidateAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPCategoryAttribute(AttributeCreationArgs e) {
        return CategoryAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPCharacterSetAttribute(AttributeCreationArgs e) {
        return CharacterSetAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPConferenceTypeAttribute(AttributeCreationArgs e) {
        return ConferenceTypeAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPCryptoAttribute(AttributeCreationArgs e) {
        return CryptoAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPExtMapAttribute(AttributeCreationArgs e) {
        return ExtMapAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPFingerprintAttribute(AttributeCreationArgs e) {
        return FingerprintAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPFormatParametersAttribute(AttributeCreationArgs e) {
        return FormatParametersAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPFrameRateAttribute(AttributeCreationArgs e) {
        return FrameRateAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPIceLiteAttribute(AttributeCreationArgs e) {
        return LiteAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPIceMismatchAttribute(AttributeCreationArgs e) {
        return MismatchAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPIceOptionsAttribute(AttributeCreationArgs e) {
        return OptionsAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPIcePasswordAttribute(AttributeCreationArgs e) {
        return PasswordAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPIceUfragAttribute(AttributeCreationArgs e) {
        return UfragAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPInactiveAttribute(AttributeCreationArgs e) {
        return InactiveAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPKeywordsAttribute(AttributeCreationArgs e) {
        return KeywordsAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPLanguageAttribute(AttributeCreationArgs e) {
        return LanguageAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPMaxPacketTimeAttribute(AttributeCreationArgs e) {
        return MaxPacketTimeAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPMediaStreamIdAttribute(AttributeCreationArgs e) {
        return MediaStreamIdAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPMediaStreamIdSemanticAttribute(AttributeCreationArgs e) {
        return MediaStreamIdSemanticAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPOrientationAttribute(AttributeCreationArgs e) {
        return OrientationAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPPacketTimeAttribute(AttributeCreationArgs e) {
        return PacketTimeAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPQualityAttribute(AttributeCreationArgs e) {
        return QualityAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPReceiveOnlyAttribute(AttributeCreationArgs e) {
        return ReceiveOnlyAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPRemoteCandidatesAttribute(AttributeCreationArgs e) {
        return RemoteCandidatesAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPRtcpAttribute(AttributeCreationArgs e) {
        return fm.icelink.sdp.rtcp.Attribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPRtcpFeedbackAttribute(AttributeCreationArgs e) {
        return FeedbackAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPRtcpMuxAttribute(AttributeCreationArgs e) {
        return MuxAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPRtpMapAttribute(AttributeCreationArgs e) {
        return MapAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSctpMapAttribute(AttributeCreationArgs e) {
        return fm.icelink.sdp.sctp.MapAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSctpMaxMessageSizeAttribute(AttributeCreationArgs e) {
        return MaxMessageSizeAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSdpLanguageAttribute(AttributeCreationArgs e) {
        return SdpLanguageAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSendOnlyAttribute(AttributeCreationArgs e) {
        return SendOnlyAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSendReceiveAttribute(AttributeCreationArgs e) {
        return SendReceiveAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSetupAttribute(AttributeCreationArgs e) {
        return SetupAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPSSRCAttribute(AttributeCreationArgs e) {
        return SsrcAttribute.fromAttributeValue(e.getValue());
    }

    private static Attribute createSDPToolAttribute(AttributeCreationArgs e) {
        return ToolAttribute.fromAttributeValue(e.getValue());
    }

    public AttributeType getAttributeType() {
        return this._attributeType;
    }

    protected abstract String getAttributeValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTypeName(Class type) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            AttributeRegistration registration = null;
            Holder<Object> _var0 = new Holder<Object>(registration);
            boolean _var1 = HashMapExtensions.tryGetValue(_registeredAttributes, ClassExtensions.getFullName(type), _var0);
            registration = _var0.getValue();
            if (_var1) {
                return registration.getName();
            }
        }
        Class baseType = type.getSuperclass();
        if (baseType != null) {
            return Attribute.getTypeName(baseType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMediaLevel(Class type) {
        if (Global.equals(ClassExtensions.getFullName(type), _unknownAttributeTypeName)) {
            return true;
        }
        Object object = _registeredAttributesLock;
        synchronized (object) {
            AttributeRegistration registration = null;
            Holder<Object> _var0 = new Holder<Object>(registration);
            boolean _var1 = HashMapExtensions.tryGetValue(_registeredAttributes, ClassExtensions.getFullName(type), _var0);
            registration = _var0.getValue();
            if (_var1) {
                return registration.getMediaLevel();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSessionLevel(Class type) {
        if (Global.equals(ClassExtensions.getFullName(type), _unknownAttributeTypeName)) {
            return true;
        }
        Object object = _registeredAttributesLock;
        synchronized (object) {
            AttributeRegistration registration = null;
            Holder<Object> _var0 = new Holder<Object>(registration);
            boolean _var1 = HashMapExtensions.tryGetValue(_registeredAttributes, ClassExtensions.getFullName(type), _var0);
            registration = _var0.getValue();
            if (_var1) {
                return registration.getSessionLevel();
            }
        }
        return false;
    }

    public static Attribute parse(String s) {
        String str2;
        String str;
        int index = StringExtensions.indexOf(s = s.substring(2), ":");
        if (index == -1) {
            str = s;
            str2 = null;
        } else {
            str = StringExtensions.substring(s, 0, index);
            str2 = s.substring(index + 1);
        }
        return Attribute.createAttribute(str, str2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerAttribute(Class type, String name, boolean sessionLevel, boolean mediaLevel, IFunction1<AttributeCreationArgs, Attribute> creationDelegate) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            HashMapExtensions.set(HashMapExtensions.getItem(_registeredAttributes), ClassExtensions.getFullName(type), new AttributeRegistration(name, sessionLevel, mediaLevel, creationDelegate));
        }
    }

    public void setAttributeType(AttributeType value) {
        this._attributeType = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, "a=");
        Class<?> type = super.getClass();
        if (Global.equals(ClassExtensions.getFullName(type), _unknownAttributeTypeName)) {
            StringBuilderExtensions.append(builder, ((UnknownAttribute)this).getName());
        } else {
            StringBuilderExtensions.append(builder, Attribute.getTypeName(type));
        }
        String attributeValue = this.getAttributeValue();
        if (attributeValue != null) {
            StringBuilderExtensions.append(builder, ":");
            StringBuilderExtensions.append(builder, attributeValue);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterAttribute(Class type) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            return HashMapExtensions.remove(_registeredAttributes, ClassExtensions.getFullName(type));
        }
    }

    static {
        Attribute.registerAttribute(CategoryAttribute.class, "cat", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPCategoryAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPCategoryAttribute(e);
            }
        });
        Attribute.registerAttribute(CharacterSetAttribute.class, "charset", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPCharacterSetAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPCharacterSetAttribute(e);
            }
        });
        Attribute.registerAttribute(ConferenceTypeAttribute.class, "type", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPConferenceTypeAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPConferenceTypeAttribute(e);
            }
        });
        Attribute.registerAttribute(CryptoAttribute.class, "crypto", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPCryptoAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPCryptoAttribute(e);
            }
        });
        Attribute.registerAttribute(FormatParametersAttribute.class, "fmtp", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPFormatParametersAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPFormatParametersAttribute(e);
            }
        });
        Attribute.registerAttribute(FrameRateAttribute.class, "framerate", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPFrameRateAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPFrameRateAttribute(e);
            }
        });
        Attribute.registerAttribute(InactiveAttribute.class, "inactive", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPInactiveAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPInactiveAttribute(e);
            }
        });
        Attribute.registerAttribute(KeywordsAttribute.class, "keywds", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPKeywordsAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPKeywordsAttribute(e);
            }
        });
        Attribute.registerAttribute(LanguageAttribute.class, "lang", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPLanguageAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPLanguageAttribute(e);
            }
        });
        Attribute.registerAttribute(MaxPacketTimeAttribute.class, "maxptime", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPMaxPacketTimeAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPMaxPacketTimeAttribute(e);
            }
        });
        Attribute.registerAttribute(OrientationAttribute.class, "orient", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPOrientationAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPOrientationAttribute(e);
            }
        });
        Attribute.registerAttribute(PacketTimeAttribute.class, "ptime", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPPacketTimeAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPPacketTimeAttribute(e);
            }
        });
        Attribute.registerAttribute(QualityAttribute.class, "quality", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPQualityAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPQualityAttribute(e);
            }
        });
        Attribute.registerAttribute(ReceiveOnlyAttribute.class, "recvonly", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPReceiveOnlyAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPReceiveOnlyAttribute(e);
            }
        });
        Attribute.registerAttribute(SdpLanguageAttribute.class, "sdplang", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSdpLanguageAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSdpLanguageAttribute(e);
            }
        });
        Attribute.registerAttribute(SendOnlyAttribute.class, "sendonly", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSendOnlyAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSendOnlyAttribute(e);
            }
        });
        Attribute.registerAttribute(SendReceiveAttribute.class, "sendrecv", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSendReceiveAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSendReceiveAttribute(e);
            }
        });
        Attribute.registerAttribute(SetupAttribute.class, "setup", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSetupAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSetupAttribute(e);
            }
        });
        Attribute.registerAttribute(ToolAttribute.class, "tool", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPToolAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPToolAttribute(e);
            }
        });
        Attribute.registerAttribute(MediaStreamIdSemanticAttribute.class, "msid-semantic", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPMediaStreamIdSemanticAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPMediaStreamIdSemanticAttribute(e);
            }
        });
        Attribute.registerAttribute(MediaStreamIdAttribute.class, "mid", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPMediaStreamIdAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPMediaStreamIdAttribute(e);
            }
        });
        Attribute.registerAttribute(CandidateAttribute.class, "candidate", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPCandidateAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPCandidateAttribute(e);
            }
        });
        Attribute.registerAttribute(FingerprintAttribute.class, "fingerprint", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPFingerprintAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPFingerprintAttribute(e);
            }
        });
        Attribute.registerAttribute(LiteAttribute.class, "ice-lite", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPIceLiteAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPIceLiteAttribute(e);
            }
        });
        Attribute.registerAttribute(MismatchAttribute.class, "ice-mismatch", true, false, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPIceMismatchAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPIceMismatchAttribute(e);
            }
        });
        Attribute.registerAttribute(OptionsAttribute.class, "ice-options", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPIceOptionsAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPIceOptionsAttribute(e);
            }
        });
        Attribute.registerAttribute(PasswordAttribute.class, "ice-pwd", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPIcePasswordAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPIcePasswordAttribute(e);
            }
        });
        Attribute.registerAttribute(UfragAttribute.class, "ice-ufrag", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPIceUfragAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPIceUfragAttribute(e);
            }
        });
        Attribute.registerAttribute(RemoteCandidatesAttribute.class, "remote-candidates", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPRemoteCandidatesAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPRemoteCandidatesAttribute(e);
            }
        });
        Attribute.registerAttribute(MapAttribute.class, "rtpmap", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPRtpMapAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPRtpMapAttribute(e);
            }
        });
        Attribute.registerAttribute(SsrcAttribute.class, "ssrc", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSSRCAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSSRCAttribute(e);
            }
        });
        Attribute.registerAttribute(ExtMapAttribute.class, "extmap", true, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPExtMapAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPExtMapAttribute(e);
            }
        });
        Attribute.registerAttribute(fm.icelink.sdp.rtcp.Attribute.class, "rtcp", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPRtcpAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPRtcpAttribute(e);
            }
        });
        Attribute.registerAttribute(FeedbackAttribute.class, "rtcp-fb", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPRtcpFeedbackAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPRtcpFeedbackAttribute(e);
            }
        });
        Attribute.registerAttribute(MuxAttribute.class, "rtcp-mux", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPRtcpMuxAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPRtcpMuxAttribute(e);
            }
        });
        Attribute.registerAttribute(fm.icelink.sdp.sctp.MapAttribute.class, "sctpmap", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSctpMapAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSctpMapAttribute(e);
            }
        });
        Attribute.registerAttribute(MaxMessageSizeAttribute.class, "max-message-size", false, true, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.sdp.Attribute.createSDPSctpMaxMessageSizeAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSDPSctpMaxMessageSizeAttribute(e);
            }
        });
    }
}

