/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X501DirectoryString;

class X501Attribute {
    private long[] _attributeType;
    private byte[] _attributeValue;

    public X501DirectoryString attributeValueAsDirectoryString() {
        Asn1Any any = Asn1Any.parseBytes(this.getAttributeValue());
        if (any != null) {
            return X501DirectoryString.fromAsn1(any);
        }
        return null;
    }

    public String attributeValueAsString() {
        X501DirectoryString str = this.attributeValueAsDirectoryString();
        if (str != null) {
            return str.getValue();
        }
        return null;
    }

    public static X501Attribute fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X501Attribute attribute = new X501Attribute();
        attribute.setAttributeType(((Asn1ObjectIdentifier)sequence.getValues()[0]).getValues());
        attribute.setAttributeValue(sequence.getValues()[1].getBytes());
        return attribute;
    }

    public long[] getAttributeType() {
        return this._attributeType;
    }

    public byte[] getAttributeValue() {
        return this._attributeValue;
    }

    public void setAttributeType(long[] value) {
        this._attributeType = value;
    }

    public void setAttributeValue(byte[] value) {
        this._attributeValue = value;
    }

    public Asn1Sequence toAsn1() {
        return new Asn1Sequence(new Asn1Any[]{new Asn1ObjectIdentifier(this.getAttributeType()), Asn1Any.parseBytes(this.getAttributeValue())});
    }

    public X501Attribute() {
    }

    public X501Attribute(long[] attributeType, byte[] attributeValue) {
        this.setAttributeType(attributeType);
        this.setAttributeValue(attributeValue);
    }
}

