/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BooleanHolder;
import fm.icelink.DataBuffer;
import fm.icelink.DatagramSocket;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.TimeoutTimer;
import fm.icelink.VirtualAdapter;
import fm.icelink.VirtualPacket;

class VirtualUdpSocket
extends DatagramSocket {
    private boolean __isClosed;
    private String __localIPAddress;
    private int __localPort;
    private int _maxQueuedPackets;
    private boolean _receiveActive = false;
    private Object _receiveLock = new Object();
    private TimeoutTimer _receiveTimer;
    private VirtualAdapter _virtualAdapter;

    @Override
    public boolean bind(String ipAddress, int port, BooleanHolder addressInUse) {
        addressInUse.setValue(false);
        if (!Global.equals(ipAddress, this._virtualAdapter.getIPAddress())) {
            ipAddress = this._virtualAdapter.getIPAddress();
        }
        this.__localIPAddress = ipAddress;
        this.__localPort = port;
        return true;
    }

    @Override
    public void close() {
        this.__isClosed = true;
    }

    @Override
    public boolean getIPv6() {
        return false;
    }

    @Override
    public boolean getIsClosed() {
        return this.__isClosed;
    }

    @Override
    public String getLocalIPAddress() {
        return this.__localIPAddress;
    }

    @Override
    public int getLocalPort() {
        return this.__localPort;
    }

    @Override
    public int getMaxQueuedPackets() {
        return this._maxQueuedPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualPacket receive(int timeout) {
        Object obj2;
        Object object = obj2 = this._receiveLock;
        synchronized (object) {
            if (this._receiveActive) {
                return null;
            }
            this._receiveActive = true;
        }
        if (timeout > 0) {
            this._receiveTimer = new TimeoutTimer((IAction1<Object>)new IActionDelegate1<Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.VirtualUdpSocket.receiveTimeout";
                }

                @Override
                public void invoke(Object state) {
                    VirtualUdpSocket.this.receiveTimeout(state);
                }
            }, null);
            try {
                this._receiveTimer.start(timeout);
            }
            catch (Exception exception) {
                Log.error("Could not start virtual TCP socket receive timer.", exception);
            }
        }
        try {
            while (this._receiveActive && !this.__isClosed) {
                VirtualPacket delivery = this._virtualAdapter.getDelivery(this.getLocalPort());
                if (delivery != null) {
                    VirtualPacket virtualPacket = delivery;
                    return virtualPacket;
                }
                ManagedThread.sleep(10);
            }
        }
        finally {
            if (timeout > 0) {
                this._receiveTimer.stop();
            }
            Object object2 = obj2 = this._receiveLock;
            synchronized (object2) {
                this._receiveActive = false;
            }
        }
        return null;
    }

    @Override
    public void receiveAsync(final IAction3<DataBuffer, String, Integer> onSuccess, final IAction1<Exception> onFailure) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                try {
                    VirtualPacket packet = VirtualUdpSocket.this.receive(0);
                    if (packet == null) {
                        if (VirtualUdpSocket.this.__isClosed) {
                            VirtualUdpSocket.this.raiseReceiveFailure(onFailure, new Exception("Socket closed."));
                        } else {
                            VirtualUdpSocket.this.raiseReceiveFailure(onFailure, new Exception("Receive cancelled."));
                        }
                    } else {
                        VirtualUdpSocket.this.raiseReceiveSuccess(onSuccess, packet.getPayload(), packet.getSourceIPAddress(), packet.getSourcePort());
                    }
                }
                catch (Exception exception) {
                    VirtualUdpSocket.this.raiseReceiveFailure(onFailure, exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveTimeout(Object state) {
        Object object = this._receiveLock;
        synchronized (object) {
            this._receiveActive = false;
        }
    }

    @Override
    public int send(DataBuffer buffer, String ipAddress, int port) {
        VirtualPacket packet = new VirtualPacket();
        packet.setSourceIPAddress(this.getLocalIPAddress());
        packet.setSourcePort(this.getLocalPort());
        packet.setPayload(DataBuffer.wrap(buffer.toArray()));
        this._virtualAdapter.getNetwork().send(packet, ipAddress, port);
        return buffer.getLength();
    }

    @Override
    public void setMaxQueuedPackets(int value) {
        this._maxQueuedPackets = value;
    }

    public VirtualUdpSocket(VirtualAdapter adapter) {
        this._virtualAdapter = adapter;
    }
}

