/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IntegerExtensions;
import fm.icelink.MediaConfig;
import fm.icelink.StringExtensions;

public class VideoConfig
extends MediaConfig<VideoConfig> {
    private int _frameRate;
    private int _height;
    private int _width;

    public int getFrameRate() {
        return this._frameRate;
    }

    public int getHeight() {
        return this._height;
    }

    public int getWidth() {
        return this._width;
    }

    @Override
    public boolean isEquivalent(VideoConfig config) {
        if (!super.isEquivalent(config)) {
            return false;
        }
        return this.getWidth() == config.getWidth() && this.getHeight() == config.getHeight() && this.getFrameRate() == config.getFrameRate();
    }

    private void setFrameRate(int value) {
        this._frameRate = value;
    }

    private void setHeight(int value) {
        this._height = value;
    }

    private void setWidth(int value) {
        this._width = value;
    }

    public String toString() {
        return StringExtensions.format("Clock Rate: {0}, Width: {1}, Height: {2}, Frame Rate: {3}", new Object[]{IntegerExtensions.toString(super.getClockRate()), IntegerExtensions.toString(this.getWidth()), IntegerExtensions.toString(this.getHeight()), IntegerExtensions.toString(this.getFrameRate())});
    }

    public VideoConfig(int width, int height, int frameRate) {
        this(width, height, frameRate, 90000);
    }

    public VideoConfig(int width, int height, int frameRate, int clockRate) {
        super(clockRate);
        this.setWidth(width);
        this.setHeight(height);
        this.setFrameRate(frameRate);
    }
}

