/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpErrorCause;
import fm.icelink.StringExtensions;

class SctpNoUserData
extends SctpErrorCause {
    private long _tsn;

    @Override
    public byte[] getBytes() {
        return SctpNoUserData.getBytes(this);
    }

    public static byte[] getBytes(SctpNoUserData cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        bytes.addRange(Binary.toBytes16(8, false));
        bytes.addRange(Binary.toBytes32(cause.getTsn(), false));
        return bytes.toArray();
    }

    public long getTsn() {
        return this._tsn;
    }

    public static SctpNoUserData parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            offsetPlus.setValue(8);
            Log.debug(StringExtensions.format("SCTP Error: no user data transmitted in DATA chunk.", new Object[0]));
            return new SctpNoUserData(Binary.fromBytes32(bytes, 4, false));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpNoUserData(long tsn) {
        super.setCauseCode(9);
        this.setTsn(tsn);
    }

    public void setTsn(long value) {
        this._tsn = value;
    }
}

