/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpTlvParameter;

class SctpGenericChunkParameter
extends SctpTlvParameter {
    private byte[] _meaningfulData;

    public static byte[] getBytes(SctpGenericChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(parameter.getType(), false));
        int num = 4 + ArrayExtensions.getLength(parameter.getMeaningfulData());
        bytes.addRange(Binary.toBytes16(num, false));
        bytes.addRange(parameter.getMeaningfulData());
        int num2 = 4 - num % 4;
        if (num2 != 4) {
            bytes.addRange(new byte[num2]);
        }
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return SctpGenericChunkParameter.getBytes(this);
    }

    public byte[] getMeaningfulData() {
        return this._meaningfulData;
    }

    public static SctpGenericChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            offsetPlus.setValue(ArrayExtensions.getLength(bytes));
            return new SctpGenericChunkParameter(bytes);
        }
        catch (Exception exception1) {
            Log.debug("Could not read SupportedExtensionsChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpGenericChunkParameter(byte[] bytes) {
        super.setType(Binary.fromBytes16(bytes, 0, false));
        int num = Binary.fromBytes16(bytes, 2, false);
        this.setMeaningfulData(new byte[num - 4]);
        BitAssistant.copy(bytes, 4, this.getMeaningfulData(), 0, ArrayExtensions.getLength(this.getMeaningfulData()));
    }

    public void setMeaningfulData(byte[] value) {
        this._meaningfulData = value;
    }

    public static SctpGenericChunkParameter toGenericParameter(SctpTlvParameter parameter) {
        try {
            return new SctpGenericChunkParameter(parameter.getBytes());
        }
        catch (Exception exception1) {
            Log.debug("Could not read SupportedExtensionsChunkParameter.");
            return null;
        }
    }
}

