/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.LongExtensions;
import fm.icelink.MediaControlFrame;
import fm.icelink.PayloadSpecificControlFrame;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;

public class RembControlFrame
extends PayloadSpecificControlFrame {
    long getBitrate() {
        return this.getBitrateMantissa() << this.getBitrateExponent();
    }

    public int getBitrateExponent() {
        return super.getDataBuffer().read6(super.getFeedbackControlInformationOffset() + 5, 0);
    }

    public int getBitrateMantissa() {
        return super.getDataBuffer().read18(super.getFeedbackControlInformationOffset() + 5, 6);
    }

    public static int getRegisteredFeedbackMessageType() {
        return 15;
    }

    private static int getRequiredBufferSize(int entryCount) {
        return MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength() + 8 + entryCount * 4;
    }

    public long[] getSsrcEntries() {
        int num = super.getDataBuffer().read8(super.getFeedbackControlInformationOffset() + 4);
        long[] numArray = new long[num];
        int offset = super.getFeedbackControlInformationOffset() + 8;
        for (int i = 0; i < num; ++i) {
            numArray[i] = super.getDataBuffer().read32(offset);
            offset += 4;
        }
        return numArray;
    }

    public RembControlFrame(DataBuffer buffer) {
        super(RembControlFrame.getRegisteredFeedbackMessageType(), buffer);
    }

    public RembControlFrame(long bitrate, long[] ssrcEntries) {
        this(DataBuffer.allocate(RembControlFrame.getRequiredBufferSize(ArrayExtensions.getLength(ssrcEntries))));
        byte[] bytes = new byte[]{82, 69, 77, 66};
        super.getDataBuffer().writeBytes(bytes, super.getFeedbackControlInformationOffset());
        super.getDataBuffer().write8(ArrayExtensions.getLength(ssrcEntries), super.getFeedbackControlInformationOffset() + 4);
        int num = 0;
        for (int i = 0; i < 64; ++i) {
            if (bitrate > (long)(262143 << i)) continue;
            num = i;
            break;
        }
        int num3 = (int)bitrate >> num;
        super.getDataBuffer().write6(num, super.getFeedbackControlInformationOffset() + 5, 0);
        super.getDataBuffer().write18(num3, super.getFeedbackControlInformationOffset() + 5, 6);
        for (int j = 0; j < ArrayExtensions.getLength(ssrcEntries); j += 4) {
            super.getDataBuffer().write32(ssrcEntries[j], super.getFeedbackControlInformationOffset() + 8 + j);
        }
    }

    public void setBitrateExponent(int value) {
        super.getDataBuffer().write6(value, super.getFeedbackControlInformationOffset() + 5, 0);
    }

    public void setBitrateMantissa(int value) {
        super.getDataBuffer().write18(value, super.getFeedbackControlInformationOffset() + 5, 6);
    }

    public void setSsrcEntries(long[] value) {
        long[] numArray = value;
        if (value == null) {
            numArray = new long[]{};
        }
        if (super.getDataBuffer().read8(super.getFeedbackControlInformationOffset() + 4) != ArrayExtensions.getLength(numArray)) {
            super.getDataBuffer().resize(RembControlFrame.getRequiredBufferSize(ArrayExtensions.getLength(numArray)));
            super.getDataBuffer().write8(ArrayExtensions.getLength(numArray), super.getFeedbackControlInformationOffset() + 4);
        }
        int offset = super.getFeedbackControlInformationOffset() + 8;
        for (int i = 0; i < ArrayExtensions.getLength(numArray); ++i) {
            super.getDataBuffer().write32(numArray[i], offset);
            offset += 4;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, "REMB Frame. SSRC(s): ");
        String str = "";
        if (ArrayExtensions.getLength(this.getSsrcEntries()) > 0) {
            for (long num : this.getSsrcEntries()) {
                str = StringExtensions.concat(str, LongExtensions.toString(num), ", ");
            }
            str = StringExtensions.substring(str, 0, StringExtensions.getLength(str) - 2);
        } else {
            str = "N/A";
        }
        StringBuilderExtensions.append(builder, StringExtensions.concat(str, ". Bitrate: "));
        long bitrate = this.getBitrate();
        if (bitrate >= -1L) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(LongExtensions.toString(bitrate), " bps."));
        } else {
            StringBuilderExtensions.append(builder, "N/A.");
        }
        return builder.toString();
    }
}

