/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.CodecStats;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.MediaTrackStats;
import fm.icelink.NullableLong;
import java.util.HashMap;

public abstract class MediaComponentStats
extends BaseStats {
    private CodecStats _codec;
    private long _firCount;
    private long _nackCount;
    private long _pliCount;
    private long _synchronizationSource;
    private MediaTrackStats _track;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "ssrc")) {
                if (Global.equals(str, "track")) {
                    this.setTrack(MediaTrackStats.fromJson(valueJson));
                } else if (Global.equals(str, "codec")) {
                    this.setCodec(CodecStats.fromJson(valueJson));
                } else if (Global.equals(str, "nackCount")) {
                    this.setNackCount(JsonSerializer.deserializeLong(valueJson).getValue());
                } else if (Global.equals(str, "pliCount")) {
                    this.setNackCount(JsonSerializer.deserializeLong(valueJson).getValue());
                } else if (Global.equals(str, "firCount")) {
                    this.setNackCount(JsonSerializer.deserializeLong(valueJson).getValue());
                }
            } else {
                this.setSynchronizationSource(JsonSerializer.deserializeLong(valueJson).getValue());
            }
        }
    }

    public CodecStats getCodec() {
        return this._codec;
    }

    public long getFirCount() {
        return this._firCount;
    }

    public long getNackCount() {
        return this._nackCount;
    }

    public long getPliCount() {
        return this._pliCount;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    public MediaTrackStats getTrack() {
        return this._track;
    }

    protected MediaComponentStats() {
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "ssrc", JsonSerializer.serializeLong(new NullableLong(this.getSynchronizationSource())));
        if (this.getTrack() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "track", MediaTrackStats.toJson(this.getTrack()));
        }
        if (this.getCodec() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "codec", CodecStats.toJson(this.getCodec()));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "nackCount", JsonSerializer.serializeLong(new NullableLong(this.getNackCount())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "pliCount", JsonSerializer.serializeLong(new NullableLong(this.getPliCount())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "firCount", JsonSerializer.serializeLong(new NullableLong(this.getFirCount())));
    }

    void setCodec(CodecStats value) {
        this._codec = value;
    }

    void setFirCount(long value) {
        this._firCount = value;
    }

    void setNackCount(long value) {
        this._nackCount = value;
    }

    void setPliCount(long value) {
        this._pliCount = value;
    }

    void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    void setTrack(MediaTrackStats value) {
        this._track = value;
    }
}

