/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.Build;
import fm.icelink.DateExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IntegerExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.Log;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableLong;
import fm.icelink.RsaCrypto;
import fm.icelink.RsaKey;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import java.util.Date;
import java.util.HashMap;

public class License {
    private static License __license;
    private static String __licenseKey;
    private static volatile boolean __licenseLogged;
    private static RsaKey __publicKey;
    private String _accountId;
    private String _id;
    private boolean _isTrial;
    private String _productCode;
    private byte[] _signature;
    private Date _validFrom = new Date();
    private Date _validTo = new Date();

    public static void checkKey() {
        try {
            if (Build.getYear() != 0 && Build.getMonth() != 0 && Build.getDay() != 0) {
                if (StringExtensions.isNullOrEmpty(__licenseKey)) {
                    String str = StringExtensions.format("License key not set.", new Object[0]);
                    Log.error(str);
                    throw new RuntimeException(new Exception(str));
                }
                if (__license == null) {
                    __license = License.parseKey(__licenseKey);
                }
                if (__license == null) {
                    String str = "Invalid license key.";
                    if (!__licenseLogged) {
                        Log.error(str);
                    }
                    throw new RuntimeException(new Exception(str));
                }
                if (!Global.equals(__license.getProductCode(), "IceLink")) {
                    if (__license.getIsTrial()) {
                        if (__license.getIsValid()) {
                            String str = StringExtensions.format("Valid {0} trial license key detected, but expected a license key for {1}.", __license.getProductCode(), "IceLink");
                            if (!__licenseLogged) {
                                Log.error(str);
                            }
                            throw new RuntimeException(new Exception(str));
                        }
                        String str = StringExtensions.format("Expired {0} trial license key detected, and expected a license key for {1}. Contact sales@frozenmountain.com for more information.", __license.getProductCode(), "IceLink");
                        if (!__licenseLogged) {
                            Log.error(str);
                        }
                        throw new RuntimeException(new Exception(str));
                    }
                    if (__license.getIsValid()) {
                        String str = StringExtensions.format("Valid {0} license key detected, but expected a license key for {1}.", __license.getProductCode(), "IceLink");
                        if (!__licenseLogged) {
                            Log.error(str);
                        }
                        throw new RuntimeException(new Exception(str));
                    }
                    String str = StringExtensions.format("{0} license key is invalid for this build, and expected a license key for {1}. Visit www.frozenmountain.com to generate an updated license key.", __license.getProductCode(), "IceLink");
                    if (!__licenseLogged) {
                        Log.error(str);
                    }
                    throw new RuntimeException(new Exception(str));
                }
                if (!__license.getIsTrial()) {
                    if (!__license.getIsValid()) {
                        String str = StringExtensions.format("{0} license key is invalid for this build. Visit www.frozenmountain.com to generate an updated license key. (License is valid to {1} and build date is {2}.)", __license.getProductCode(), License.getYearMonthDay(__license.getValidTo()), License.getYearMonthDay(Build.getDate()));
                        if (!__licenseLogged) {
                            Log.error(str);
                        }
                        throw new RuntimeException(new Exception(str));
                    }
                    if (!__licenseLogged) {
                        Log.info(StringExtensions.format("Valid {0} license key detected.", __license.getProductCode()));
                    }
                } else {
                    if (!__license.getIsValid()) {
                        String str = StringExtensions.format("Expired {0} trial license key detected. Contact sales@frozenmountain.com for more information. (License is valid from {1} to {2}.)", __license.getProductCode(), License.getYearMonthDay(__license.getValidFrom()), License.getYearMonthDay(__license.getValidTo()));
                        if (!__licenseLogged) {
                            Log.error(str);
                        }
                        throw new RuntimeException(new Exception(str));
                    }
                    if (!__licenseLogged) {
                        Log.info(StringExtensions.format("Valid {0} trial license key detected.", __license.getProductCode()));
                    }
                }
            } else {
                __license = new License();
            }
        }
        finally {
            __licenseLogged = true;
        }
    }

    private static License fromJson(String json) {
        return JsonSerializer.deserializeObject(json, new IFunction0<License>(){

            @Override
            public License invoke() {
                return new License();
            }
        }, new IAction3<License, String, String>(){

            @Override
            public void invoke(License license, String key, String valueJson) {
                String str = key;
                if (str != null) {
                    if (!Global.equals(str, "id")) {
                        NullableLong nullable3;
                        if (Global.equals(str, "aid")) {
                            license.setAccountId(JsonSerializer.deserializeString(valueJson));
                        } else if (Global.equals(str, "pc")) {
                            license.setProductCode(JsonSerializer.deserializeString(valueJson));
                        } else if (Global.equals(str, "it")) {
                            NullableBoolean nullable = JsonSerializer.deserializeBoolean(valueJson);
                            if (nullable.getHasValue()) {
                                license.setIsTrial(nullable.getValue());
                            }
                        } else if (Global.equals(str, "vf")) {
                            NullableLong nullable2 = JsonSerializer.deserializeLong(valueJson);
                            if (nullable2.getHasValue()) {
                                license.setValidFrom(DateExtensions.createDate(nullable2.getValue()));
                            }
                        } else if (Global.equals(str, "vt") && (nullable3 = JsonSerializer.deserializeLong(valueJson)).getHasValue()) {
                            license.setValidTo(DateExtensions.createDate(nullable3.getValue()));
                        }
                    } else {
                        license.setId(JsonSerializer.deserializeString(valueJson));
                    }
                }
            }
        });
    }

    public String getAccountId() {
        return this._accountId;
    }

    public static License getCurrent() {
        return __license;
    }

    public String getId() {
        return this._id;
    }

    public boolean getIsTrial() {
        return this._isTrial;
    }

    public boolean getIsValid() {
        long ticks = DateExtensions.getTicks(this.getValidFrom());
        long num2 = DateExtensions.getTicks(this.getValidTo());
        if (this.getIsTrial()) {
            long num3 = DateExtensions.getTicks(DateExtensions.getUtcNow());
            return num3 >= ticks && num3 <= num2;
        }
        return DateExtensions.getTicks(Build.getDate()) <= num2;
    }

    public String getProductCode() {
        return this._productCode;
    }

    private byte[] getSignature() {
        return this._signature;
    }

    public Date getValidFrom() {
        return this._validFrom;
    }

    public Date getValidTo() {
        return this._validTo;
    }

    private static String getYearMonthDay(Date timestamp) {
        String str = IntegerExtensions.toString(DateExtensions.getYear(timestamp));
        String str2 = IntegerExtensions.toString(DateExtensions.getMonth(timestamp));
        String str3 = IntegerExtensions.toString(DateExtensions.getDay(timestamp));
        while (StringExtensions.getLength(str) < 4) {
            str = StringExtensions.concat("0", str);
        }
        while (StringExtensions.getLength(str2) < 2) {
            str2 = StringExtensions.concat("0", str2);
        }
        while (StringExtensions.getLength(str3) < 2) {
            str3 = StringExtensions.concat("0", str3);
        }
        return StringExtensions.format("{0}-{1}-{2}", str, str2, str3);
    }

    private License(String id, String accountId, String productCode, boolean isTrial, Date validFrom, Date validTo) {
        this();
        this.setId(id);
        this.setAccountId(accountId);
        this.setProductCode(productCode);
        this.setIsTrial(isTrial);
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
    }

    private License() {
    }

    private static License parseKey(String key) {
        if (!StringExtensions.isNullOrEmpty(key)) {
            key = key.trim();
            key = key.replace(" ", StringExtensions.empty);
            key = key.replace("\t", StringExtensions.empty);
            key = key.replace("\r", StringExtensions.empty);
            key = key.replace("\n", StringExtensions.empty);
            Object[] strArray = StringExtensions.split(key, new char[]{'.'});
            if (ArrayExtensions.getLength(strArray) != 2) {
                return null;
            }
            Object str = strArray[0];
            if (StringExtensions.getLength((String)str) >= StringExtensions.getLength("fm")) {
                if (StringExtensions.isNullOrEmpty((String)(str = ((String)str).substring(StringExtensions.getLength("fm"))))) {
                    return null;
                }
                byte[] decoded = null;
                Holder<Object> _var0 = new Holder<Object>(decoded);
                boolean _var1 = Base64.tryDecode((String)str, _var0);
                decoded = _var0.getValue();
                if (!_var1) {
                    return null;
                }
                String json = Utf8.decode(decoded);
                if (json == null) {
                    return null;
                }
                License license = License.fromJson(json);
                if (license == null) {
                    return null;
                }
                Object str3 = strArray[1];
                if (StringExtensions.isNullOrEmpty((String)str3)) {
                    return null;
                }
                byte[] buffer2 = null;
                Holder<Object> _var2 = new Holder<Object>(buffer2);
                boolean _var3 = Base64.tryDecode((String)str3, _var2);
                buffer2 = _var2.getValue();
                if (!_var3) {
                    return null;
                }
                if (!RsaCrypto.verifyRsaSha256(Utf8.encode((String)str), buffer2, __publicKey)) {
                    return null;
                }
                license.setSignature(buffer2);
                return license;
            }
        }
        return null;
    }

    private void setAccountId(String value) {
        this._accountId = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    private void setIsTrial(boolean value) {
        this._isTrial = value;
    }

    public static void setKey(String key) {
        __licenseKey = key;
        __license = License.parseKey(__licenseKey);
        License.checkKey();
    }

    private void setProductCode(String value) {
        this._productCode = value;
    }

    private void setSignature(byte[] value) {
        this._signature = value;
    }

    private void setValidFrom(Date value) {
        this._validFrom = value;
    }

    private void setValidTo(Date value) {
        this._validTo = value;
    }

    private String toJson() {
        return JsonSerializer.serializeObject(this, new IAction2<License, HashMap<String, String>>(){

            @Override
            public void invoke(License license, HashMap<String, String> jsonObj) {
                if (License.this.getId() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "id", JsonSerializer.serializeString(License.this.getId()));
                }
                if (License.this.getAccountId() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "aid", JsonSerializer.serializeString(License.this.getAccountId()));
                }
                if (License.this.getProductCode() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "pc", JsonSerializer.serializeString(License.this.getProductCode()));
                }
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "it", JsonSerializer.serializeBoolean(new NullableBoolean(License.this.getIsTrial())));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "vf", JsonSerializer.serializeLong(new NullableLong(DateExtensions.getTicks(License.this.getValidFrom()))));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "vt", JsonSerializer.serializeLong(new NullableLong(DateExtensions.getTicks(License.this.getValidTo()))));
            }
        });
    }

    static {
        __licenseLogged = false;
        __publicKey = RsaKey.parseBytes(Base64.decode("MIGJAoGBALf/wUlxLUmBEMqd4QHTc+/CP5P3t/BKD+mBNGkRv6CDNreyMuPPGzh3ijr6j//ikY2YzWDCaVuO5SRnZo4+6DwoLQI7nC/m7hcetvYSJhf4mjCeoH8JG1ks1YQeWSbsLp7KjYr5Dan93LIvk6lcjqzv8xO+8msJZ4X9kzW8tO8ZAgMBAAE="));
        Log.info(StringExtensions.format("{0} build version is {1} ({2}-{3}-{4}).", new Object[]{"IceLink", "0.0.0.0", IntegerExtensions.toString(Build.getYear()), IntegerExtensions.toString(Build.getMonth()), IntegerExtensions.toString(Build.getDay())}));
    }
}

