/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.CompareResult;
import fm.icelink.IAction1;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.ILog;
import fm.icelink.Log;
import fm.icelink.ManagedStopwatch;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.PriorityQueue;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class JitterBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private long __calibrationClock;
    private long __calibrationTimestamp;
    private int __clockRatePerMilli;
    private PriorityQueue<TFrame> __frameQueue;
    private long __lastRaisedSequence;
    private static ILog __log = Log.getLogger("FM.IceLink.Jitter.Buffer");
    ManagedStopwatch __stopwatch;
    private int _clockRate;
    private int _length;
    private String _name;
    private int _retransmissionTimeout;

    private CompareResult comparer(TFrame p1, TFrame p2) {
        long num = ((MediaBuffer)((MediaFrame)p1).getBuffer()).getSequenceNumber() - ((MediaBuffer)((MediaFrame)p2).getBuffer()).getSequenceNumber();
        if (num > 0L) {
            return CompareResult.Positive;
        }
        if (num < 0L) {
            return CompareResult.Negative;
        }
        return CompareResult.Equal;
    }

    public int getClockRate() {
        return this._clockRate;
    }

    private int getDeltaMillis() {
        if (this.__frameQueue.getCount() == 0) {
            return -1;
        }
        MediaFrame local = (MediaFrame)this.__frameQueue.peek();
        long num = this.__stopwatch.getElapsedMilliseconds() - this.__calibrationClock;
        long num2 = (long)this.__clockRatePerMilli * num + this.__calibrationTimestamp;
        int num3 = (int)((num2 - local.getTimestamp()) / (long)this.__clockRatePerMilli);
        if (num3 < 0) {
            if (__log.getIsDebugEnabled()) {
                __log.debug(StringExtensions.format("Timestamp reset detected on the remote {0} stream. Will recalibrate.", ((MediaFormat)((MediaBuffer)local.getBuffer()).getFormat()).getName()));
            }
            this.__calibrationTimestamp = -1L;
            return this.getLength() + 1;
        }
        return num3;
    }

    public int getLength() {
        return this._length;
    }

    public String getName() {
        return this._name;
    }

    public int getRetransmissionTimeout() {
        return this._retransmissionTimeout;
    }

    public JitterBuffer(String name, int clockRate, int length) {
        this.setName(name);
        this.setLength(length);
        this.setClockRate(clockRate);
        this.__calibrationTimestamp = -1L;
        this.__frameQueue = new PriorityQueue(new IFunctionDelegate2<TFrame, TFrame, CompareResult>(){

            @Override
            public String getId() {
                return "fm.icelink.JitterBuffer<TFrame,TBuffer,TBufferCollection,TFormat>.comparer";
            }

            @Override
            public CompareResult invoke(TFrame p1, TFrame p2) {
                return JitterBuffer.this.comparer(p1, p2);
            }
        });
        this.__clockRatePerMilli = this.getClockRate() / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(IAction1<TFrame> callback) {
        ArrayList<TFrame> list = new ArrayList<TFrame>();
        PriorityQueue<TFrame> priorityQueue = this.__frameQueue;
        synchronized (priorityQueue) {
            while (this.getDeltaMillis() >= this.getLength()) {
                list.add(this.__frameQueue.dequeue());
            }
        }
        for (MediaFrame local : list) {
            Object buffer = local.getBuffer();
            if (((MediaBuffer)buffer).getSequenceNumber() > this.__lastRaisedSequence) {
                this.__lastRaisedSequence = MathAssistant.max(((MediaBuffer)buffer).getSequenceNumber(), this.__lastRaisedSequence);
                callback.invoke(local);
            }
            ((MediaBuffer)buffer).getDataBuffer().free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(TFrame frame) {
        if (this.__stopwatch == null) {
            this.__stopwatch = new ManagedStopwatch();
            this.__stopwatch.start();
        }
        if (!((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getIsPacketized()) {
            throw new RuntimeException(new Exception("The first Buffer of a Frame stored in a Jitter.Buffer must be of packetized format."));
        }
        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) != 1) {
            throw new RuntimeException(new Exception("Jitter.Buffer only supports a Frame.Buffer.DataBuffers.Length of one."));
        }
        if (((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() <= this.__lastRaisedSequence) {
            return false;
        }
        ((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer().keep();
        PriorityQueue<TFrame> priorityQueue = this.__frameQueue;
        synchronized (priorityQueue) {
            if (this.__calibrationTimestamp == -1L) {
                this.__calibrationTimestamp = ((MediaFrame)frame).getTimestamp();
                this.__calibrationClock = this.__stopwatch.getElapsedMilliseconds();
            }
            this.__frameQueue.enqueue(frame);
        }
        return true;
    }

    private void setClockRate(int value) {
        this._clockRate = value;
    }

    private void setLength(int value) {
        this._length = value;
    }

    private void setName(String value) {
        this._name = value;
    }

    public void setRetransmissionTimeout(int value) {
        this._retransmissionTimeout = value;
    }
}

