/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BooleanHolder;
import fm.icelink.CandidateType;
import fm.icelink.DataBuffer;
import fm.icelink.DatagramSocket;
import fm.icelink.DatagramSocketCreateArgs;
import fm.icelink.Dns;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashContextBase;
import fm.icelink.HashMapExtensions;
import fm.icelink.HashType;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IActionDelegate3;
import fm.icelink.IFunction1;
import fm.icelink.IceCandidate;
import fm.icelink.IceComponent;
import fm.icelink.IceDatagramSocketManager;
import fm.icelink.IceGatherOptions;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IceGatheringState;
import fm.icelink.IceParameters;
import fm.icelink.IcePreferenceSpeedBlock;
import fm.icelink.IceServer;
import fm.icelink.IceSocketManager;
import fm.icelink.IceSocketsServerPair;
import fm.icelink.IceStreamSocketManager;
import fm.icelink.IceTransactionManager;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalAddress;
import fm.icelink.LocalNetwork;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.ManagedSocket;
import fm.icelink.MathAssistant;
import fm.icelink.ParseAssistant;
import fm.icelink.ProtocolType;
import fm.icelink.Scheduler;
import fm.icelink.StreamSocket;
import fm.icelink.StreamSocketCreateArgs;
import fm.icelink.StringExtensions;
import fm.icelink.TcpSocket;
import fm.icelink.TransportAddress;
import fm.icelink.UdpSocket;
import fm.icelink.stun.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class IceGatherer {
    private HashMap<String, IcePreferenceSpeedBlock> __adapterSpeedTable;
    private IceComponent __component;
    private IceCandidate __defaultLocalCandidate = null;
    private int __defaultPortMax = 65534;
    private int __defaultPortMin = 49152;
    private LocalAddress[] __localAddresses;
    private IceParameters __localIceParameters;
    private Object __localPreferencesLock;
    private Object __lock;
    private List<IAction3<DataBuffer, IceCandidate, TransportAddress>> __onIncomingApplicationData = new ArrayList<IAction3<DataBuffer, IceCandidate, TransportAddress>>();
    private List<IAction2<IceGatherer, IceCandidate>> __onLocalCandidate = new ArrayList<IAction2<IceGatherer, IceCandidate>>();
    private List<IAction1<IceGatherer>> __onStateChange = new ArrayList<IAction1<IceGatherer>>();
    private IceGatherOptions __options;
    private IceGatherer __relatedRtcpGatherer;
    private int __resolvesRemaining = 0;
    private DatagramSocket[] __rtcpDatagramSockets;
    private ArrayList<IceSocketsServerPair> __rtcpStreamSocketsAndServers;
    private Scheduler __scheduler;
    private HashMap<String, IceSocketManager> __socketManagers;
    private ArrayList<ManagedSocket> __sockets = new ArrayList();
    private IceGatheringState __state;
    private IceTransactionManager __transactionManager;
    private HashMap<String, Long> __usedLocalPreferences;
    private boolean _closingShouldNotTriggerGlobalNonGracefulShutdown;
    private IFunction1<DatagramSocketCreateArgs, DatagramSocket> _createDatagramSocket;
    private IFunction1<StreamSocketCreateArgs, StreamSocket> _createStreamSocket;
    private Error _error;
    private String _id;
    private IAction3<DataBuffer, IceCandidate, TransportAddress> _onIncomingApplicationData = null;
    private IAction2<IceGatherer, IceCandidate> _onLocalCandidate = null;
    private IAction1<IceGatherer> _onStateChange = null;
    private IAction3<Message, IceCandidate, TransportAddress> _onStunRequest;
    private boolean _verboseLogging = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewSocketManager(IceSocketManager socketManager) {
        String key = this.prepareSocketManagerKey(socketManager.getProtocol(), socketManager.getLocalIpAddress(), socketManager.getLocalPort());
        Object object = this.__lock;
        synchronized (object) {
            HashMapExtensions.add(this.__socketManagers, key, socketManager);
        }
    }

    public void addOnIncomingApplicationData(IAction3<DataBuffer, IceCandidate, TransportAddress> value) {
        if (value != null) {
            if (this._onIncomingApplicationData == null) {
                this._onIncomingApplicationData = new IAction3<DataBuffer, IceCandidate, TransportAddress>(){

                    @Override
                    public void invoke(DataBuffer p0, IceCandidate p1, TransportAddress p2) {
                        for (IAction3 action : new ArrayList(IceGatherer.this.__onIncomingApplicationData)) {
                            action.invoke(p0, p1, p2);
                        }
                    }
                };
            }
            this.__onIncomingApplicationData.add(value);
        }
    }

    public void addOnLocalCandidate(IAction2<IceGatherer, IceCandidate> value) {
        if (value != null) {
            if (this._onLocalCandidate == null) {
                this._onLocalCandidate = new IAction2<IceGatherer, IceCandidate>(){

                    @Override
                    public void invoke(IceGatherer p0, IceCandidate p1) {
                        for (IAction2 action : new ArrayList(IceGatherer.this.__onLocalCandidate)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onLocalCandidate.add(value);
        }
    }

    public void addOnStateChange(IAction1<IceGatherer> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<IceGatherer>(){

                    @Override
                    public void invoke(IceGatherer p0) {
                        for (IAction1 action : new ArrayList(IceGatherer.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamSockets(IceSocketsServerPair socketsAndServers) {
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getComponent(), (Object)IceComponent.Rtcp) && socketsAndServers != null) {
                if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Complete)) {
                    this.setState(IceGatheringState.Gathering);
                    IceServer server = socketsAndServers.getServer();
                    ManagedSocket[] sockets = socketsAndServers.getSockets();
                    ArrayListExtensions.addRange(this.__sockets, sockets);
                    this.prepareStreamSocketManagers(sockets, server, server.getIPAddress());
                } else if (Global.equals((Object)this.getState(), (Object)IceGatheringState.New)) {
                    ManagedSocket[] sockets = socketsAndServers.getSockets();
                    ArrayListExtensions.addRange(this.__sockets, sockets);
                    this.__rtcpStreamSocketsAndServers.add(socketsAndServers);
                } else {
                    ManagedSocket[] sockets;
                    for (ManagedSocket socket : sockets = socketsAndServers.getSockets()) {
                        socket.close();
                    }
                }
            } else {
                ManagedSocket[] sockets;
                ManagedSocket[] managedSocketArray = sockets = socketsAndServers == null ? null : socketsAndServers.getSockets();
                if (sockets != null) {
                    for (ManagedSocket socket : sockets) {
                        socket.close();
                    }
                }
                this.setError(new Error(ErrorCode.IceUnsuitableSocketAssignment, new Exception(StringExtensions.format("Excpected component: RTP. Found component: {0}.", this.getComponent().toString()))));
                this.setState(IceGatheringState.Failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assignDatagramSockets(ManagedSocket[] udpSockets) {
        if (udpSockets != null) {
            Object object = this.__lock;
            synchronized (object) {
                if (Global.equals((Object)this.getComponent(), (Object)IceComponent.Rtcp) && Global.equals((Object)this.getState(), (Object)IceGatheringState.New)) {
                    ArrayListExtensions.addRange(this.__sockets, udpSockets);
                    DatagramSocket[] socketArray = new DatagramSocket[ArrayExtensions.getLength(udpSockets)];
                    for (int i = 0; i < ArrayExtensions.getLength(udpSockets); ++i) {
                        socketArray[i] = (DatagramSocket)udpSockets[i];
                    }
                    this.__rtcpDatagramSockets = socketArray;
                } else {
                    for (ManagedSocket socket : udpSockets) {
                        socket.close();
                    }
                    this.setError(new Error(ErrorCode.IceUnsuitableSocketAssignment, new Exception(StringExtensions.format("Excpected component: RTP, expected state: New. Found component: {0}, found state: {1}.", this.getComponent().toString(), this.getState().toString()))));
                    this.setState(IceGatheringState.Failed);
                }
            }
        }
    }

    int assignLocalPreference(long speed) {
        int unset = IceCandidate.getUnset();
        String key = LongExtensions.toString(speed);
        if (this.__adapterSpeedTable.containsKey(key)) {
            unset = HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).getStart() - 1;
            if (unset >= 0 && !this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(unset))) {
                int num2 = HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).getStart() - 1;
                HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).setStart(num2);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(unset), speed);
                return unset;
            }
            if (HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).getStop() < 65535 && !this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).getStop() + 1))) {
                int num3;
                unset = num3 = HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).getStop() + 1;
                HashMapExtensions.getItem(this.__adapterSpeedTable).get(key).setStop(num3);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(unset), speed);
                return unset;
            }
            if ((unset = this.assignLocalPreferenceSuboptimally(unset)) != IceCandidate.getUnset()) {
                HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(unset), speed);
            }
            return unset;
        }
        if (HashMapExtensions.getCount(this.__adapterSpeedTable) == 0) {
            unset = 32676;
            HashMapExtensions.set(HashMapExtensions.getItem(this.__adapterSpeedTable), key, new IcePreferenceSpeedBlock(unset, unset));
            HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(unset), speed);
            return unset;
        }
        long num4 = -1L;
        long num5 = -1L;
        for (String str2 : HashMapExtensions.getKeys(this.__adapterSpeedTable)) {
            long num6 = ParseAssistant.parseLongValue(str2);
            if (num6 > num4 && num6 < speed) {
                num4 = num6;
                continue;
            }
            if (num6 >= num5 && num5 >= 0L || num6 <= speed) continue;
            num5 = num6;
        }
        int startPreference = num4 < 0L ? 0 : HashMapExtensions.getItem(this.__adapterSpeedTable).get(LongExtensions.toString(num4)).getStop() + 1;
        int num8 = num5 < 0L ? 65535 : HashMapExtensions.getItem(this.__adapterSpeedTable).get(LongExtensions.toString(num5)).getStart() - 1;
        int start = unset;
        if (num8 > startPreference) {
            double num10 = 0.5 * (double)(num8 + startPreference);
            start = (int)MathAssistant.floor(num10);
            if (this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(start))) {
                --start;
                while (start >= startPreference && this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(start))) {
                    --start;
                }
                if (start < startPreference) {
                    for (start = (int)MathAssistant.floor(num10) + 1; start <= num8 && this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(start)); ++start) {
                    }
                }
            }
            if (start >= startPreference && start <= num8) {
                HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(start), speed);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__adapterSpeedTable), key, new IcePreferenceSpeedBlock(start, start));
                return start;
            }
            unset = this.assignLocalPreferenceSuboptimally(start);
            if (unset != IceCandidate.getUnset()) {
                HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(unset), speed);
            }
            return unset;
        }
        unset = this.assignLocalPreferenceSuboptimally(startPreference);
        if (unset != IceCandidate.getUnset()) {
            HashMapExtensions.set(HashMapExtensions.getItem(this.__usedLocalPreferences), IntegerExtensions.toString(unset), speed);
        }
        return unset;
    }

    private int assignLocalPreferenceSuboptimally(int startPreference) {
        int unset;
        for (unset = startPreference; this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(unset)) && unset >= 0; --unset) {
        }
        if (unset < 0) {
            for (unset = startPreference; this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(unset)) && unset <= 65535; ++unset) {
            }
        }
        if (unset == 65535 && this.__usedLocalPreferences.containsKey(IntegerExtensions.toString(unset))) {
            unset = IceCandidate.getUnset();
            Log.error("Failed to assign local preference to a candidate");
        }
        return unset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceGatherer createRtcpGatherer() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__relatedRtcpGatherer == null) {
                if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Closing) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Closed)) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Gatherer cannot create related RTCP gatherer in state {0}.", this.getState().toString())));
                }
                if (Global.equals((Object)this.__component, (Object)IceComponent.Rtcp)) {
                    throw new RuntimeException(new Exception("RTCP Gatherer cannot create related RTCP gatherer."));
                }
                this.__relatedRtcpGatherer = new IceGatherer(this.__lock, this.__scheduler, this.__options, this.__localIceParameters, IceComponent.Rtcp);
            }
            return this.__relatedRtcpGatherer;
        }
    }

    private void createTcpSocket(boolean ipv6, String ipAddress, int port, Holder<StreamSocket> socket, BooleanHolder addressInUse) {
        boolean _var0;
        socket.setValue(null);
        if (this.getCreateStreamSocket() != null) {
            socket.setValue(this.getCreateStreamSocket().invoke(new StreamSocketCreateArgs(true, ipv6, false)));
        }
        if (socket.getValue() == null) {
            socket.setValue(new TcpSocket(false, ipv6, false));
        }
        if (!(_var0 = socket.getValue().bind(ipAddress, port, addressInUse))) {
            try {
                socket.getValue().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket.setValue(null);
        }
    }

    private void createUdpSocket(boolean ipv6, String ipAddress, int port, Holder<DatagramSocket> socket, BooleanHolder addressInUse) {
        boolean _var0;
        socket.setValue(null);
        if (this.getCreateDatagramSocket() != null) {
            socket.setValue(this.getCreateDatagramSocket().invoke(new DatagramSocketCreateArgs(ipv6)));
        }
        if (socket.getValue() == null) {
            socket.setValue(new UdpSocket(ipv6));
        }
        if (!(_var0 = socket.getValue().bind(ipAddress, port, addressInUse))) {
            try {
                socket.getValue().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket.setValue(null);
        }
    }

    private void dnsResolveCallback(String[] serverIPAddress, Object stateObj) {
        this.doDnsResolveCallback(serverIPAddress, stateObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDnsResolveCallback(String[] serverIPAddresses, Object stateObj) {
        Object object = this.__lock;
        synchronized (object) {
            --this.__resolvesRemaining;
            if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Failed) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Closing) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Closed)) {
                return false;
            }
            IceServer server = (IceServer)stateObj;
            boolean flag = false;
            if ((serverIPAddresses == null || ArrayExtensions.getLength(serverIPAddresses) == 0) && TransportAddress.isIPAddress(server.getHost())) {
                serverIPAddresses = new String[]{server.getHost()};
            }
            ArrayList<String> list = new ArrayList<String>();
            if (serverIPAddresses != null && ArrayExtensions.getLength(serverIPAddresses) > 0) {
                ArrayList<String> list2 = new ArrayList<String>();
                for (String str : serverIPAddresses) {
                    if (!TransportAddress.isIPAddress(str)) continue;
                    flag = true;
                    list.add(str);
                    list2.add(Global.equals((Object)LocalNetwork.getAddressType(str), (Object)AddressType.IPv4) ? StringExtensions.format("{0}:{1}", str, IntegerExtensions.toString(server.getPort())) : StringExtensions.format("[{0}]:{1}", str, IntegerExtensions.toString(server.getPort())));
                }
                if (!Global.equals(server.getHost(), serverIPAddresses[0])) {
                    Log.debug(StringExtensions.format("Server address '{0}' resolved to {1}.", server.getHost(), StringExtensions.join(", ", list2.toArray(new String[0]))));
                }
                server.setIPAddresses(list.toArray(new String[0]));
            }
            if (!flag) {
                Log.error(StringExtensions.format("Server address '{0}' could not be resolved.", server.getHost()));
                if (this.getAllSocketManagersCompleteFailedOrClosedAndAtLeastOneCompleted() && this.__resolvesRemaining == 0) {
                    this.setState(IceGatheringState.Complete);
                }
            } else {
                if (server.getIsTcp() && Global.equals((Object)this.getComponent(), (Object)IceComponent.Rtp)) {
                    Object[] primarySockets = null;
                    ManagedSocket[] complementarySockets = null;
                    boolean flag2 = false;
                    int num = 0;
                    String ipAddress = "";
                    while (num < ArrayListExtensions.getCount(list) && !flag2) {
                        Holder<Object> _var0 = new Holder<Object>(primarySockets);
                        Holder<Object> _var1 = new Holder<Object>(complementarySockets);
                        this.openSockets(ProtocolType.Tcp, _var0, _var1);
                        primarySockets = _var0.getValue();
                        complementarySockets = _var1.getValue();
                        ipAddress = (String)ArrayListExtensions.getItem(list).get(num);
                        if (primarySockets != null && ArrayExtensions.getLength(primarySockets) > 0) {
                            flag2 = this.prepareStreamSocketManagers((ManagedSocket[])primarySockets, server, ipAddress);
                        }
                        ++num;
                        if (flag2) continue;
                        if (complementarySockets != null) {
                            for (ManagedSocket managedSocket : complementarySockets) {
                                managedSocket.close();
                            }
                        }
                        complementarySockets = null;
                        if (primarySockets != null) {
                            for (Object object2 : primarySockets) {
                                ((ManagedSocket)object2).close();
                            }
                        }
                        primarySockets = null;
                    }
                    if (!flag2) {
                        this.setError(this.getError() == null ? new Error(ErrorCode.SocketClosed, new Exception("Failed to open stream sockets.")) : this.getError());
                        this.setState(IceGatheringState.Failed);
                        return false;
                    }
                    server.setIPAddress(ipAddress);
                    ArrayListExtensions.addRange(this.__sockets, primarySockets);
                    if (this.__relatedRtcpGatherer != null && complementarySockets != null) {
                        this.__relatedRtcpGatherer.addStreamSockets(new IceSocketsServerPair(complementarySockets, server));
                    }
                }
                this.gatherLocalNonHostCandidates(server, this.__options.getPolicy());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessAllocationMismatchException(IceSocketManager socketManager) {
        int numberOfStunRequests = socketManager.getNumberOfStunRequests();
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) && !Global.equals((Object)this.getState(), (Object)IceGatheringState.Complete)) {
                return false;
            }
            if (this.__relatedRtcpGatherer != null || Global.equals((Object)this.getComponent(), (Object)IceComponent.Rtcp)) {
                Log.error("Handling allocation mismatch exceptions is not supported for non-multiplexed cases. TURN relay will not be available.");
                return false;
            }
            int minimum = this.__defaultPortMin;
            int maximum = this.__defaultPortMax;
            if (this.getOptions() != null && this.getOptions().getPortRange() != null) {
                minimum = this.getOptions().getPortRange().getMinimum();
                maximum = this.getOptions().getPortRange().getMaximum();
            }
            String localIpAddress = socketManager.getLocalIpAddress();
            boolean addressInUse = false;
            ArrayList<String> list = new ArrayList<String>();
            boolean flag2 = Global.equals((Object)LocalNetwork.getAddressType(localIpAddress), (Object)AddressType.IPv6);
            ManagedSocket socket = null;
            DatagramSocket socket2 = null;
            StreamSocket socket3 = null;
            while (socket == null) {
                int port = LockedRandomizer.next(minimum / 2, maximum / 2 + 1) * 2;
                if (!list.contains(IntegerExtensions.toString(port))) {
                    if (Global.equals((Object)socketManager.getProtocol(), (Object)ProtocolType.Udp)) {
                        Holder<Object> _var0 = new Holder<Object>(socket2);
                        BooleanHolder _var1 = new BooleanHolder(addressInUse);
                        this.createUdpSocket(flag2, localIpAddress, port, _var0, _var1);
                        socket2 = _var0.getValue();
                        addressInUse = _var1.getValue();
                        socket = socket2;
                    } else {
                        Holder<Object> _var2 = new Holder<Object>(socket3);
                        BooleanHolder _var3 = new BooleanHolder(addressInUse);
                        this.createTcpSocket(flag2, localIpAddress, port, _var2, _var3);
                        socket3 = _var2.getValue();
                        addressInUse = _var3.getValue();
                        socket = socket3;
                    }
                    if (socket == null) {
                        if (!addressInUse) {
                            Log.warn(StringExtensions.format("Could not gather new host candidates from {0}. Socket error. TURN will not be available on this interface.", localIpAddress));
                            return false;
                        }
                        list.add(IntegerExtensions.toString(port));
                    } else {
                        socket.setAdapterSpeed(socketManager.getAdapterSpeed());
                    }
                }
                if (ArrayListExtensions.getCount(list) != maximum - minimum) continue;
                Log.warn(StringExtensions.format("Could not gather new host candidates from {0}. All ports are in use. TURN will not be available on this interface.", localIpAddress));
                return false;
            }
            try {
                IceSocketManager manager = null;
                if (Global.equals((Object)socketManager.getProtocol(), (Object)ProtocolType.Udp)) {
                    manager = new IceDatagramSocketManager(this.__lock, socket2, this.__transactionManager);
                } else {
                    IceServer server = ((IceStreamSocketManager)socketManager).getServer();
                    manager = new IceStreamSocketManager(this.__lock, socket3, this.__transactionManager, server, this.__scheduler);
                }
                manager.setOnLocalCandidate((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processLocalCandidate";
                    }

                    @Override
                    public void invoke(IceCandidate localCandidate) {
                        IceGatherer.this.processLocalCandidate(localCandidate);
                    }
                });
                manager.setOnStateChange((IAction1<IceSocketManager>)new IActionDelegate1<IceSocketManager>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processSocketManagerStateChanged";
                    }

                    @Override
                    public void invoke(IceSocketManager sm) {
                        IceGatherer.this.processSocketManagerStateChanged(sm);
                    }
                });
                manager.setOnStunRequest((IAction3<Message, IceCandidate, TransportAddress>)new IActionDelegate3<Message, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processStunRequest";
                    }

                    @Override
                    public void invoke(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
                        IceGatherer.this.processStunRequest(message, localCandidate, remoteAddress);
                    }
                });
                manager.setOnIncomingData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processReceivedData";
                    }

                    @Override
                    public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                        IceGatherer.this.processReceivedData(data, localCandidate, remoteAddress);
                    }
                });
                manager.setOnAllocationMismatchException((IAction1<IceSocketManager>)new IActionDelegate1<IceSocketManager>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processAllocationMismatchException";
                    }

                    @Override
                    public void invoke(IceSocketManager socketManager) {
                        IceGatherer.this.processAllocationMismatchException(socketManager);
                    }
                });
                manager.setNumberOfStunRequests(numberOfStunRequests);
                this.addNewSocketManager(manager);
                this.tryStartSocketManager(manager);
                this.setState(IceGatheringState.Gathering);
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Cannot start socket manager for a new socket. TURN relay will not be available. {0}", exception.getMessage()));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finaliseClosing() {
        Object object = this.__lock;
        synchronized (object) {
            this.__socketManagers.clear();
        }
        this.setState(IceGatheringState.Closed);
    }

    public IceCandidate findMatchingLocalCandidate(String ipAddress, int port) {
        for (IceCandidate candidate : this.getLocalCandidates()) {
            if (!Global.equals(candidate.getIPAddress(), ipAddress) || candidate.getPort() != port) continue;
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherLocalNonHostCandidates(IceServer server, IceGatherPolicy policy) {
        Object object = this.__lock;
        synchronized (object) {
            ArrayList<IceSocketManager> list = new ArrayList<IceSocketManager>();
            for (IceSocketManager manager : HashMapExtensions.getValues(this.__socketManagers)) {
                list.add(manager);
            }
            for (IceSocketManager manager : list) {
                if (!Global.equals((Object)manager.getProtocol(), (Object)ProtocolType.Udp) || !server.getIsUdp()) continue;
                ((IceDatagramSocketManager)manager).gatherLocalNonHostCandidates(server, policy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getAllSocketManagersCompleteFailedOrClosedAndAtLeastOneCompleted() {
        boolean flag2;
        int num = 0;
        int num2 = 0;
        int num3 = 0;
        int num4 = 0;
        int num5 = 0;
        int num6 = 0;
        int num7 = 0;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        ArrayList<String> list3 = new ArrayList<String>();
        Object object = this.__lock;
        synchronized (object) {
            for (IceSocketManager manager : HashMapExtensions.getValues(this.__socketManagers)) {
                ++num4;
                num += Global.equals((Object)manager.getState(), (Object)IceGatheringState.Complete) ? 1 : 0;
                num3 += Global.equals((Object)manager.getState(), (Object)IceGatheringState.Closed) ? 1 : 0;
                num5 += Global.equals((Object)manager.getState(), (Object)IceGatheringState.New) ? 1 : 0;
                num7 += Global.equals((Object)manager.getState(), (Object)IceGatheringState.Closing) ? 1 : 0;
                String str = StringExtensions.empty;
                if (Global.equals((Object)manager.getProtocol(), (Object)ProtocolType.Tcp)) {
                    IceStreamSocketManager manager2 = (IceStreamSocketManager)manager;
                    str = StringExtensions.concat("/ ", manager2.getServer().getUrl());
                }
                if (Global.equals((Object)manager.getState(), (Object)IceGatheringState.Failed)) {
                    ++num2;
                    list.add(StringExtensions.concat(manager.getProtocol().toString(), str));
                    continue;
                }
                if (!Global.equals((Object)manager.getState(), (Object)IceGatheringState.Gathering)) continue;
                ++num6;
                list2.add(StringExtensions.concat(manager.getProtocol().toString(), str));
                list3.add(manager.getLocalIpAddress() == null ? "NoIp" : manager.getLocalIpAddress());
            }
        }
        boolean flag = num > 0;
        boolean bl = flag2 = num2 + num3 + num == num4;
        if (this._verboseLogging) {
            Log.debug(StringExtensions.format("For gatherer {0}, there are {1} socket managers in total: {2} new, {3} gathering, {4} complete, {5} closing, {6} closed, {7} failed", new Object[]{this.getId(), IntegerExtensions.toString(num4), IntegerExtensions.toString(num5), IntegerExtensions.toString(num6), IntegerExtensions.toString(num), IntegerExtensions.toString(num7), IntegerExtensions.toString(num3), IntegerExtensions.toString(num2)}));
            Log.debug(StringExtensions.concat("Still gathering on: ", ArrayListExtensions.getCount(list2) == 0 ? StringExtensions.concat(StringExtensions.join(", ", list2.toArray(new String[0])), "; with local ips: ", StringExtensions.join(", ", list3.toArray(new String[0]))) : " none."));
            Log.debug(StringExtensions.concat("Failed: ", ArrayListExtensions.getCount(list) == 0 ? StringExtensions.join(", ", list.toArray(new String[0])) : " none."));
        }
        return flag && flag2;
    }

    public boolean getClosingShouldNotTriggerGlobalNonGracefulShutdown() {
        return this._closingShouldNotTriggerGlobalNonGracefulShutdown;
    }

    public IceComponent getComponent() {
        return this.__component;
    }

    public IFunction1<DatagramSocketCreateArgs, DatagramSocket> getCreateDatagramSocket() {
        return this._createDatagramSocket;
    }

    public IFunction1<StreamSocketCreateArgs, StreamSocket> getCreateStreamSocket() {
        return this._createStreamSocket;
    }

    IceCandidate getDefaultLocalCandidate() {
        if (this.__defaultLocalCandidate == null) {
            Object[] localCandidates = this.getLocalCandidates();
            Object candidate = null;
            Object candidate2 = null;
            if (ArrayExtensions.getLength(localCandidates) > 0) {
                for (Object candidate3 : localCandidates) {
                    AddressType addressType = LocalNetwork.getAddressType(((IceCandidate)candidate3).getIPAddress());
                    if (Global.equals((Object)((IceCandidate)candidate3).getType(), (Object)CandidateType.ServerReflexive)) {
                        if (Global.equals((Object)addressType, (Object)AddressType.IPv4)) {
                            candidate = candidate3;
                            continue;
                        }
                        candidate2 = candidate3;
                        continue;
                    }
                    if (Global.equals((Object)((IceCandidate)candidate3).getType(), (Object)CandidateType.Relayed)) {
                        if (Global.equals((Object)addressType, (Object)AddressType.IPv4)) {
                            if (candidate != null && !Global.equals((Object)((IceCandidate)candidate).getType(), (Object)CandidateType.Host)) continue;
                            candidate = candidate3;
                            continue;
                        }
                        if (candidate2 != null && !Global.equals((Object)((IceCandidate)candidate2).getType(), (Object)CandidateType.Host)) continue;
                        candidate2 = candidate3;
                        continue;
                    }
                    if (!Global.equals((Object)((IceCandidate)candidate3).getType(), (Object)CandidateType.Host)) continue;
                    if (Global.equals((Object)addressType, (Object)AddressType.IPv4) && candidate == null) {
                        candidate = candidate3;
                        continue;
                    }
                    if (candidate2 != null) continue;
                    candidate2 = candidate3;
                }
            }
            this.__defaultLocalCandidate = candidate == null ? candidate2 : candidate;
        }
        return this.__defaultLocalCandidate;
    }

    public Error getError() {
        return this._error;
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidate[] getLocalCandidates() {
        ArrayList list = new ArrayList();
        Object object = this.__lock;
        synchronized (object) {
            for (IceSocketManager manager : HashMapExtensions.getValues(this.__socketManagers)) {
                ArrayListExtensions.addRange(list, HashMapExtensions.getValues(manager._localCandidates));
            }
        }
        return list.toArray(new IceCandidate[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceParameters getLocalParameters() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__localIceParameters == null) {
                String inputString = StringExtensions.substring(Guid.newGuid().toString().replace("-", ""), 0, 8);
                String password = HashContextBase.compute(HashType.Md5, inputString).toHexString();
                this.__localIceParameters = new IceParameters(inputString, password);
            }
            return this.__localIceParameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IceSocketManager getManager(IceCandidate candidate) {
        IceCandidate candidate2 = candidate.getBase();
        int num = 3;
        while (!Global.equals(candidate2, candidate2.getBase()) && num > 0) {
            candidate2 = candidate2.getBase();
            if (--num > 0) continue;
            Log.error("Cannot find local base candidate.");
        }
        String key = this.prepareSocketManagerKey(candidate2.getDiscoverProtocol(), candidate2.getIPAddress(), candidate2.getPort());
        IceSocketManager manager = null;
        Object object = this.__lock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(manager);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__socketManagers, key, _var0);
            manager = _var0.getValue();
        }
        return manager;
    }

    IAction3<Message, IceCandidate, TransportAddress> getOnStunRequest() {
        return this._onStunRequest;
    }

    public IceGatherOptions getOptions() {
        return this.__options;
    }

    IceGatherer getRelatedRtcpGatherer() {
        return this.__relatedRtcpGatherer;
    }

    public IceGatheringState getState() {
        return this.__state;
    }

    IceTransactionManager getTransactionManager() {
        return this.__transactionManager;
    }

    public IceGatherer(Object lockObject, Scheduler scheduler, IceGatherOptions options, IceParameters localParameters, IceComponent component) {
        this.__socketManagers = new HashMap();
        this.__adapterSpeedTable = new HashMap();
        this.__usedLocalPreferences = new HashMap();
        this.__localPreferencesLock = new Object();
        this.__lock = lockObject;
        this.__scheduler = scheduler;
        this.setId(Guid.newGuid().toString().replace("-", ""));
        if (options == null) {
            throw new RuntimeException(new Exception("Gatherer: Null options argument."));
        }
        this.setState(IceGatheringState.New);
        this.__component = component;
        this.__options = options;
        this.setCreateDatagramSocket(options.getCreateDatagramSocket());
        this.setCreateStreamSocket(options.getCreateStreamSocket());
        if (localParameters != null) {
            this.__localIceParameters = localParameters;
        }
        if (this.__options.getServers() != null) {
            this.__resolvesRemaining = ArrayExtensions.getLength(this.__options.getServers());
        }
        if (Global.equals((Object)component, (Object)IceComponent.Rtcp)) {
            this.__rtcpStreamSocketsAndServers = new ArrayList();
        }
    }

    public IceGatherer(Object lockObject, Scheduler scheduler, IceGatherOptions options, IceParameters localParameters) {
        this(lockObject, scheduler, options, localParameters, IceComponent.Rtp);
    }

    public IceGatherer(Object lockObject, Scheduler scheduler, IceGatherOptions options) {
        this(lockObject, scheduler, options, null);
    }

    private void openSockets(ProtocolType protocol, Holder<ManagedSocket[]> primarySockets, Holder<ManagedSocket[]> complementarySockets) {
        int minimum = this.__defaultPortMin;
        int maximum = this.__defaultPortMax;
        if (this.getOptions() != null && this.getOptions().getPortRange() != null) {
            minimum = this.getOptions().getPortRange().getMinimum();
            maximum = this.getOptions().getPortRange().getMaximum();
        }
        ArrayList<ManagedSocket> list = new ArrayList<ManagedSocket>();
        ArrayList<ManagedSocket> list2 = new ArrayList<ManagedSocket>();
        for (LocalAddress address : this.__localAddresses) {
            boolean addressInUse = false;
            ArrayList<String> list3 = new ArrayList<String>();
            boolean flag2 = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
            ManagedSocket item = null;
            ManagedSocket socket2 = null;
            boolean flag3 = false;
            boolean flag4 = false;
            while (item == null && !flag3 && !flag4) {
                int port = LockedRandomizer.next(minimum / 2, maximum / 2 + 1) * 2;
                if (!list3.contains(IntegerExtensions.toString(port))) {
                    StreamSocket socket4;
                    DatagramSocket socket3;
                    if (Global.equals((Object)protocol, (Object)ProtocolType.Udp)) {
                        socket3 = null;
                        Holder<Object> _var0 = new Holder<Object>(socket3);
                        BooleanHolder _var1 = new BooleanHolder(addressInUse);
                        this.createUdpSocket(flag2, address.getIPAddress(), port, _var0, _var1);
                        socket3 = _var0.getValue();
                        addressInUse = _var1.getValue();
                        item = socket3;
                    } else {
                        socket4 = null;
                        Holder<Object> _var2 = new Holder<Object>(socket4);
                        BooleanHolder _var3 = new BooleanHolder(addressInUse);
                        this.createTcpSocket(flag2, address.getIPAddress(), port, _var2, _var3);
                        socket4 = _var2.getValue();
                        addressInUse = _var3.getValue();
                        item = socket4;
                    }
                    if (item == null) {
                        if (addressInUse) {
                            list3.add(IntegerExtensions.toString(port));
                        } else {
                            String str = Global.equals((Object)protocol, (Object)ProtocolType.Udp) ? "UDP" : "TCP";
                            Log.warn(StringExtensions.format("Could not gather host candidates from {0}. {1} socket error.", address.toString(), str));
                            flag3 = true;
                        }
                    } else {
                        item.setAdapterSpeed(address.getAdapterSpeed());
                        list.add(item);
                        if (this.__relatedRtcpGatherer != null) {
                            if (Global.equals((Object)protocol, (Object)ProtocolType.Udp)) {
                                socket3 = null;
                                Holder<DatagramSocket> _var4 = new Holder<DatagramSocket>(socket3);
                                BooleanHolder _var5 = new BooleanHolder(addressInUse);
                                this.createUdpSocket(flag2, address.getIPAddress(), port + 1, _var4, _var5);
                                socket3 = _var4.getValue();
                                addressInUse = _var5.getValue();
                                socket2 = socket3;
                            } else {
                                socket4 = null;
                                Holder<StreamSocket> _var6 = new Holder<StreamSocket>(socket4);
                                BooleanHolder _var7 = new BooleanHolder(addressInUse);
                                this.createTcpSocket(flag2, address.getIPAddress(), port + 1, _var6, _var7);
                                socket4 = _var6.getValue();
                                addressInUse = _var7.getValue();
                                socket2 = socket4;
                            }
                            if (socket2 == null) {
                                if (addressInUse) {
                                    list3.add(IntegerExtensions.toString(port));
                                    item.close();
                                } else {
                                    Log.warn(StringExtensions.format("Could not gather host candidates from {0}. Socket error.", address.toString()));
                                    flag3 = true;
                                }
                            } else {
                                socket2.setAdapterSpeed(address.getAdapterSpeed());
                                list2.add(socket2);
                            }
                        }
                    }
                }
                if (flag3 || ArrayListExtensions.getCount(list3) < (maximum - minimum) / 2) continue;
                Log.warn(StringExtensions.format("Could not gather host candidates from {0}. All ports are in use.", address.toString()));
                flag4 = true;
            }
        }
        primarySockets.setValue(list.toArray(new ManagedSocket[0]));
        complementarySockets.setValue(list2.toArray(new ManagedSocket[0]));
    }

    private String prepareSocketManagerKey(ProtocolType protocol, String ip, int port) {
        String str = "";
        ProtocolType _var0 = protocol;
        if (_var0 == ProtocolType.Udp) {
            str = "udp";
        } else if (_var0 == ProtocolType.Tcp) {
            str = "tcp";
        } else if (_var0 == ProtocolType.Unknown) {
            str = "unknown";
        }
        return StringExtensions.concat(new String[]{str, ":", ip, ":", IntegerExtensions.toString(port)});
    }

    private boolean prepareStreamSocketManagers(ManagedSocket[] sockets, IceServer server, String ipAddress) {
        IceStreamSocketManager socketManager = null;
        ArrayList<IceStreamSocketManager> list = new ArrayList<IceStreamSocketManager>();
        try {
            for (ManagedSocket socket : sockets) {
                IceStreamSocketManager manager2 = new IceStreamSocketManager(this.__lock, (StreamSocket)socket, this.__transactionManager, server, this.__scheduler);
                manager2.setOnLocalCandidate((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processLocalCandidate";
                    }

                    @Override
                    public void invoke(IceCandidate localCandidate) {
                        IceGatherer.this.processLocalCandidate(localCandidate);
                    }
                });
                manager2.setOnStateChange((IAction1<IceSocketManager>)new IActionDelegate1<IceSocketManager>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processSocketManagerStateChanged";
                    }

                    @Override
                    public void invoke(IceSocketManager sm) {
                        IceGatherer.this.processSocketManagerStateChanged(sm);
                    }
                });
                manager2.setOnStunRequest((IAction3<Message, IceCandidate, TransportAddress>)new IActionDelegate3<Message, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processStunRequest";
                    }

                    @Override
                    public void invoke(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
                        IceGatherer.this.processStunRequest(message, localCandidate, remoteAddress);
                    }
                });
                manager2.setOnIncomingData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processReceivedData";
                    }

                    @Override
                    public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                        IceGatherer.this.processReceivedData(data, localCandidate, remoteAddress);
                    }
                });
                manager2.setOnAllocationMismatchException((IAction1<IceSocketManager>)new IActionDelegate1<IceSocketManager>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.processAllocationMismatchException";
                    }

                    @Override
                    public void invoke(IceSocketManager socketManager) {
                        IceGatherer.this.processAllocationMismatchException(socketManager);
                    }
                });
                socketManager = manager2;
                this.addNewSocketManager(socketManager);
                list.add(socketManager);
            }
            for (IceSocketManager iceSocketManager : list) {
                this.tryStartSocketManager(iceSocketManager);
            }
            return true;
        }
        catch (Exception exception) {
            for (ManagedSocket socket2 : sockets) {
                socket2.close();
            }
            this.setError(new Error(ErrorCode.IceStartError, exception));
            this.setState(IceGatheringState.Failed);
            return false;
        }
    }

    private void processAllocationMismatchException(IceSocketManager socketManager) {
        this.doProcessAllocationMismatchException(socketManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalCandidate(IceCandidate localCandidate) {
        IAction2<IceGatherer, IceCandidate> onLocalCandidate;
        if (!Global.equals((Object)localCandidate.getType(), (Object)CandidateType.PeerReflexive)) {
            int unset = IceCandidate.getUnset();
            Object object = this.__localPreferencesLock;
            synchronized (object) {
                unset = this.assignLocalPreference(localCandidate.getAdapterSpeed());
            }
            long num2 = IceCandidate.calculatePriority(localCandidate.getType(), unset, this.getComponent(), localCandidate.getDiscoverProtocol());
            localCandidate.setPriority(num2);
        }
        if (this.getLocalParameters() != null) {
            localCandidate.setUsername(this.getLocalParameters().getUsernameFragment() == null ? "" : this.getLocalParameters().getUsernameFragment());
            localCandidate.setPassword(this.getLocalParameters().getPassword() == null ? "" : this.getLocalParameters().getPassword());
        }
        if ((onLocalCandidate = this._onLocalCandidate) != null) {
            onLocalCandidate.invoke(this, localCandidate);
        }
    }

    private void processReceivedData(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
        IAction3<DataBuffer, IceCandidate, TransportAddress> onIncomingApplicationData = this._onIncomingApplicationData;
        if (onIncomingApplicationData != null) {
            onIncomingApplicationData.invoke(data, localCandidate, remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSocketManagerStateChanged(IceSocketManager sm) {
        Error error;
        IceGatheringState state = sm == null ? IceGatheringState.Closed : sm.getState();
        Error error2 = error = sm == null ? null : sm.getError();
        if (this._verboseLogging) {
            String str = sm == null ? "Removed/Closed" : sm.getState().toString();
            Log.debug(StringExtensions.format("Socket manager state change to: {0}", str));
        }
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Closed) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Failed)) {
                if (this._verboseLogging) {
                    Log.debug("Gatherer already in the CLOSED or FAILED state. Ignoring.");
                }
            } else {
                IceGatheringState _var0 = state;
                if (_var0 == IceGatheringState.Complete) {
                    if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) && this.getAllSocketManagersCompleteFailedOrClosedAndAtLeastOneCompleted() && this.__resolvesRemaining == 0) {
                        this.setState(IceGatheringState.Complete);
                    }
                } else if (_var0 == IceGatheringState.Closed) {
                    if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Closing)) {
                        if (this.verifyAllSocketsManagersClosedOrFailed()) {
                            this.finaliseClosing();
                        }
                    } else if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) && this.getAllSocketManagersCompleteFailedOrClosedAndAtLeastOneCompleted() && this.__resolvesRemaining == 0) {
                        this.setState(IceGatheringState.Complete);
                    }
                } else if (_var0 == IceGatheringState.Failed) {
                    if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) && this.getAllSocketManagersCompleteFailedOrClosedAndAtLeastOneCompleted() && this.__resolvesRemaining == 0) {
                        this.setState(IceGatheringState.Complete);
                    } else if (this.verifyAllSocketsManagersClosedOrFailed()) {
                        this.setError(error);
                        this.setState(IceGatheringState.Failed);
                    }
                }
            }
        }
    }

    private void processStunRequest(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
        IAction3<Message, IceCandidate, TransportAddress> onStunRequest = this.getOnStunRequest();
        if (onStunRequest != null) {
            onStunRequest.invoke(message, localCandidate, remoteAddress);
        }
    }

    IceCandidate registerLocalPeerReflexiveCandidate(IceCandidate candidate) {
        if (!Global.equals((Object)candidate.getType(), (Object)CandidateType.PeerReflexive)) {
            throw new RuntimeException(new Exception("Gatherer can only register peer reflexive candidates."));
        }
        IceSocketManager manager = this.getManager(candidate);
        if (manager != null) {
            candidate = manager.registerLocalPeerReflexiveCandidate(candidate);
        }
        return candidate;
    }

    public void removeOnIncomingApplicationData(IAction3<DataBuffer, IceCandidate, TransportAddress> value) {
        IAction3 match;
        if (value instanceof IActionDelegate3 && (match = Global.findIActionDelegate3WithId(this.__onIncomingApplicationData, ((IActionDelegate3)value).getId())) != null) {
            value = match;
        }
        this.__onIncomingApplicationData.remove(value);
        if (this.__onIncomingApplicationData.size() == 0) {
            this._onIncomingApplicationData = null;
        }
    }

    public void removeOnLocalCandidate(IAction2<IceGatherer, IceCandidate> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onLocalCandidate, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onLocalCandidate.remove(value);
        if (this.__onLocalCandidate.size() == 0) {
            this._onLocalCandidate = null;
        }
    }

    public void removeOnStateChange(IAction1<IceGatherer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRtcpGatherer() {
        Object object = this.__lock;
        synchronized (object) {
            this.__relatedRtcpGatherer = null;
            if (this.__rtcpDatagramSockets != null) {
                this.__rtcpDatagramSockets = null;
            }
            if (this.__rtcpStreamSocketsAndServers != null) {
                this.__rtcpStreamSocketsAndServers.clear();
                this.__rtcpStreamSocketsAndServers = null;
            }
        }
    }

    private void resolveServerAddresses() {
        if (ArrayExtensions.getLength(this.__options.getServers()) == 0) {
            this.setState(IceGatheringState.Complete);
        } else {
            for (IceServer server : this.__options.getServers()) {
                Dns.resolve(server.getHost(), (IAction2<String[], Object>)new IActionDelegate2<String[], Object>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceGatherer.dnsResolveCallback";
                    }

                    @Override
                    public void invoke(String[] serverIPAddress, Object stateObj) {
                        IceGatherer.this.dnsResolveCallback(serverIPAddress, stateObj);
                    }
                }, server);
            }
        }
    }

    public void setClosingShouldNotTriggerGlobalNonGracefulShutdown(boolean value) {
        this._closingShouldNotTriggerGlobalNonGracefulShutdown = value;
    }

    public void setCreateDatagramSocket(IFunction1<DatagramSocketCreateArgs, DatagramSocket> value) {
        this._createDatagramSocket = value;
    }

    public void setCreateStreamSocket(IFunction1<StreamSocketCreateArgs, StreamSocket> value) {
        this._createStreamSocket = value;
    }

    public void setError(Error value) {
        this._error = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalParameters(IceParameters value) {
        Object object = this.__lock;
        synchronized (object) {
            this.__localIceParameters = value;
        }
    }

    void setOnStunRequest(IAction3<Message, IceCandidate, TransportAddress> value) {
        this._onStunRequest = value;
    }

    private void setState(IceGatheringState value) {
        if (!Global.equals((Object)this.__state, (Object)value)) {
            IAction1<IceGatherer> onStateChange;
            this.__state = value;
            if (Global.equals((Object)value, (Object)IceGatheringState.Failed) || Global.equals((Object)value, (Object)IceGatheringState.Closed)) {
                this.removeRtcpGatherer();
                if (this.__sockets != null) {
                    int num = 0;
                    for (ManagedSocket socket : this.__sockets) {
                        if (socket.getIsClosed()) continue;
                        ++num;
                        socket.close();
                    }
                    if (num > 0) {
                        Log.debug(StringExtensions.format("Gatherer {0} cleaned up {1} orphaned sockets upon shutting down.", this.getId(), IntegerExtensions.toString(num)));
                    }
                }
                this.__sockets = null;
            }
            if ((onStateChange = this._onStateChange) != null) {
                onStateChange.invoke(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean start() {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)IceGatheringState.New)) {
                return false;
            }
            this.__transactionManager = new IceTransactionManager(this.__lock, this.__scheduler);
            this.__transactionManager.start();
            if (this.getOptions().getPrivateIPAddresses() == null || ArrayExtensions.getLength(this.getOptions().getPrivateIPAddresses()) == 0) {
                this.__localAddresses = LocalNetwork.getLocalAddresses(this.getOptions().getAddressTypes());
            } else {
                this.__localAddresses = new LocalAddress[ArrayExtensions.getLength(this.getOptions().getPrivateIPAddresses())];
                for (int i = 0; i < ArrayExtensions.getLength(this.getOptions().getPrivateIPAddresses()); ++i) {
                    this.__localAddresses[i] = new LocalAddress(this.getOptions().getPrivateIPAddresses()[i], null, 0L);
                }
            }
            ManagedSocket[] primarySockets = null;
            ManagedSocket[] complementarySockets = null;
            if (Global.equals((Object)this.getComponent(), (Object)IceComponent.Rtcp)) {
                primarySockets = this.__rtcpDatagramSockets;
            } else if (this.__localAddresses != null && ArrayExtensions.getLength(this.__localAddresses) > 0) {
                Holder<DatagramSocket[]> _var0 = new Holder<DatagramSocket[]>((DatagramSocket[])primarySockets);
                Holder<Object> _var1 = new Holder<Object>(complementarySockets);
                this.openSockets(ProtocolType.Udp, _var0, _var1);
                primarySockets = _var0.getValue();
                complementarySockets = _var1.getValue();
                ArrayListExtensions.addRange(this.__sockets, primarySockets);
                if (primarySockets == null) {
                    if (complementarySockets != null) {
                        for (ManagedSocket managedSocket : complementarySockets) {
                            managedSocket.close();
                        }
                    }
                    this.setError(this.getError() == null ? new Error(ErrorCode.SocketClosed, new Exception("Failed to open datagram sockets.")) : this.getError());
                    this.setState(IceGatheringState.Failed);
                    return false;
                }
                if (this.__relatedRtcpGatherer != null && complementarySockets != null) {
                    this.__relatedRtcpGatherer.assignDatagramSockets(complementarySockets);
                }
            } else {
                Object _var0 = this.__lock;
                synchronized (_var0) {
                    this.setError(new Error(ErrorCode.IceLocalAddressUnavailable, new Exception("Could not obtain local IP addresses.")));
                    this.setState(IceGatheringState.Failed);
                    return false;
                }
            }
            IceDatagramSocketManager socketManager = null;
            ArrayList<IceDatagramSocketManager> list = new ArrayList<IceDatagramSocketManager>();
            try {
                for (DatagramSocket datagramSocket : primarySockets) {
                    IceDatagramSocketManager iceDatagramSocketManager = new IceDatagramSocketManager(this.__lock, datagramSocket, this.__transactionManager);
                    iceDatagramSocketManager.setOnLocalCandidate((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceGatherer.processLocalCandidate";
                        }

                        @Override
                        public void invoke(IceCandidate localCandidate) {
                            IceGatherer.this.processLocalCandidate(localCandidate);
                        }
                    });
                    iceDatagramSocketManager.setOnStateChange((IAction1<IceSocketManager>)new IActionDelegate1<IceSocketManager>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceGatherer.processSocketManagerStateChanged";
                        }

                        @Override
                        public void invoke(IceSocketManager sm) {
                            IceGatherer.this.processSocketManagerStateChanged(sm);
                        }
                    });
                    iceDatagramSocketManager.setOnStunRequest((IAction3<Message, IceCandidate, TransportAddress>)new IActionDelegate3<Message, IceCandidate, TransportAddress>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceGatherer.processStunRequest";
                        }

                        @Override
                        public void invoke(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
                            IceGatherer.this.processStunRequest(message, localCandidate, remoteAddress);
                        }
                    });
                    iceDatagramSocketManager.setOnIncomingData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceGatherer.processReceivedData";
                        }

                        @Override
                        public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                            IceGatherer.this.processReceivedData(data, localCandidate, remoteAddress);
                        }
                    });
                    iceDatagramSocketManager.setOnAllocationMismatchException((IAction1<IceSocketManager>)new IActionDelegate1<IceSocketManager>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceGatherer.processAllocationMismatchException";
                        }

                        @Override
                        public void invoke(IceSocketManager socketManager) {
                            IceGatherer.this.processAllocationMismatchException(socketManager);
                        }
                    });
                    socketManager = iceDatagramSocketManager;
                    this.addNewSocketManager(socketManager);
                    list.add(socketManager);
                }
                for (IceSocketManager iceSocketManager : list) {
                    this.tryStartSocketManager(iceSocketManager);
                }
            }
            catch (Exception exception) {
                int n;
                if (primarySockets != null) {
                    void var9_26;
                    DatagramSocket[] datagramSocketArray = primarySockets;
                    n = datagramSocketArray.length;
                    boolean bl = false;
                    while (var9_26 < n) {
                        DatagramSocket datagramSocket = datagramSocketArray[var9_26];
                        datagramSocket.close();
                        ++var9_26;
                    }
                }
                if (complementarySockets != null) {
                    void var9_28;
                    ManagedSocket[] managedSocketArray = complementarySockets;
                    n = managedSocketArray.length;
                    boolean bl = false;
                    while (var9_28 < n) {
                        void var10_35 = managedSocketArray[var9_28];
                        var10_35.close();
                        ++var9_28;
                    }
                }
                this.setError(new Error(ErrorCode.IceStartError, exception));
                this.setState(IceGatheringState.Failed);
                return false;
            }
            this.setState(IceGatheringState.Gathering);
            if (Global.equals((Object)this.getComponent(), (Object)IceComponent.Rtcp)) {
                ManagedSocket[] sockets = null;
                Object var7_16 = null;
                for (IceSocketsServerPair iceSocketsServerPair : this.__rtcpStreamSocketsAndServers) {
                    IceServer iceServer;
                    sockets = iceSocketsServerPair.getSockets();
                    if (this.prepareStreamSocketManagers(sockets, iceServer = iceSocketsServerPair.getServer(), iceServer.getIPAddress())) continue;
                    return false;
                }
                this.__rtcpStreamSocketsAndServers.clear();
            }
            this.resolveServerAddresses();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)IceGatheringState.New) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Complete) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Failed)) {
                this.removeRtcpGatherer();
                this.setState(IceGatheringState.Closing);
                int num = 0;
                if (this.__socketManagers == null || HashMapExtensions.getCount(this.__socketManagers) == 0) {
                    this.setState(IceGatheringState.Closed);
                } else {
                    IceSocketManager[] managerArray = new IceSocketManager[HashMapExtensions.getCount(this.__socketManagers)];
                    for (String str : HashMapExtensions.getKeys(this.__socketManagers)) {
                        managerArray[num++] = HashMapExtensions.getItem(this.__socketManagers).get(str);
                    }
                    boolean flag = true;
                    for (IceSocketManager manager : managerArray) {
                        if (manager == null) continue;
                        flag &= !manager.stop();
                    }
                    if (flag) {
                        this.setState(IceGatheringState.Closed);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStartSocketManager(IceSocketManager socketManager) {
        if (!socketManager.start(this.__options)) {
            Object object = this.__lock;
            synchronized (object) {
                String key = this.prepareSocketManagerKey(socketManager.getProtocol(), socketManager.getLocalIpAddress(), socketManager.getLocalPort());
                HashMapExtensions.remove(this.__socketManagers, key);
                socketManager.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyAllSocketsManagersClosedOrFailed() {
        Object object = this.__lock;
        synchronized (object) {
            boolean flag = true;
            for (IceSocketManager manager : HashMapExtensions.getValues(this.__socketManagers)) {
                if (Global.equals((Object)manager.getState(), (Object)IceGatheringState.Closed) || Global.equals((Object)manager.getState(), (Object)IceGatheringState.Failed)) continue;
                flag = false;
            }
            return flag;
        }
    }
}

