/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Architecture;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IAction4;
import fm.icelink.IAction5;
import fm.icelink.IAction6;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IActionDelegate3;
import fm.icelink.IActionDelegate4;
import fm.icelink.IActionDelegate5;
import fm.icelink.IActionDelegate6;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.IFunction2;
import fm.icelink.IFunction3;
import fm.icelink.IFunction4;
import fm.icelink.IFunction5;
import fm.icelink.IFunction6;
import fm.icelink.IFunctionDelegate0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.IFunctionDelegate3;
import fm.icelink.IFunctionDelegate4;
import fm.icelink.IFunctionDelegate5;
import fm.icelink.IFunctionDelegate6;
import fm.icelink.IPlatform;
import fm.icelink.Log;
import fm.icelink.OperatingSystem;
import fm.icelink.Platform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Global {
    public static <T> T tryCast(Object object, Class<T> toClass) {
        try {
            return toClass.cast(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        return object1.equals(object2);
    }

    public static IAction0 findIActionDelegate0WithId(List<IAction0> actions, String id) {
        for (IAction0 action : new ArrayList<IAction0>(actions)) {
            if (id == null || !(action instanceof IActionDelegate0) || !id.equals(((IActionDelegate0)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <T> IAction1<T> findIActionDelegate1WithId(List<IAction1<T>> actions, String id) {
        for (IAction1<T> action : new ArrayList<IAction1<T>>(actions)) {
            if (id == null || !(action instanceof IActionDelegate1) || !id.equals(((IActionDelegate1)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <T1, T2> IAction2<T1, T2> findIActionDelegate2WithId(List<IAction2<T1, T2>> actions, String id) {
        for (IAction2<T1, T2> action : new ArrayList<IAction2<T1, T2>>(actions)) {
            if (id == null || !(action instanceof IActionDelegate2) || !id.equals(((IActionDelegate2)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <T1, T2, T3> IAction3<T1, T2, T3> findIActionDelegate3WithId(List<IAction3<T1, T2, T3>> actions, String id) {
        for (IAction3<T1, T2, T3> action : new ArrayList<IAction3<T1, T2, T3>>(actions)) {
            if (id == null || !(action instanceof IActionDelegate3) || !id.equals(((IActionDelegate3)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <T1, T2, T3, T4> IAction4<T1, T2, T3, T4> findIActionDelegate4WithId(List<IAction4<T1, T2, T3, T4>> actions, String id) {
        for (IAction4<T1, T2, T3, T4> action : new ArrayList<IAction4<T1, T2, T3, T4>>(actions)) {
            if (id == null || !(action instanceof IActionDelegate4) || !id.equals(((IActionDelegate4)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <T1, T2, T3, T4, T5> IAction5<T1, T2, T3, T4, T5> findIActionDelegate5WithId(List<IAction5<T1, T2, T3, T4, T5>> actions, String id) {
        for (IAction5<T1, T2, T3, T4, T5> action : new ArrayList<IAction5<T1, T2, T3, T4, T5>>(actions)) {
            if (id == null || !(action instanceof IActionDelegate5) || !id.equals(((IActionDelegate5)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <T1, T2, T3, T4, T5, T6> IAction6<T1, T2, T3, T4, T5, T6> findIActionDelegate6WithId(List<IAction6<T1, T2, T3, T4, T5, T6>> actions, String id) {
        for (IAction6<T1, T2, T3, T4, T5, T6> action : new ArrayList<IAction6<T1, T2, T3, T4, T5, T6>>(actions)) {
            if (id == null || !(action instanceof IActionDelegate6) || !id.equals(((IActionDelegate6)action).getId())) continue;
            return action;
        }
        return null;
    }

    public static <R> IFunction0<R> findIFunctionDelegate0WithId(List<IFunction0<R>> functions, String id) {
        for (IFunction0<R> function : new ArrayList<IFunction0<R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate0) || !id.equals(((IFunctionDelegate0)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T, R> IFunction1<T, R> findIFunctionDelegate1WithId(List<IFunction1<T, R>> functions, String id) {
        for (IFunction1<T, R> function : new ArrayList<IFunction1<T, R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate1) || !id.equals(((IFunctionDelegate1)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T1, T2, R> IFunction2<T1, T2, R> findIFunctionDelegate2WithId(List<IFunction2<T1, T2, R>> functions, String id) {
        for (IFunction2<T1, T2, R> function : new ArrayList<IFunction2<T1, T2, R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate2) || !id.equals(((IFunctionDelegate2)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T1, T2, T3, R> IFunction3<T1, T2, T3, R> findIFunctionDelegate3WithId(List<IFunction3<T1, T2, T3, R>> functions, String id) {
        for (IFunction3<T1, T2, T3, R> function : new ArrayList<IFunction3<T1, T2, T3, R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate3) || !id.equals(((IFunctionDelegate3)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T1, T2, T3, T4, R> IFunction4<T1, T2, T3, T4, R> findIFunctionDelegate4WithId(List<IFunction4<T1, T2, T3, T4, R>> functions, String id) {
        for (IFunction4<T1, T2, T3, T4, R> function : new ArrayList<IFunction4<T1, T2, T3, T4, R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate4) || !id.equals(((IFunctionDelegate4)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T1, T2, T3, T4, T5, R> IFunction5<T1, T2, T3, T4, T5, R> findIFunctionDelegate5WithId(List<IFunction5<T1, T2, T3, T4, T5, R>> functions, String id) {
        for (IFunction5<T1, T2, T3, T4, T5, R> function : new ArrayList<IFunction5<T1, T2, T3, T4, T5, R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate5) || !id.equals(((IFunctionDelegate5)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T1, T2, T3, T4, T5, T6, R> IFunction6<T1, T2, T3, T4, T5, T6, R> findIFunctionDelegate6WithId(List<IFunction6<T1, T2, T3, T4, T5, T6, R>> functions, String id) {
        for (IFunction6<T1, T2, T3, T4, T5, T6, R> function : new ArrayList<IFunction6<T1, T2, T3, T4, T5, T6, R>>(functions)) {
            if (id == null || !(function instanceof IFunctionDelegate6) || !id.equals(((IFunctionDelegate6)function).getId())) continue;
            return function;
        }
        return null;
    }

    public static <T> byte decrement(T target, byte value, IAction2<T, Byte> set, boolean prefix) {
        byte newValue = (byte)(value - 1);
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> byte increment(T target, byte value, IAction2<T, Byte> set, boolean prefix) {
        byte newValue = (byte)(value + 1);
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> short decrement(T target, short value, IAction2<T, Short> set, boolean prefix) {
        short newValue = (short)(value - 1);
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> short increment(T target, short value, IAction2<T, Short> set, boolean prefix) {
        short newValue = (short)(value + 1);
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> int decrement(T target, int value, IAction2<T, Integer> set, boolean prefix) {
        int newValue = value - 1;
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> int increment(T target, int value, IAction2<T, Integer> set, boolean prefix) {
        int newValue = value + 1;
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> long decrement(T target, long value, IAction2<T, Long> set, boolean prefix) {
        long newValue = value - 1L;
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static <T> long increment(T target, long value, IAction2<T, Long> set, boolean prefix) {
        long newValue = value + 1L;
        set.invoke(target, newValue);
        if (prefix) {
            return newValue;
        }
        return value;
    }

    public static boolean loadLibrary(String library) {
        File libFile;
        if (Platform.getInstance().getOperatingSystem() == OperatingSystem.Android) {
            try {
                System.loadLibrary(library);
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                Log.debug("Unable to load " + library);
                return false;
            }
        }
        String libName = System.mapLibraryName(library);
        String tempLibName = "lib" + libName;
        String tempPath = System.getProperty("java.io.tmpdir");
        File tempPathDir = new File(tempPath);
        if (!tempPathDir.exists()) {
            tempPathDir.mkdirs();
        }
        if ((libFile = new File(tempPathDir, tempLibName)).exists()) {
            libFile.delete();
        }
        String path = Global.getLibraryPath();
        if (!libFile.exists()) {
            try {
                int len;
                InputStream in = Global.class.getResourceAsStream(path + "/" + libName);
                if (in == null && (in = Global.class.getResourceAsStream(path + "/lib" + libName)) == null) {
                    Log.debug("Unable to load " + library);
                    return false;
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(libFile));
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            System.load(libFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError error) {
            Log.error("Error loading library " + library + " from " + libFile.getAbsolutePath() + ".  Error message: " + error.getMessage());
            error.printStackTrace();
            return false;
        }
        return true;
    }

    private static String getLibraryPath() {
        IPlatform platform = Platform.getInstance();
        OperatingSystem os = platform.getOperatingSystem();
        Architecture arch = platform.getArchitecture();
        if (os == OperatingSystem.MacOS) {
            return "/libs/mac_x64";
        }
        if (os == OperatingSystem.Windows) {
            if (arch == Architecture.X86) {
                return "/libs/win_x86";
            }
            if (arch == Architecture.X64) {
                return "/libs/win_x64";
            }
            throw new RuntimeException("Unsupported arch.");
        }
        if (os == OperatingSystem.Linux) {
            if (arch == Architecture.X86) {
                return "/libs/linux_x86";
            }
            if (arch == Architecture.X64) {
                return "/libs/linux_x64";
            }
            if (arch == Architecture.Armv7) {
                return "/libs/linux_armv7";
            }
            if (arch == Architecture.Armv8) {
                return ".libs/linux_armv8";
            }
            if (arch == Architecture.Arm64) {
                return "/libs/linux_arm64";
            }
            throw new RuntimeException("Unknown or unsupported arch.");
        }
        throw new RuntimeException("Unknown or unsupported os.");
    }
}

