/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;

public class FirEntry {
    private DataBuffer _dataBuffer;
    private int _lastSequenceNumber;

    public FirEntry(DataBuffer dataBuffer) {
        this.setLastSequenceNumber(-1);
        if (dataBuffer == null) {
            throw new RuntimeException(new Exception("DataBuffer cannot be null."));
        }
        if (dataBuffer.getLength() < FirEntry.getFixedPayloadLength()) {
            throw new RuntimeException(new Exception(StringExtensions.concat("FirEntry DataBuffer must be at least ", IntegerExtensions.toString(FirEntry.getFixedPayloadLength()), " bytes.")));
        }
        this.setDataBuffer(dataBuffer);
    }

    public FirEntry(int sequenceNumber) {
        this(sequenceNumber, 0L);
    }

    public FirEntry(int sequenceNumber, long synchronizationSource) {
        this(DataBuffer.allocate(FirEntry.getFixedPayloadLength()));
        this.setSequenceNumber(sequenceNumber);
        this.setSynchronizationSource(synchronizationSource);
    }

    public DataBuffer getDataBuffer() {
        return this._dataBuffer;
    }

    public static int getFixedPayloadLength() {
        return 8;
    }

    int getLastSequenceNumber() {
        return this._lastSequenceNumber;
    }

    public int getSequenceNumber() {
        return this.getDataBuffer().read8(4);
    }

    public long getSynchronizationSource() {
        return this.getDataBuffer().read32(0);
    }

    public void setDataBuffer(DataBuffer value) {
        this._dataBuffer = value;
    }

    void setLastSequenceNumber(int value) {
        this._lastSequenceNumber = value;
    }

    public void setSequenceNumber(int value) {
        this.getDataBuffer().write8(value % 256, 4);
    }

    public void setSynchronizationSource(long value) {
        this.getDataBuffer().write32(value, 0);
    }
}

