/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.IntegerHolder;

class FecRedPacket {
    private DataBuffer _data;
    private int _headerLength;
    private int _length;

    public void assignPayload(DataBuffer payload, int offset, int length) {
        if (this._headerLength + length > this.getLength()) {
            throw new RuntimeException(new Exception("Payload length exceeds allowed length."));
        }
        this.getData().write(payload.subset(offset, length), this._headerLength);
    }

    public void clearMarkerBit() {
        this.getData().write1(false, 1, 0);
    }

    public void createHeader(DataBuffer rtpHeader, int headerLength, int redPayloadType, int payloadType) {
        if (headerLength + FecRedPacket.getRedForFecHeaderLength() > this.getLength()) {
            throw new RuntimeException(new Exception("Header length exceeds available length."));
        }
        this.getData().write(rtpHeader.subset(0, headerLength), 0);
        this.getData().write8((byte)((this.getData().read8(1) & 0x80) + redPayloadType), 1);
        this.getData().write8(payloadType, headerLength);
        this._headerLength = headerLength + FecRedPacket.getRedForFecHeaderLength();
    }

    public FecRedPacket(int length) {
        this.setData(DataBufferPool.getInstance().take(length));
        this.setLength(length);
        this._headerLength = 0;
    }

    public DataBuffer getData() {
        return this._data;
    }

    public static int getHighProtectionThreshold() {
        return 80;
    }

    public int getLength() {
        return this._length;
    }

    public static int getMaxExcessOverhead() {
        return 50;
    }

    public static int getMinimumMediaPackets() {
        return 4;
    }

    public static void getPayloadTypes(DataBuffer rtpPayload, IntegerHolder payloadType1, IntegerHolder payloadType1Offset, IntegerHolder payloadType2, IntegerHolder payloadType2Offset) {
        payloadType1.setValue(-1);
        payloadType2.setValue(-1);
        payloadType1Offset.setValue(-1);
        payloadType2Offset.setValue(-1);
        if (rtpPayload.getLength() > 0) {
            payloadType1Offset.setValue(0);
            payloadType1.setValue(rtpPayload.read8(payloadType1Offset.getValue()) & 0x7F);
            int num = 0;
            if ((rtpPayload.read8(payloadType1Offset.getValue()) & 0x80) > 0 && rtpPayload.getLength() > 15) {
                num = ((3 & rtpPayload.read8(14)) << 8) + rtpPayload.read8(15);
                payloadType2Offset.setValue(18 + num);
                if (num > 0 && rtpPayload.getLength() > payloadType2Offset.getValue()) {
                    payloadType2.setValue(rtpPayload.read8(payloadType2Offset.getValue()) & 0x7F);
                }
            }
        }
    }

    public static int getRedForFecHeaderLength() {
        return 1;
    }

    public static void replacePayloadTypes(DataBuffer rtpPayload, int sourceMediaPayloadType, int targetMediaPayloadType, int sourceFecPayloadType, int targetFecPayloadType) {
        int num = 0;
        int num2 = 0;
        int num3 = 0;
        int num4 = 0;
        IntegerHolder _var0 = new IntegerHolder(num);
        IntegerHolder _var1 = new IntegerHolder(num3);
        IntegerHolder _var2 = new IntegerHolder(num2);
        IntegerHolder _var3 = new IntegerHolder(num4);
        FecRedPacket.getPayloadTypes(rtpPayload, _var0, _var1, _var2, _var3);
        num = _var0.getValue();
        num3 = _var1.getValue();
        num2 = _var2.getValue();
        num4 = _var3.getValue();
        if (num > -1) {
            rtpPayload.and(128, num3);
            if (num == sourceMediaPayloadType) {
                rtpPayload.or(targetMediaPayloadType, num3);
            } else if (num == sourceFecPayloadType) {
                rtpPayload.or(targetFecPayloadType, num3);
            }
        }
        if (num2 > -1) {
            rtpPayload.and(128, num4);
            if (num2 == sourceMediaPayloadType) {
                rtpPayload.or(targetMediaPayloadType, num4);
            } else if (num2 == sourceFecPayloadType) {
                rtpPayload.or(targetFecPayloadType, num4);
            }
        }
    }

    private void setData(DataBuffer value) {
        this._data = value;
    }

    private void setLength(int value) {
        this._length = value;
    }

    public void setSequenceNumber(int sequenceNumber) {
        if (sequenceNumber < 0 || sequenceNumber >= 65536) {
            throw new RuntimeException(new Exception("Sequence number out of range."));
        }
        this.getData().write16(sequenceNumber, 2);
    }
}

