/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;

public class DataBufferStream {
    private byte __bitPosition;
    private DataBuffer __buffer;
    private int __position;

    public DataBufferStream(int dataBufferSize) {
        this(dataBufferSize, false);
    }

    public DataBufferStream(int dataBufferSize, boolean littleEndian) {
        this(DataBuffer.allocate(dataBufferSize, littleEndian));
    }

    public DataBufferStream(DataBuffer buffer) {
        this.__buffer = buffer;
    }

    public int getAvailable() {
        return this.getLength() - this.__position;
    }

    public byte getBitPosition() {
        return this.__bitPosition;
    }

    public DataBuffer getBuffer() {
        return this.__buffer;
    }

    public int getLength() {
        return this.__buffer.getLength();
    }

    public int getPosition() {
        return this.__position;
    }

    public void nextByte() {
        this.__bitPosition = 0;
        ++this.__position;
    }

    public int peek() {
        return this.__buffer.read8(this.getPosition());
    }

    public DataBuffer read(int length) {
        DataBuffer buffer = this.__buffer.subset(this.__position, length);
        this.__position += length;
        return buffer;
    }

    public boolean read1() {
        boolean flag = this.__buffer.read1(this.__position, this.__bitPosition);
        this.__bitPosition = (byte)(this.__bitPosition + 1);
        if (this.__bitPosition == 8) {
            ++this.__position;
            this.__bitPosition = 0;
        }
        return flag;
    }

    public int read15() {
        int num = this.__buffer.read15(this.__position, this.__bitPosition);
        ++this.__position;
        this.__bitPosition = (byte)(this.__bitPosition + 7);
        if (this.__bitPosition >= 8) {
            ++this.__position;
            this.__bitPosition = (byte)(this.__bitPosition - 8);
        }
        return num;
    }

    public int read16() {
        int num = this.__buffer.read16(this.__position);
        this.__position += 2;
        return num;
    }

    public int read2() {
        int num = this.__buffer.read2(this.__position, this.__bitPosition);
        this.__bitPosition = (byte)(this.__bitPosition + 2);
        if (this.__bitPosition >= 8) {
            ++this.__position;
            this.__bitPosition = (byte)(this.__bitPosition - 8);
        }
        return num;
    }

    public int read24() {
        int num = this.__buffer.read24(this.__position);
        this.__position += 3;
        return num;
    }

    public int read3() {
        int num = this.__buffer.read3(this.__position, this.__bitPosition);
        this.__bitPosition = (byte)(this.__bitPosition + 3);
        if (this.__bitPosition >= 8) {
            ++this.__position;
            this.__bitPosition = (byte)(this.__bitPosition - 8);
        }
        return num;
    }

    public long read32() {
        long num = this.__buffer.read32(this.__position);
        this.__position += 4;
        return num;
    }

    public int read4() {
        int num = this.__buffer.read4(this.__position, this.__bitPosition);
        this.__bitPosition = (byte)(this.__bitPosition + 4);
        if (this.__bitPosition >= 8) {
            ++this.__position;
            this.__bitPosition = (byte)(this.__bitPosition - 8);
        }
        return num;
    }

    public long read40() {
        long num = this.__buffer.read40(this.__position);
        this.__position += 5;
        return num;
    }

    public long read48() {
        long num = this.__buffer.read48(this.__position);
        this.__position += 6;
        return num;
    }

    public long read56() {
        long num = this.__buffer.read56(this.__position);
        this.__position += 7;
        return num;
    }

    public long read64() {
        long num = this.__buffer.read64(this.__position);
        this.__position += 8;
        return num;
    }

    public int read7() {
        int num = this.__buffer.read7(this.__position, this.__bitPosition);
        this.__bitPosition = (byte)(this.__bitPosition + 7);
        if (this.__bitPosition >= 8) {
            ++this.__position;
            this.__bitPosition = (byte)(this.__bitPosition - 8);
        }
        return num;
    }

    public int read8() {
        int num = this.__buffer.read8(this.__position);
        ++this.__position;
        return num;
    }

    public int readByte() {
        return this.read8();
    }

    public byte[] readBytes(int length) {
        byte[] buffer = this.__buffer.subset(this.__position, length).toArray();
        this.__position += length;
        return buffer;
    }

    public void setBitPosition(byte value) {
        this.__bitPosition = value;
    }

    public void setPosition(int value) {
        this.__position = value;
    }

    public DataBufferStream write(DataBuffer buffer) {
        this.__buffer.write(buffer, this.__position);
        this.__position += buffer.getLength();
        return this;
    }

    public DataBufferStream write16(int value) {
        this.__buffer.write16(value, this.__position);
        this.__position += 2;
        return this;
    }

    public DataBufferStream write32(long value) {
        this.__buffer.write32(value, this.__position);
        this.__position += 4;
        return this;
    }

    public DataBufferStream write64(long value) {
        this.__buffer.write64(value, this.__position);
        this.__position += 8;
        return this;
    }

    public DataBufferStream write8(int value) {
        this.__buffer.write8(value, this.__position);
        ++this.__position;
        return this;
    }

    public DataBufferStream writeBytes(byte[] data) {
        return this.writeBytes(data, 0, ArrayExtensions.getLength(data));
    }

    public DataBufferStream writeBytes(byte[] data, int index, int length) {
        if (this.getAvailable() < length) {
            this.getBuffer().resize(this.getBuffer().getLength() + length);
        }
        this.__buffer.writeBytes(data, index, length, this.__position);
        this.__position += length;
        return this;
    }
}

