/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.Promise;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoSource;
import fm.icelink.android.ImageUtility;
import fm.icelink.android.Utility;

public class ViewSource
extends VideoSource {
    private View _view;
    private int _frameRate;
    private volatile boolean isCapturing = false;
    private volatile boolean isStopped = true;
    private Bitmap image;
    private Canvas canvas;

    public View getView() {
        return this._view;
    }

    public void setView(View view) {
        this._view = view;
    }

    public String getLabel() {
        return "Android View Source";
    }

    public ViewSource(View view, int frameRate) {
        super(VideoFormat.getArgb());
        this._view = view;
        this._frameRate = frameRate;
    }

    protected Future<Object> doStart() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    ViewSource.this.isCapturing = true;
                    ViewSource.this.isStopped = false;
                    ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

                        public void invoke(ManagedThread thread) {
                            ViewSource.this.captureLoop(thread);
                        }
                    });
                    thread.start();
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    protected Future<Object> doStop() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    ViewSource.this.isCapturing = false;
                    while (!ViewSource.this.isStopped) {
                        ManagedThread.sleep((int)10);
                    }
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    private void captureLoop(ManagedThread thread) {
        while (this.isCapturing) {
            final View view = this._view;
            int width = view.getMeasuredWidth();
            int height = view.getMeasuredHeight();
            long start = System.nanoTime();
            if (width > 0 && height > 0) {
                try {
                    Utility.dispatchToMainThread(new IAction0(){

                        public void invoke() {
                            view.setDrawingCacheEnabled(true);
                            view.buildDrawingCache();
                        }
                    }, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                while (width % 2 != 0) {
                    --width;
                }
                while (height % 2 != 0) {
                    --height;
                }
                try {
                    if (this.image == null || this.image.getWidth() != width || this.image.getHeight() != height) {
                        this.image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        this.canvas = new Canvas(this.image);
                    }
                    view.draw(this.canvas);
                    VideoBuffer buffer = ImageUtility.bitmapToBuffer(this.image);
                    this.raiseFrame(new VideoFrame(buffer));
                }
                catch (Exception ex) {
                    Log.error((String)"Could not raise screen image.", (Exception)ex);
                }
            }
            long finish = System.nanoTime();
            ManagedThread.sleep((int)MathAssistant.max((int)0, (int)((int)(1000.0 / (double)this._frameRate - (double)((finish - start) / 1000000L)))));
        }
    }
}

