/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Crypto;
import fm.Holder;
import fm.Serializer;
import fm.SingleAction;
import fm.StringExtensions;
import fm.websync.BaseInputArgs;
import fm.websync.Extensible;
import fm.websync.ServiceCompleteArgs;
import fm.websync.ServiceFailureArgs;
import fm.websync.ServiceSuccessArgs;

public class ServiceArgs
extends BaseInputArgs {
    String __channel;
    byte[] __dataBytes;
    String __dataJson;
    private SingleAction<ServiceCompleteArgs> _onComplete;
    private SingleAction<ServiceFailureArgs> _onFailure;
    private SingleAction<ServiceSuccessArgs> _onSuccess;

    public String getChannel() {
        return this.__channel;
    }

    public byte[] getDataBytes() throws Exception {
        byte[] decoded = this.__dataBytes;
        String valueJson = this.__dataJson;
        if (decoded != null) {
            return decoded;
        }
        if (valueJson != null) {
            Holder _var0 = new Holder((Object)decoded);
            boolean _var1 = Crypto.tryBase64Decode((String)Serializer.deserializeString((String)valueJson), (Holder)_var0);
            decoded = (byte[])_var0.getValue();
            if (!_var1) {
                decoded = null;
            }
            this.__dataBytes = decoded;
            return decoded;
        }
        return null;
    }

    public String getDataJson() {
        String str = this.__dataJson;
        byte[] b = this.__dataBytes;
        if (str != null) {
            return str;
        }
        if (b != null) {
            this.__dataJson = str = Serializer.serializeString((String)Crypto.base64Encode((byte[])b));
            return str;
        }
        return null;
    }

    public boolean getIsBinary() throws Exception {
        return this.getDataBytes() != null;
    }

    public SingleAction<ServiceCompleteArgs> getOnComplete() {
        return this._onComplete;
    }

    public SingleAction<ServiceFailureArgs> getOnFailure() {
        return this._onFailure;
    }

    public SingleAction<ServiceSuccessArgs> getOnSuccess() {
        return this._onSuccess;
    }

    public String getTag() throws Exception {
        return Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag"));
    }

    public ServiceArgs(String channel, byte[] dataBytes, String tag) throws Exception {
        this.setChannel(channel);
        this.setDataBytes(dataBytes);
        this.setTag(tag);
    }

    public ServiceArgs(String channel, String dataJson) throws Exception {
        this(channel, dataJson, null);
    }

    public ServiceArgs(String channel, byte[] dataBytes) throws Exception {
        this(channel, dataBytes, null);
    }

    public ServiceArgs(String channel, String dataJson, String tag) throws Exception {
        this.setChannel(channel);
        this.setDataJson(dataJson);
        this.setTag(tag);
    }

    public void setChannel(String value) throws Exception {
        String error = null;
        Holder _var0 = new Holder(error);
        boolean _var1 = Extensible.validateChannel(value, (Holder<String>)_var0);
        error = (String)_var0.getValue();
        if (!_var1) {
            throw new Exception(StringExtensions.format((String)"Invalid channel. {0}", (Object)error));
        }
        this.__channel = value;
    }

    public void setDataBytes(byte[] value) {
        this.__dataJson = null;
        this.__dataBytes = value;
    }

    public void setDataJson(String value) throws Exception {
        if (value != null && !Serializer.isValidJson((String)value)) {
            throw new Exception("The value is not valid JSON.");
        }
        this.__dataJson = value;
        this.__dataBytes = null;
    }

    public void setOnComplete(SingleAction<ServiceCompleteArgs> value) {
        this._onComplete = value;
    }

    public void setOnFailure(SingleAction<ServiceFailureArgs> value) {
        this._onFailure = value;
    }

    public void setOnSuccess(SingleAction<ServiceSuccessArgs> value) {
        this._onSuccess = value;
    }

    public void setTag(String value) throws Exception {
        super.setExtensionValueJson("fm.tag", Serializer.serializeString((String)value), false);
    }
}

