/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.yuv;

import fm.icelink.Global;
import fm.icelink.IMediaOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.yuv.Native;

public class ImageConverter
extends VideoPipe {
    private int __filterMode = 0;
    private double __scale = 1.0;
    private Native __yuvFM;

    private VideoBuffer doConvertToI420(VideoBuffer buffer) {
        if (Global.equals((Object)((VideoFormat)buffer.getFormat()).getName(), (Object)VideoFormat.getI420Name())) {
            return buffer;
        }
        int orientation = buffer.getOrientation();
        buffer.setOrientation(0);
        VideoBuffer buffer2 = this.__yuvFM.convertToI420(buffer);
        buffer2.setOrientation(orientation);
        buffer.free();
        return buffer2;
    }

    private VideoBuffer doConvertToOutputFormat(VideoBuffer buffer) {
        if (Global.equals((Object)((VideoFormat)buffer.getFormat()).getName(), (Object)((VideoFormat)super.getOutputFormat()).getName())) {
            return buffer;
        }
        VideoBuffer buffer2 = this.__yuvFM.convertFromI420(buffer.toPlanar(), (VideoFormat)super.getOutputFormat());
        buffer2.setOrientation(buffer.getOrientation());
        buffer.free();
        return buffer2;
    }

    protected void doDestroy() {
        if (this.__yuvFM != null) {
            this.__yuvFM.destroy();
            this.__yuvFM = null;
        }
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        if (this.__yuvFM == null) {
            this.__yuvFM = new Native();
        }
        if (this.getScale() == 1.0 && inputBuffer.getOrientation() == 0 && ((VideoFormat)super.getInputFormat()).isEquivalent(super.getOutputFormat())) {
            this.raiseFrame((MediaFrame)frame);
        } else {
            VideoBuffer buffer = inputBuffer;
            buffer.keep();
            buffer = this.doConvertToI420(buffer);
            double scale = this.getScale();
            if (scale < 1.0) {
                buffer = this.doScale(buffer, scale);
            }
            buffer = this.doRotate(buffer);
            if (scale > 1.0) {
                buffer = this.doScale(buffer, scale);
            }
            if ((buffer = this.doConvertToOutputFormat(buffer)) != null) {
                frame.addBuffer((MediaBuffer)buffer);
                this.raiseFrame((MediaFrame)frame);
                buffer.free();
            }
        }
    }

    private VideoBuffer doRotate(VideoBuffer buffer) {
        if (buffer.getOrientation() == 0) {
            return buffer;
        }
        VideoBuffer buffer2 = this.__yuvFM.rotate(buffer);
        buffer.free();
        return buffer2;
    }

    private VideoBuffer doScale(VideoBuffer buffer, double scale) {
        if (scale == 1.0) {
            return buffer;
        }
        int toWidth = (int)((double)buffer.getWidth() * scale);
        int toHeight = (int)((double)buffer.getHeight() * scale);
        VideoBuffer buffer2 = this.__yuvFM.scale(buffer, toWidth, toHeight, this.getFilterMode());
        buffer2.setOrientation(buffer.getOrientation());
        buffer.free();
        return buffer2;
    }

    public int getFilterMode() {
        return this.__filterMode;
    }

    public String getLabel() {
        return "Image Converter";
    }

    public double getScale() {
        return this.__scale;
    }

    public ImageConverter(IVideoOutput input, VideoFormat outputFormat) {
        this((VideoFormat)input.getOutputFormat(), outputFormat);
        super.addInput((IMediaOutput)input);
    }

    public ImageConverter(VideoFormat outputFormat) {
        super(outputFormat);
    }

    public ImageConverter(IVideoOutput[] inputs, VideoFormat outputFormat) {
        this((VideoFormat)inputs[0].getOutputFormat(), outputFormat);
        super.addInputs((IMediaOutput[])inputs);
    }

    public ImageConverter(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
    }

    public void setFilterMode(int value) {
        this.__filterMode = value;
    }

    public void setScale(double value) {
        if (value <= 0.0) {
            throw new RuntimeException(new Exception("Scale must be greater than 0.0."));
        }
        this.__scale = value;
    }
}

