/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtp;

import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.MathAssistant;
import fm.icelink.ParseAssistant;
import fm.icelink.StreamDirection;
import fm.icelink.StreamDirectionHelper;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class ExtMapAttribute
extends Attribute {
    private StreamDirection __direction = StreamDirection.Unset;
    private String _extensionAttributes;
    private int _id;
    private String _uri;

    public ExtMapAttribute(int id, String uri) {
        this();
        this.setId(id);
        this.setUri(uri);
    }

    private ExtMapAttribute() {
        super.setAttributeType(AttributeType.RtpExtMapAttribute);
    }

    public ExtMapAttribute(int id, String uri, StreamDirection direction) {
        this(id, uri);
        this.setDirection(direction);
    }

    public static ExtMapAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ");
        int num2 = StringExtensions.indexOf(value, "/");
        boolean flag = num2 > -1 && index > num2;
        StreamDirection unset = StreamDirection.Unset;
        int id = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, num2 > -1 ? MathAssistant.min(index, num2) : index));
        if (flag) {
            unset = StreamDirectionHelper.directionFromString(StringExtensions.substring(value, num2 + 1, index - num2 - 1));
        }
        String str2 = value.substring(index + 1);
        int length = StringExtensions.indexOf(str2, " ");
        String uri = "";
        String str4 = "";
        if (length == -1) {
            uri = str2;
        } else {
            uri = StringExtensions.substring(str2, 0, length);
            str4 = str2.substring(length + 1);
        }
        ExtMapAttribute attribute = new ExtMapAttribute(id, uri);
        if (flag) {
            attribute.setDirection(unset);
        }
        if (!StringExtensions.isNullOrEmpty(str4)) {
            attribute.setExtensionAttributes(str4);
        }
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getId()));
        if (!Global.equals((Object)this.getDirection(), (Object)StreamDirection.Unset)) {
            String str = StreamDirectionHelper.directionToString(this.getDirection());
            StringBuilderExtensions.append(builder, "/");
            StringBuilderExtensions.append(builder, str);
        }
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getUri());
        if (!StringExtensions.isNullOrEmpty(this.getExtensionAttributes())) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, this.getExtensionAttributes());
        }
        return builder.toString();
    }

    public StreamDirection getDirection() {
        return this.__direction;
    }

    public String getExtensionAttributes() {
        return this._extensionAttributes;
    }

    public int getId() {
        return this._id;
    }

    public String getUri() {
        return this._uri;
    }

    public void setDirection(StreamDirection value) {
        this.__direction = value;
    }

    public void setExtensionAttributes(String value) {
        this._extensionAttributes = value;
    }

    private void setId(int value) {
        this._id = value;
    }

    private void setUri(String value) {
        this._uri = value;
    }
}

