/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.bzip2;

import fm.icelink.ArrayExtensions;
import fm.icelink.bzip2.Constants;

class DecompressionState {
    public int[] _cftab;
    public int[][] _gBase;
    public byte[] _getAndMoveToFrontDecode_yy;
    public int[][] _gLimit;
    public int[] _gMinlen;
    public int[][] _gPerm;
    public boolean[] _inUse = new boolean[256];
    public byte[] _ll8;
    public byte[] _recvDecodingTables_pos;
    public byte[] _selector;
    public byte[] _selectorMtf;
    public byte[] _seqToUnseq = new byte[256];
    public char[][] _temp_charArray2d;
    public int[] _tt;
    public int[] _unzftab;

    public DecompressionState(int blockSize100k) {
        this._selector = new byte[Constants.getMaxSelectors()];
        this._selectorMtf = new byte[Constants.getMaxSelectors()];
        this._unzftab = new int[256];
        this._gLimit = DecompressionState.initRectangularArrayInt(Constants.getNGroups(), Constants.getMaxAlphaSize());
        this._gBase = DecompressionState.initRectangularArrayInt(Constants.getNGroups(), Constants.getMaxAlphaSize());
        this._gPerm = DecompressionState.initRectangularArrayInt(Constants.getNGroups(), Constants.getMaxAlphaSize());
        this._gMinlen = new int[Constants.getNGroups()];
        this._cftab = new int[257];
        this._getAndMoveToFrontDecode_yy = new byte[256];
        this._temp_charArray2d = DecompressionState.initRectangularArrayChar(Constants.getNGroups(), Constants.getMaxAlphaSize());
        this._recvDecodingTables_pos = new byte[Constants.getNGroups()];
        this._ll8 = new byte[blockSize100k * Constants.getBlockSizeMultiple()];
    }

    static char[][] initRectangularArrayChar(int d1, int d2) {
        char[][] chArray = new char[d1][];
        for (int i = 0; i < d1; ++i) {
            chArray[i] = new char[d2];
        }
        return chArray;
    }

    static int[][] initRectangularArrayInt(int d1, int d2) {
        int[][] numArray = new int[d1][];
        for (int i = 0; i < d1; ++i) {
            numArray[i] = new int[d2];
        }
        return numArray;
    }

    public int[] initTT(int length) {
        int[] tt = this._tt;
        if (tt == null || ArrayExtensions.getLength(tt) < length) {
            this._tt = tt = new int[length];
        }
        return tt;
    }
}

