/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.ReliableChannelType;
import fm.icelink.ReliableRtcDcepDataChannelAck;
import fm.icelink.ReliableRtcDcepDataChannelOpen;
import fm.icelink.SctpMessage;

abstract class ReliableRtcDcepMessage {
    private int _messageType;

    public static int getByteFromChannelType(ReliableChannelType type) {
        if (Global.equals((Object)type, (Object)ReliableChannelType.Reliable)) {
            return 0;
        }
        if (Global.equals((Object)type, (Object)ReliableChannelType.ReliableUnordered)) {
            return BitAssistant.castByte(128);
        }
        if (Global.equals((Object)type, (Object)ReliableChannelType.PartialReliableREXMIT)) {
            return 1;
        }
        if (Global.equals((Object)type, (Object)ReliableChannelType.PartialReliableREXMITUnordered)) {
            return BitAssistant.castByte(129);
        }
        if (Global.equals((Object)type, (Object)ReliableChannelType.PartialReliableTimed)) {
            return 2;
        }
        if (!Global.equals((Object)type, (Object)ReliableChannelType.PartialReliableTimedUnordered)) {
            throw new RuntimeException(new Exception("Reliable Data: unknown channel type."));
        }
        return BitAssistant.castByte(130);
    }

    public abstract byte[] getBytes();

    public int getMessageType() {
        return this._messageType;
    }

    public static ReliableRtcDcepMessage parseBytes(DataBuffer buffer) {
        int _var0 = buffer.read8(0);
        if (_var0 == 3) {
            return ReliableRtcDcepDataChannelOpen.parseBytes(buffer);
        }
        if (_var0 == 2) {
            return ReliableRtcDcepDataChannelAck.parseBytes(buffer);
        }
        return null;
    }

    public static ReliableChannelType parseChannelTypeByte(int typeByte) {
        if (typeByte == 0) {
            return ReliableChannelType.Reliable;
        }
        if (typeByte == 128) {
            return ReliableChannelType.ReliableUnordered;
        }
        if (typeByte == 1) {
            return ReliableChannelType.PartialReliableREXMIT;
        }
        if (typeByte == 129) {
            return ReliableChannelType.PartialReliableREXMITUnordered;
        }
        if (typeByte == 2) {
            return ReliableChannelType.PartialReliableTimed;
        }
        if (typeByte != 130) {
            throw new RuntimeException(new Exception("Reliable Data: unknow channel type."));
        }
        return ReliableChannelType.PartialReliableTimedUnordered;
    }

    protected ReliableRtcDcepMessage() {
    }

    protected void setMessageType(int value) {
        this._messageType = value;
    }

    static ReliableRtcDcepDataChannelOpen tryParseAsDataChannelOpenMessage(SctpMessage msg) {
        ReliableRtcDcepMessage message = ReliableRtcDcepMessage.parseBytes(msg.getPayload());
        if (message.getMessageType() == 3) {
            return (ReliableRtcDcepDataChannelOpen)message;
        }
        return null;
    }
}

