/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.GenericNack;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction1;
import fm.icelink.IFunction1;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import java.util.ArrayList;
import java.util.HashMap;

class NackBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private TFrame[] __frameBuffer;
    private long __highestPacketIndex = 0L;
    private HashMap<Long, Long> __recentNackedPacketIndexes;
    private ArrayList<Long> __recentTimestampsUsedToNack;
    private int _length;
    private String _name;
    private int _retransmissionTimeout;

    private TFrame getFrame(long packetIndex) {
        int index = (int)(packetIndex % (long)ArrayExtensions.getLength(this.__frameBuffer));
        TFrame local = this.__frameBuffer[index];
        if (local != null && ((MediaBuffer)((MediaFrame)local).getBuffer()).getSequenceNumber() == packetIndex) {
            return local;
        }
        return null;
    }

    public int getLength() {
        return this._length;
    }

    public String getName() {
        return this._name;
    }

    public int getRetransmissionTimeout() {
        return this._retransmissionTimeout;
    }

    public NackBuffer(String name, int size, IFunction1<Integer, TFrame[]> createArrayCallback) {
        this.setRetransmissionTimeout(50);
        this.setName(name);
        this.setLength(size);
        this.__frameBuffer = (MediaFrame[])createArrayCallback.invoke(size);
        this.__recentTimestampsUsedToNack = new ArrayList();
        this.__recentNackedPacketIndexes = new HashMap();
    }

    public boolean read(long sequenceNumber, int rtpSequenceNumber, long lastWrittenTimestamp, IAction1<TFrame> frameCallback, IAction1<GenericNackControlFrame> nackCallback) {
        if (sequenceNumber <= this.__highestPacketIndex) {
            long num4;
            long num3;
            long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) / (long)Constants.getTicksPerMillisecond();
            long key = sequenceNumber;
            TFrame frame = this.getFrame(sequenceNumber);
            if (frame != null) {
                this.__recentTimestampsUsedToNack.remove(((MediaFrame)frame).getTimestamp());
                HashMapExtensions.remove(this.__recentNackedPacketIndexes, key);
                Object buffer = ((MediaFrame)frame).getBuffer();
                frameCallback.invoke(frame);
                ((MediaBuffer)buffer).getDataBuffer().free();
                return true;
            }
            if (this.__recentNackedPacketIndexes.containsKey(key) && (num3 = HashMapExtensions.getItem(this.__recentNackedPacketIndexes).get(key).longValue()) > 0L && (num4 = num - num3) < (long)this.getRetransmissionTimeout()) {
                return false;
            }
            if (lastWrittenTimestamp != -1L) {
                if (this.__recentTimestampsUsedToNack.contains(lastWrittenTimestamp)) {
                    return false;
                }
                this.__recentTimestampsUsedToNack.add(lastWrittenTimestamp);
            }
            long num5 = this.__highestPacketIndex - sequenceNumber;
            GenericNack nack = new GenericNack();
            nack.setPacketId(rtpSequenceNumber);
            for (int i = 1; i <= 16; ++i) {
                if (num5 <= (long)i) continue;
                nack.setLostPacketIdPlus(i, this.getFrame(sequenceNumber + (long)i) == null);
            }
            if (!this.__recentNackedPacketIndexes.containsKey(key)) {
                HashMapExtensions.add(this.__recentNackedPacketIndexes, key, num);
            }
            if (nackCallback != null) {
                nackCallback.invoke(new GenericNackControlFrame(nack));
            }
        }
        return false;
    }

    private void setLength(int value) {
        this._length = value;
    }

    private void setName(String value) {
        this._name = value;
    }

    public void setRetransmissionTimeout(int value) {
        this._retransmissionTimeout = value;
    }

    public boolean write(TFrame frame) {
        if (!((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getIsPacketized()) {
            throw new RuntimeException(new Exception("The first buffer of a frame stored to be stored in a Nack.Buffer must have a packetized format."));
        }
        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) != 1) {
            throw new RuntimeException(new Exception("Nack.Buffer only supports a Frame.Buffer.DataBuffers.Length of one."));
        }
        int index = (int)(((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() % (long)ArrayExtensions.getLength(this.__frameBuffer));
        TFrame local = this.__frameBuffer[index];
        if (local != null && ((MediaFrame)local).getTimestamp() > ((MediaFrame)frame).getTimestamp()) {
            return false;
        }
        ((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer().keep();
        this.__frameBuffer[index] = frame;
        this.__highestPacketIndex = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
        return true;
    }
}

