/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.IMediaStream;
import fm.icelink.IStream;
import fm.icelink.Stream;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;

public abstract class MediaStreamBase
extends Stream
implements IMediaStream,
IStream {
    private StreamDirection __localDirection;
    private StreamDirection __pendingLocalDirection;
    private StreamDirection __remoteDirection;
    private int _localBandwidth;
    private int _remoteBandwidth;
    private Object _renegotiationLock = new Object();
    private boolean _renegotiationPending;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Error changeDirection(StreamDirection newDirection) {
        String message = "An attempt has been made to modify exisiting media stream direction; however, existing stream capabilities do not support a new setting.";
        if (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.Inactive) ? !Global.equals((Object)newDirection, (Object)StreamDirection.Inactive) : (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.SendOnly) ? !Global.equals((Object)newDirection, (Object)StreamDirection.Inactive) && !Global.equals((Object)newDirection, (Object)StreamDirection.SendOnly) : Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.ReceiveOnly) && !Global.equals((Object)newDirection, (Object)StreamDirection.Inactive) && !Global.equals((Object)newDirection, (Object)StreamDirection.ReceiveOnly))) {
            return new Error(ErrorCode.InvalidStreamDirectionChange, new Exception(message));
        }
        Object object = this._renegotiationLock;
        synchronized (object) {
            this.setPendingLocalDirection(newDirection);
            this.setRenegotiationPending(true);
        }
        return null;
    }

    @Override
    public StreamDirection getDirection() {
        if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.SendReceive)) {
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.ReceiveOnly)) {
                return StreamDirection.SendOnly;
            }
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.SendOnly)) {
                return StreamDirection.ReceiveOnly;
            }
            return this.getRemoteDirection();
        }
        if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.SendOnly)) {
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.Inactive) || Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.SendOnly)) {
                return StreamDirection.Inactive;
            }
            return this.getLocalDirection();
        }
        if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.ReceiveOnly)) {
            if (Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.Inactive) || Global.equals((Object)this.getRemoteDirection(), (Object)StreamDirection.ReceiveOnly)) {
                return StreamDirection.Inactive;
            }
            return this.getLocalDirection();
        }
        return StreamDirection.Inactive;
    }

    @Override
    public String getLabel() {
        StreamType _var0 = super.getType();
        if (_var0 == StreamType.Audio) {
            return "Audio Stream";
        }
        if (_var0 == StreamType.Video) {
            return "Video Stream";
        }
        if (_var0 == StreamType.Application) {
            return "Application Stream";
        }
        if (_var0 == StreamType.Message) {
            return "Message Stream";
        }
        if (_var0 == StreamType.Text) {
            return "Text Stream";
        }
        return "Unknown Stream";
    }

    @Override
    public int getLocalBandwidth() {
        return this._localBandwidth;
    }

    @Override
    public StreamDirection getLocalDirection() {
        return this.__localDirection;
    }

    public int getMaxInputBitrate() {
        return this.getRemoteBandwidth();
    }

    @Override
    public abstract boolean getMuted();

    protected StreamDirection getPendingLocalDirection() {
        return this.__pendingLocalDirection;
    }

    @Override
    public int getRemoteBandwidth() {
        return this._remoteBandwidth;
    }

    @Override
    public StreamDirection getRemoteDirection() {
        return this.__remoteDirection;
    }

    protected boolean getRenegotiationPending() {
        return this._renegotiationPending;
    }

    public MediaStreamBase(StreamType type) {
        super(type);
        this.__pendingLocalDirection = StreamDirection.Inactive;
        this.setLocalDirection(StreamDirection.Unset);
        this.setRemoteDirection(StreamDirection.Unset);
        this.setLocalBandwidth(-1);
        this.setRemoteBandwidth(-1);
    }

    @Override
    public void setLocalBandwidth(int value) {
        this._localBandwidth = value;
    }

    @Override
    public void setLocalDirection(StreamDirection value) {
        StreamDirection direction = this.getDirection();
        this.__localDirection = value;
        if (!Global.equals((Object)direction, (Object)this.getDirection())) {
            super.raiseDirectionChange();
        }
    }

    @Override
    public abstract void setMuted(boolean var1);

    protected void setPendingLocalDirection(StreamDirection value) {
        this.__pendingLocalDirection = value;
    }

    protected void setRemoteBandwidth(int value) {
        this._remoteBandwidth = value;
    }

    @Override
    protected void setRemoteDirection(StreamDirection value) {
        StreamDirection direction = this.getDirection();
        this.__remoteDirection = value;
        if (!Global.equals((Object)direction, (Object)this.getDirection())) {
            super.raiseDirectionChange();
        }
    }

    protected void setRenegotiationPending(boolean value) {
        this._renegotiationPending = value;
    }
}

