/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.BooleanHolder;
import fm.icelink.CandidateType;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.DatagramSocket;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate3;
import fm.icelink.IceCandidate;
import fm.icelink.IceGatherOptions;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IceGatheringState;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestFailureArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IceServer;
import fm.icelink.IceSocketManager;
import fm.icelink.IceTransactionManager;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.AddressFamily;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.MessageType;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.StaleNonceError;
import fm.icelink.stun.TransactionTransmitCounterAttribute;
import fm.icelink.stun.TryAlternateStunError;
import fm.icelink.stun.UnauthorizedStunError;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.turn.AllocateRequest;
import fm.icelink.stun.turn.AllocateResponse;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DataIndication;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RequestedAddressFamilyAttribute;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;

class IceDatagramSocketManager
extends IceSocketManager {
    private IceCandidate _localHostCandidate;
    private DatagramSocket _socket;

    @Override
    protected void closeSocket() {
        DatagramSocket socket = this.getSocket();
        if (socket != null && !socket.getIsClosed()) {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doListen() {
        DatagramSocket socket = this.getSocket();
        if (socket != null && !this.getSocketIsClosed()) {
            socket.receiveAsync((IAction3<DataBuffer, String, Integer>)new IActionDelegate3<DataBuffer, String, Integer>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceDatagramSocketManager.listenReceiveSuccess";
                }

                @Override
                public void invoke(DataBuffer buffer, String remoteIPAddress, Integer remotePort) {
                    IceDatagramSocketManager.this.listenReceiveSuccess(buffer, remoteIPAddress, remotePort);
                }
            }, (IAction1<Exception>)new IActionDelegate1<Exception>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceDatagramSocketManager.listenReceiveFailure";
                }

                @Override
                public void invoke(Exception ex) {
                    IceDatagramSocketManager.this.listenReceiveFailure(ex);
                }
            });
        } else {
            this._transactionManager.remove(this);
            Object object = super.getLock();
            synchronized (object) {
                if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) && !Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed)) {
                    super.setState(IceGatheringState.Closed);
                }
            }
        }
    }

    private boolean doProcessServerResponse(IceSendRequestSuccessArgs successArgs) {
        ScheduledItem item = successArgs.getItem();
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        Error err = IceDatagramSocketManager.validateResponse(state, successArgs.getResponse(), successArgs.getRemoteAddress());
        boolean flag = successArgs.getResponse() instanceof AllocateResponse;
        String str = "STUN";
        if (flag) {
            str = "TURN";
        }
        if (err == null) {
            Error error2;
            Exception exception;
            if (!successArgs.getRemoteAddress().equals(state.getAddress())) {
                Log.debug(StringExtensions.format("{2} server response source {0} does not match targeted endpoint {1}.", successArgs.getRemoteAddress().toString(), state.getAddress().toString(), str));
                super.removeTransaction(item);
                return false;
            }
            String address = null;
            int port = 0;
            XorMappedAddressAttribute xorMappedAddress = successArgs.getResponse().getXorMappedAddress();
            if (xorMappedAddress != null) {
                address = xorMappedAddress.getIPAddress();
                port = xorMappedAddress.getPort();
            } else {
                MappedAddressAttribute mappedAddress = successArgs.getResponse().getMappedAddress();
                if (mappedAddress != null) {
                    address = mappedAddress.getIPAddress();
                    port = mappedAddress.getPort();
                }
            }
            if (flag) {
                try {
                    String nonce;
                    AllocateRequest message = (AllocateRequest)state.getMessage();
                    String relayPassword = state.getRelayPassword();
                    String turnUserName = message.getUsername() == null ? StringExtensions.empty : message.getUsername().getValue();
                    XorRelayedAddressAttribute xorRelayedAddress = successArgs.getResponse().getXorRelayedAddress();
                    LifetimeAttribute lifetime = successArgs.getResponse().getLifetime();
                    String turnRealm = message.getRealm() == null ? StringExtensions.empty : message.getRealm().getValue();
                    String string = nonce = message.getNonce() == null ? StringExtensions.empty : message.getNonce().getValue();
                    if (TransportAddress.isAny(xorRelayedAddress.getIPAddress())) {
                        xorRelayedAddress.setIPAddress(successArgs.getRemoteAddress().getIPAddress());
                    }
                    String foundation = IceCandidate.generateLocalCandidateFoundation(CandidateType.Relayed, xorRelayedAddress.getIPAddress(), successArgs.getRemoteAddress(), ProtocolType.Udp);
                    IceLocalRelayedCandidate candidate2 = new IceLocalRelayedCandidate(super.getLock(), foundation, ProtocolType.Udp, xorRelayedAddress.getIPAddress(), xorRelayedAddress.getPort(), xorMappedAddress.getIPAddress(), xorMappedAddress.getPort(), lifetime.getLifetime(), turnUserName, relayPassword, nonce, turnRealm, state.getAddress(), this._transactionManager, super.getGatherOptions().getStunRequestTimeout());
                    candidate2.setAdapterSpeed(this.getSocket().getAdapterSpeed());
                    candidate2.setDispatchStunMessage((IAction1<IceSendMessageArgs>)new IActionDelegate1<IceSendMessageArgs>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceDatagramSocketManager.sendStunMessage";
                        }

                        @Override
                        public void invoke(IceSendMessageArgs context) {
                            IceDatagramSocketManager.this.sendStunMessage(context);
                        }
                    });
                    candidate2.setDispatchApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceSocketManager.sendApplicationData";
                        }

                        @Override
                        public void invoke(DataBuffer buffer, IceCandidate remote, TransportAddress turnRelay) {
                            IceDatagramSocketManager.this.sendApplicationData(buffer, remote, turnRelay);
                        }
                    });
                    candidate2.setOnRelayStateChanged((IAction1<IceLocalRelayedCandidate>)new IActionDelegate1<IceLocalRelayedCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceSocketManager.processRelayedCandidateStateChanged";
                        }

                        @Override
                        public void invoke(IceLocalRelayedCandidate candidate) {
                            IceDatagramSocketManager.this.processRelayedCandidateStateChanged(candidate);
                        }
                    });
                    candidate2.setDiscoverProtocol(ProtocolType.Udp);
                    IceLocalRelayedCandidate localCandidate = candidate2;
                    int instanteneousRtt = this._transactionManager.calculateInstanteneousRtt(successArgs, true);
                    if (instanteneousRtt >= 0) {
                        localCandidate.setLastRelayServerRoundTripTime(instanteneousRtt);
                        localCandidate.setSmoothedRelayServerRoundTripTime(IceTransactionManager.calculateSmoothedRtt(instanteneousRtt, localCandidate.getSmoothedRelayServerRoundTripTime()));
                    }
                    localCandidate.setBase(localCandidate);
                    super.raiseLocalCandidate(localCandidate);
                    localCandidate.startScheduleRefreshTransactions();
                }
                catch (Exception exception1) {
                    exception = exception1;
                    error2 = new Error(ErrorCode.IceLocalRelayedDatagramCandidateError, exception);
                    Log.debug(StringExtensions.format("Datagram Socket Manager: Could not process TURN server response: {0}", error2.getDescription()));
                }
            }
            if (state.getRaiseServerReflexiveCandidates()) {
                try {
                    String str9 = IceCandidate.generateLocalCandidateFoundation(CandidateType.ServerReflexive, this.getLocalHostCandidate().getIPAddress(), successArgs.getRemoteAddress(), ProtocolType.Udp);
                    IceCandidate candidate4 = new IceCandidate(super.getLock(), str9, ProtocolType.Udp, address, port, CandidateType.ServerReflexive, this.getSocket().getLocalIPAddress(), this.getSocket().getLocalPort());
                    candidate4.setAdapterSpeed(this.getSocket().getAdapterSpeed());
                    candidate4.setDispatchStunMessage((IAction1<IceSendMessageArgs>)new IActionDelegate1<IceSendMessageArgs>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceDatagramSocketManager.sendStunMessage";
                        }

                        @Override
                        public void invoke(IceSendMessageArgs context) {
                            IceDatagramSocketManager.this.sendStunMessage(context);
                        }
                    });
                    candidate4.setBase(this.getLocalHostCandidate());
                    candidate4.setDiscoverProtocol(ProtocolType.Udp);
                    IceCandidate candidate3 = candidate4;
                    super.raiseLocalCandidate(candidate3);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    error2 = new Error(ErrorCode.IceLocalServerReflexiveCandidateError, exception);
                    Log.debug(StringExtensions.format("Datagram Socket Manager: Could not process STUN server response: {0}", error2.getDescription()));
                }
            }
        } else {
            String str10 = null;
            String str11 = null;
            if (flag && Global.equals((Object)err.getErrorCode(), (Object)ErrorCode.StunUnauthorized) && state.getMessage().getNonce() == null && state.getMessage().getRealm() == null) {
                UnauthorizedStunError error3 = (UnauthorizedStunError)err;
                if (error3.getNonce() != null) {
                    str10 = error3.getNonce().getValue();
                }
                if (error3.getRealm() != null) {
                    str11 = error3.getRealm().getValue();
                }
            } else if (flag && Global.equals((Object)err.getErrorCode(), (Object)ErrorCode.StunStaleNonce)) {
                StaleNonceError error4 = (StaleNonceError)err;
                if (error4.getNonce() != null) {
                    str10 = error4.getNonce().getValue();
                }
                if (error4.getRealm() != null) {
                    str11 = error4.getRealm().getValue();
                }
                String str12 = "";
                if (this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                    str12 = " Further attempts to establish server allocation will be made with an updated nonce.";
                }
                Log.debug(StringExtensions.format("{3} server {0} reports error {1}.{2}", new Object[]{successArgs.getRemoteAddress().toString(), err.getDescription(), str12, str}));
            } else if (Global.equals((Object)err.getErrorCode(), (Object)ErrorCode.StunTryAlternate)) {
                TryAlternateStunError error5 = (TryAlternateStunError)err;
                state.setAddress(new TransportAddress(error5.getAlternateServer().getIPAddress(), error5.getAlternateServer().getPort()));
                String str12 = "";
                if (this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                    str12 = flag ? " Attempts to establish server allocation with a new server will be made." : " Attempts to establish server binding with a new server will be made.";
                }
                Log.debug(StringExtensions.format("{3} server sent an instruction to try an alternate server {0}.{2}.", state.getAddress().toString(), str12, str));
            } else {
                if (flag && Global.equals((Object)err.getErrorCode(), (Object)ErrorCode.StunTurnAllocationMismatch)) {
                    if (this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                        Log.debug(StringExtensions.format("TURN allocate request to {0} from {1}: allocation mismatch detected. Further attempts to establish server allocation will be made.", successArgs.getRemoteAddress().toString(), this.getSocket().getLocalIPAddress()));
                        IAction1<IceSocketManager> onAllocationMismatchException = super.getOnAllocationMismatchException();
                        if (onAllocationMismatchException != null) {
                            onAllocationMismatchException.invoke(this);
                        }
                    } else {
                        Log.debug(StringExtensions.format("TURN allocate request to {0} from {1}: allocation mismatch detected. No further attempts to establish server allocation will be made.", successArgs.getRemoteAddress().toString(), this.getSocket().getLocalIPAddress()));
                    }
                } else {
                    Log.debug(StringExtensions.format("{2} server {0} reports error {1}.", successArgs.getRemoteAddress().toString(), err.getDescription(), str));
                }
                this.finaliseGathering(err);
                super.removeTransaction(item);
                return false;
            }
            if (!flag && this.__numberOfRequests < super.getGatherOptions().getStunBindingRequestLimit() || flag && this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                if (!StringExtensions.isNullOrEmpty(str10)) {
                    state.getMessage().setNonce(new NonceAttribute(str10));
                }
                if (!StringExtensions.isNullOrEmpty(str11)) {
                    state.getMessage().setRealm(new RealmAttribute(str11));
                }
                if (flag) {
                    this.serverAllocate(state.getMessage().getUsername().getValue(), state.getRelayPassword(), state.getAddress().getIPAddress(), state.getAddress().getPort(), state.getRaiseServerReflexiveCandidates(), str10, str11);
                } else {
                    this.serverBind(state.getAddress(), str10);
                }
                super.removeTransaction(item);
                return false;
            }
            this.finaliseGathering(err);
            super.removeTransaction(item);
            return false;
        }
        super.removeTransaction(item);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finaliseGathering(Error err) {
        if (!super.getIsGathering()) {
            if (this._localCandidates != null && HashMapExtensions.getCount(this._localCandidates) > 0) {
                Object object = super.getLock();
                synchronized (object) {
                    if (Global.equals((Object)super.getState(), (Object)IceGatheringState.Gathering)) {
                        super.setState(IceGatheringState.Complete);
                    }
                }
            } else {
                super.setError(err);
                super.setState(IceGatheringState.Failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gatherLocalNonHostCandidates(IceServer server, IceGatherPolicy policy) {
        Object obj2;
        Object object = obj2 = super.getLock();
        synchronized (object) {
            if (Global.equals((Object)super.getState(), (Object)IceGatheringState.New) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Complete)) {
                super.setState(IceGatheringState.Gathering);
            } else if (Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed)) {
                Log.error("Datagram socket manager in closed state when attempting to gather local candidates");
                return;
            }
        }
        if (server.getIPAddresses() == null || ArrayExtensions.getLength(server.getIPAddresses()) == 0) {
            Log.debug("Datagram socket manager cannot gather non-local candidates: server IP addresses not supplied.");
        } else {
            boolean raiseStun = Global.equals((Object)policy, (Object)IceGatherPolicy.All) || Global.equals((Object)policy, (Object)IceGatherPolicy.NoHost);
            for (String str : server.getIPAddresses()) {
                this.gatherLocalNonHostCandidatesForAddress(str, server, raiseStun);
            }
            if (!super.getIsGathering()) {
                Object object2 = obj2 = super.getLock();
                synchronized (object2) {
                    if (Global.equals((Object)super.getState(), (Object)IceGatheringState.Gathering)) {
                        super.setState(IceGatheringState.Complete);
                    }
                }
            }
        }
    }

    private void gatherLocalNonHostCandidatesForAddress(String serverIp, IceServer server, boolean raiseStun) {
        String ipAddress;
        String string = ipAddress = this.getLocalHostCandidate() == null ? null : this.getLocalHostCandidate().getIPAddress();
        if (ipAddress != null && serverIp != null && Global.equals((Object)LocalNetwork.getAddressType(ipAddress), (Object)LocalNetwork.getAddressType(serverIp))) {
            if (server.getIsTurn() && serverIp != null) {
                this.serverAllocate(server.getUsername(), server.getPassword(), serverIp, server.getPort(), raiseStun, null, null);
            } else if (server.getIsStun() && raiseStun && serverIp != null) {
                this.serverBind(new TransportAddress(serverIp, server.getPort()), null);
            }
        }
    }

    @Override
    long getAdapterSpeed() {
        if (this.getLocalHostCandidate() != null) {
            return this.getLocalHostCandidate().getAdapterSpeed();
        }
        return 0L;
    }

    IceCandidate getLocalHostCandidate() {
        return this._localHostCandidate;
    }

    @Override
    String getLocalIpAddress() {
        if (this.getSocket() != null) {
            return this.getSocket().getLocalIPAddress();
        }
        return StringExtensions.empty;
    }

    @Override
    int getLocalPort() {
        if (this.getSocket() != null) {
            return this.getSocket().getLocalPort();
        }
        return 0;
    }

    public TransportAddress getLocalTransportAddress() {
        DatagramSocket socket = this.getSocket();
        TransportAddress address = null;
        if (socket == null) {
            return address;
        }
        String localIPAddress = socket.getLocalIPAddress();
        if (localIPAddress == null) {
            localIPAddress = StringExtensions.empty;
        }
        return new TransportAddress(localIPAddress, socket.getLocalPort());
    }

    public DatagramSocket getSocket() {
        return this._socket;
    }

    private boolean getSocketIsClosed() {
        DatagramSocket socket = this.getSocket();
        return socket == null || socket.getIsClosed();
    }

    public IceDatagramSocketManager(Object lockObject, DatagramSocket socket, IceTransactionManager manager) {
        super(lockObject, manager);
        super.setProtocol(ProtocolType.Udp);
        if (socket == null) {
            throw new RuntimeException(new Exception("Socket cannot be null."));
        }
        this.setSocket(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenReceiveFailure(Exception ex) {
        Object object = super.getLock();
        synchronized (object) {
            this._transactionManager.remove(this);
            this.closeSocket();
            if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) && !Global.equals((Object)super.getState(), (Object)IceGatheringState.Closing)) {
                super.setError(new Error(ErrorCode.SocketReceiveError, ex));
                super.setState(IceGatheringState.Failed);
            }
        }
    }

    private void listenReceiveSuccess(DataBuffer buffer, String remoteIPAddress, int remotePort) {
        boolean relayed = false;
        TransportAddress address = new TransportAddress(remoteIPAddress, remotePort);
        Holder<DataBuffer> _var0 = new Holder<DataBuffer>(buffer);
        Holder<TransportAddress> _var1 = new Holder<TransportAddress>(address);
        BooleanHolder _var2 = new BooleanHolder(relayed);
        Message _var3 = this.postProcess(buffer, address, _var0, _var1, _var2);
        buffer = _var0.getValue();
        address = _var1.getValue();
        relayed = _var2.getValue();
        Message message = _var3;
        if (message == null) {
            IceCandidate localHostCandidate = this.getLocalHostCandidate();
            if (relayed) {
                TransportAddress address2 = new TransportAddress(remoteIPAddress, remotePort);
                IceLocalRelayedCandidate candidate2 = null;
                Holder<Object> _var4 = new Holder<Object>(candidate2);
                boolean _var5 = HashMapExtensions.tryGetValue(this._localRelayedCandidates, address2.toString(), _var4);
                candidate2 = _var4.getValue();
                if (!_var5) {
                    Log.error(StringExtensions.format("Could not find local server relayed candidate matching incoming binding request for remote IP {0} and relay server {1}:{2}.", address.getIPAddress(), remoteIPAddress, IntegerExtensions.toString(remotePort)));
                    return;
                }
                localHostCandidate = candidate2;
            }
            if (buffer != null) {
                super.getOnIncomingData().invoke(buffer, localHostCandidate, address);
            }
        } else {
            String key = Base64.encodeBuffer(message.getTransactionId());
            IceSendRequestSuccessArgs successArgs = new IceSendRequestSuccessArgs();
            successArgs.setRemoteAddress(address);
            successArgs.setResponse(message);
            successArgs.setRelayed(relayed);
            if (!this._transactionManager.tryTriggerOnResponse(key, successArgs) && message instanceof BindingRequest) {
                IAction3<Message, IceCandidate, TransportAddress> onStunRequest;
                IceCandidate localHostCandidate = this.getLocalHostCandidate();
                if (relayed) {
                    TransportAddress address2 = new TransportAddress(remoteIPAddress, remotePort);
                    IceLocalRelayedCandidate candidate2 = null;
                    Holder<Object> _var6 = new Holder<Object>(candidate2);
                    boolean _var7 = HashMapExtensions.tryGetValue(this._localRelayedCandidates, address2.toString(), _var6);
                    candidate2 = _var6.getValue();
                    if (!_var7) {
                        Log.error(StringExtensions.format("Could not find local server relayed candidate matching incoming binding request for remote IP {0} and relay server {1}:{2}.", address.getIPAddress(), remoteIPAddress, IntegerExtensions.toString(remotePort)));
                        return;
                    }
                    localHostCandidate = candidate2;
                }
                if ((onStunRequest = super.getOnStunRequest()) != null) {
                    onStunRequest.invoke(message, localHostCandidate, address);
                }
            }
        }
        if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) && !Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed)) {
            this.doListen();
        }
    }

    private Message postProcess(DataBuffer buffer, TransportAddress address, Holder<DataBuffer> newBuffer, Holder<TransportAddress> newAddress, BooleanHolder relayed) {
        Message message = null;
        try {
            message = Message.readFrom(buffer);
            if (message != null && message instanceof DataIndication) {
                DataAttribute data = message.getData();
                XorPeerAddressAttribute xorPeerAddress = message.getXorPeerAddress();
                newBuffer.setValue(data.getData());
                newAddress.setValue(new TransportAddress(xorPeerAddress.getIPAddress(), xorPeerAddress.getPort()));
                relayed.setValue(true);
                return Message.readFrom(newBuffer.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        newBuffer.setValue(buffer);
        newAddress.setValue(address);
        relayed.setValue(false);
        return message;
    }

    private void processServerResponse(IceSendRequestSuccessArgs successArgs) {
        if (successArgs.getResponse() instanceof BindingResponse || successArgs.getResponse() instanceof AllocateResponse) {
            this.doProcessServerResponse(successArgs);
        }
    }

    private void sendAllocateRequestTimedout(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        try {
            TransportAddress localTransportAddress = this.getLocalTransportAddress();
            String str = localTransportAddress == null ? StringExtensions.empty : localTransportAddress.toString();
            Log.error(StringExtensions.format("Allocate request from {1} to {0} timed out.", state.getAddress().toString(), str));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.removeTransaction(item);
    }

    @Override
    protected void sendApplicationData(DataBuffer buffer, IceCandidate remote, TransportAddress turnRelay) {
        if (!(Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Closing) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed) || Global.equals((Object)super.getState(), (Object)IceGatheringState.New) || remote == null || buffer == null)) {
            if (this.getSocketIsClosed()) {
                super.setError(new Error(ErrorCode.SocketClosed, new Exception("Could not send application data: socket is closed.")));
                super.setState(IceGatheringState.Failed);
            } else {
                try {
                    TransportAddress transportAddress = remote.getTransportAddress();
                    DataBuffer newBuffer = null;
                    Holder<Object> _var0 = new Holder<Object>(newBuffer);
                    Holder<TransportAddress> _var1 = new Holder<TransportAddress>(transportAddress);
                    super.turnPreProcess(buffer, transportAddress, turnRelay, _var0, _var1);
                    newBuffer = _var0.getValue();
                    transportAddress = _var1.getValue();
                    if (!this.getSocket().getIsClosed()) {
                        if (this.getSocket().send(newBuffer, transportAddress.getIPAddress(), transportAddress.getPort()) <= 0) {
                            // empty if block
                        }
                    } else {
                        super.setError(new Error(ErrorCode.SocketClosed, new Exception("Could not send application data: socket is not open.")));
                        super.setState(IceGatheringState.Failed);
                    }
                }
                catch (Exception exception) {
                    if (Log.getIsDebugEnabled()) {
                        Log.debug("Could not send on socket.", exception);
                    }
                    super.setError(new Error(ErrorCode.SocketSendError, exception));
                    super.setState(IceGatheringState.Failed);
                }
            }
        }
    }

    private void sendBindingRequestTimedout(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        TransportAddress localTransportAddress = this.getLocalTransportAddress();
        String str = localTransportAddress == null ? StringExtensions.empty : localTransportAddress.toString();
        Log.error(StringExtensions.format("Binding request from {1} to {0} timed out.", state.getAddress().toString(), str));
        super.removeTransaction(item);
    }

    private void sendServerAllocateStunMessage(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        Message message = state.getMessage();
        int invocationCount = item.getInvocationCount();
        message.setTransactionTransmitCounter(new TransactionTransmitCounterAttribute(invocationCount));
        this.sendStunMessage(state);
    }

    private void sendServerBindStunMessage(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        this.sendStunMessage(state);
    }

    private void sendStunMessage(IceSendMessageArgs context) {
        Error error = null;
        Holder<Object> _var0 = new Holder<Object>(error);
        boolean _var1 = this.tryDispatchStunMessage(context, _var0);
        error = _var0.getValue();
        if (!_var1 && !Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed)) {
            IAction1<IceSendRequestFailureArgs> onFailure = context.getOnFailure();
            IceSendRequestFailureArgs args2 = new IceSendRequestFailureArgs();
            args2.setCandidatePair(context.getCandidatePair());
            args2.setError(error);
            args2.setAddress(context.getAddress());
            args2.setTurnRelay(context.getTurnRelay());
            IceSendRequestFailureArgs p = args2;
            if (onFailure != null) {
                onFailure.invoke(p);
            } else {
                Log.error(StringExtensions.format("Unable to send request: {0}", error.getDescription()));
            }
            super.setError(error);
            super.setState(IceGatheringState.Failed);
        }
    }

    private void serverAllocate(String username, String password, String ipAddress, int port, boolean raiseStun, String nonce, String realm) {
        ++this.__numberOfRequests;
        AllocateRequest message = new AllocateRequest();
        message.setRequestedTransport(new RequestedTransportAttribute(RequestedTransportAttribute.getUdpProtocol()));
        message.setEvenPort(new EvenPortAttribute(false));
        message.setUsername(new UsernameAttribute(username));
        boolean flag = false;
        if (!StringExtensions.isNullOrEmpty(realm)) {
            flag = true;
            message.setRealm(new RealmAttribute(realm));
        }
        boolean flag2 = false;
        if (!StringExtensions.isNullOrEmpty(nonce)) {
            flag2 = true;
            message.setNonce(new NonceAttribute(nonce));
        }
        if (flag && flag2) {
            message.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createLongTermKey(username, realm, password)));
        }
        if (Global.equals((Object)LocalNetwork.getAddressType(ipAddress), (Object)AddressType.IPv6)) {
            message.setRequestedAddressFamily(new RequestedAddressFamilyAttribute(AddressFamily.getIPv6()));
        }
        TransportAddress address = new TransportAddress(ipAddress, port);
        IceSendMessageArgs args2 = new IceSendMessageArgs(message, address);
        args2.setRelayPassword(password);
        args2.setRaiseServerReflexiveCandidates(raiseStun);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceDatagramSocketManager.processServerResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs successArgs) {
                IceDatagramSocketManager.this.processServerResponse(successArgs);
            }
        });
        IceSendMessageArgs args = args2;
        ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceDatagramSocketManager.sendServerAllocateStunMessage";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceDatagramSocketManager.this.sendServerAllocateStunMessage(item);
            }
        }, 0, 100, super.getGatherOptions().getStunRequestTimeout(), ScheduledItem.getUnset());
        item2.setState(args);
        item2.setIntervalBackoffMultiplier(2.0f);
        item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceDatagramSocketManager.sendAllocateRequestTimedout";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceDatagramSocketManager.this.sendAllocateRequestTimedout(item);
            }
        });
        item2.setRecordDetailedInvocationTimes(true);
        ScheduledItem item = item2;
        this._transactionManager.addTransaction(item, this);
    }

    private void serverBind(TransportAddress address, String nonce) {
        ++this.__numberOfRequests;
        BindingRequest message = new BindingRequest();
        if (!StringExtensions.isNullOrEmpty(nonce)) {
            message.setNonce(new NonceAttribute(nonce));
        }
        IceSendMessageArgs args2 = new IceSendMessageArgs(message, address);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceDatagramSocketManager.processServerResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs successArgs) {
                IceDatagramSocketManager.this.processServerResponse(successArgs);
            }
        });
        IceSendMessageArgs args = args2;
        ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceDatagramSocketManager.sendServerBindStunMessage";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceDatagramSocketManager.this.sendServerBindStunMessage(item);
            }
        }, 0, 100, super.getGatherOptions().getStunRequestTimeout(), ScheduledItem.getUnset());
        item2.setState(args);
        item2.setIntervalBackoffMultiplier(2.0f);
        item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceDatagramSocketManager.sendBindingRequestTimedout";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceDatagramSocketManager.this.sendBindingRequestTimedout(item);
            }
        });
        ScheduledItem item = item2;
        this._transactionManager.addTransaction(item, this);
    }

    private void setLocalHostCandidate(IceCandidate value) {
        this._localHostCandidate = value;
    }

    private void setSocket(DatagramSocket value) {
        this._socket = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(IceGatherOptions options) {
        super.setGatherOptions(options);
        Object object = super.getLock();
        synchronized (object) {
            if (Global.equals((Object)super.getState(), (Object)IceGatheringState.Gathering) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Complete)) {
                throw new RuntimeException(new Exception(StringExtensions.format("Could not start Datagram Socket Manager: it is in {0} state.", super.getState().toString())));
            }
            try {
                String foundation = IceCandidate.generateLocalCandidateFoundation(CandidateType.Host, this.getSocket().getLocalIPAddress(), null, ProtocolType.Udp);
                IceCandidate candidate4 = new IceCandidate(super.getLock(), foundation, ProtocolType.Udp, this.getSocket().getLocalIPAddress(), this.getSocket().getLocalPort(), CandidateType.Host);
                candidate4.setAdapterSpeed(this.getSocket().getAdapterSpeed());
                candidate4.setDispatchStunMessage((IAction1<IceSendMessageArgs>)new IActionDelegate1<IceSendMessageArgs>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceDatagramSocketManager.sendStunMessage";
                    }

                    @Override
                    public void invoke(IceSendMessageArgs context) {
                        IceDatagramSocketManager.this.sendStunMessage(context);
                    }
                });
                candidate4.setDispatchApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceSocketManager.sendApplicationData";
                    }

                    @Override
                    public void invoke(DataBuffer buffer, IceCandidate remote, TransportAddress turnRelay) {
                        IceDatagramSocketManager.this.sendApplicationData(buffer, remote, turnRelay);
                    }
                });
                candidate4.setDiscoverProtocol(ProtocolType.Udp);
                IceCandidate localCandidate = candidate4;
                localCandidate.setBase(localCandidate);
                this.setLocalHostCandidate(localCandidate);
                if (Global.equals((Object)super.getGatherOptions().getPolicy(), (Object)IceGatherPolicy.All)) {
                    super.raiseLocalCandidate(localCandidate);
                }
                if (options.getPublicIPAddresses() != null && !Global.equals((Object)super.getGatherOptions().getPolicy(), (Object)IceGatherPolicy.Relay)) {
                    for (String str2 : options.getPublicIPAddresses()) {
                        String str3 = IceCandidate.generateLocalCandidateFoundation(CandidateType.ServerReflexive, str2, null, ProtocolType.Udp);
                        IceCandidate candidate3 = new IceCandidate(super.getLock(), str3, ProtocolType.Udp, str2, localCandidate.getPort(), CandidateType.ServerReflexive, localCandidate.getIPAddress(), localCandidate.getPort());
                        candidate3.setDiscoverProtocol(ProtocolType.Udp);
                        candidate3.setBase(localCandidate);
                        IceCandidate candidate2 = candidate3;
                        super.raiseLocalCandidate(candidate2);
                    }
                }
                super.setState(IceGatheringState.Complete);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.doListen();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDispatchStunMessage(IceSendMessageArgs e, Holder<Error> error) {
        boolean flag;
        block7: {
            try {
                if (this.getSocketIsClosed()) {
                    error.setValue(new Error(ErrorCode.SocketClosed, new Exception("Datagram socket is closed.")));
                    flag = false;
                    break block7;
                }
                DataBuffer buffer = DataBufferPool.getInstance().take(e.getMessage().getLength());
                try {
                    e.getMessage().writeTo(buffer);
                    TransportAddress address = e.getAddress();
                    DataBuffer newBuffer = null;
                    Holder<Object> _var0 = new Holder<Object>(newBuffer);
                    Holder<TransportAddress> _var1 = new Holder<TransportAddress>(address);
                    super.turnPreProcess(buffer, address, e.getTurnRelay(), _var0, _var1);
                    newBuffer = _var0.getValue();
                    address = _var1.getValue();
                    if (!this.getSocket().getIsClosed()) {
                        this.getSocket().send(newBuffer, address.getIPAddress(), address.getPort());
                    }
                    error.setValue(null);
                    flag = true;
                }
                finally {
                    buffer.free();
                }
            }
            catch (Exception exception) {
                error.setValue(new Error(ErrorCode.SocketSendError, exception));
                Log.error(StringExtensions.format("Could not send message: {0}", exception.getMessage()));
                flag = false;
            }
        }
        return flag;
    }

    static Error validateResponse(IceSendMessageArgs sendRequestArgs, Message response, TransportAddress remoteAddress) {
        if (sendRequestArgs.getMessage() instanceof BindingRequest && !(response instanceof BindingResponse)) {
            return new Error(ErrorCode.StunInvalidResponseType, new Exception("Client generated a Stun Binding Request but received a message of the type other than Binding Response."));
        }
        if (!sendRequestArgs.getMessage().getTransactionId().sequenceEquals(response.getTransactionId())) {
            return new Error(ErrorCode.StunInvalidTransactionId, new Exception(StringExtensions.format("Response transaction ID {0} does not match request transaction ID {1}.", response.getTransactionId().toHexString(), sendRequestArgs.getMessage().getTransactionId().toHexString())));
        }
        if (Global.equals((Object)response.getMessageType(), (Object)MessageType.ErrorResponse)) {
            ErrorCodeAttribute errorCode = response.getErrorCode();
            if (errorCode == null) {
                return new Error(ErrorCode.StunInvalidErrorCode, new Exception("Error response received, but no error code was supplied."));
            }
            Error error = fm.icelink.stun.Error.createStunError(errorCode.getCode(), response);
            if (error != null) {
                return error;
            }
            return new Error(ErrorCode.StunUnknownStunErrorCode, new Exception(StringExtensions.format("Server responded with an unknown error code ({0}).", IntegerExtensions.toString(errorCode.getCode()))));
        }
        return null;
    }
}

