/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.CandidateType;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import fm.icelink.ProtocolType;
import java.util.ArrayList;
import java.util.HashMap;

public class CandidateStats
extends BaseStats {
    private ProtocolType __turnTransportProtocol = ProtocolType.Unknown;
    private String _ipAddress;
    private int _port;
    private long _priority;
    private ProtocolType _protocol;
    private String _relatedIPAddress;
    private int _relatedPort;
    private CandidateType _type;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String _var0 = key;
        if (_var0.equals("ipAddress")) {
            this.setIPAddress(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("port")) {
            this.setPort(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("turnProtocol")) {
            this.setTurnProtocol(this.protocolTypeFromString(JsonSerializer.deserializeString(valueJson)));
        } else if (_var0.equals("relatedIPAddress")) {
            this.setRelatedIPAddress(JsonSerializer.deserializeString(valueJson));
        } else if (_var0.equals("relatedPort")) {
            this.setRelatedPort(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("protocol")) {
            this.setProtocol(this.protocolTypeFromString(JsonSerializer.deserializeString(valueJson)));
        } else if (_var0.equals("type")) {
            this.setType(this.typeFromString(JsonSerializer.deserializeString(valueJson)));
        } else if (_var0.equals("priority")) {
            this.setPriority(JsonSerializer.deserializeLong(valueJson).getValue());
        }
    }

    public static CandidateStats fromJson(String candidateJson) {
        return JsonSerializer.deserializeObject(candidateJson, new IFunction0<CandidateStats>(){

            @Override
            public CandidateStats invoke() {
                return new CandidateStats();
            }
        }, new IAction3<CandidateStats, String, String>(){

            @Override
            public void invoke(CandidateStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public static CandidateStats[] fromJsonArray(String candidatesJson) {
        ArrayList<CandidateStats> list = JsonSerializer.deserializeObjectArray(candidatesJson, new IFunctionDelegate1<String, CandidateStats>(){

            @Override
            public String getId() {
                return "fm.icelink.CandidateStats.fromJson";
            }

            @Override
            public CandidateStats invoke(String candidateJson) {
                return CandidateStats.fromJson(candidateJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new CandidateStats[0]);
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public boolean getIsHost() {
        return Global.equals((Object)this.getType(), (Object)CandidateType.Host);
    }

    public boolean getIsReflexive() {
        return Global.equals((Object)this.getType(), (Object)CandidateType.ServerReflexive) || Global.equals((Object)this.getType(), (Object)CandidateType.PeerReflexive);
    }

    public boolean getIsRelayed() {
        return Global.equals((Object)this.getType(), (Object)CandidateType.Relayed);
    }

    public int getPort() {
        return this._port;
    }

    public long getPriority() {
        return this._priority;
    }

    public ProtocolType getProtocol() {
        return this._protocol;
    }

    public String getRelatedIPAddress() {
        return this._relatedIPAddress;
    }

    public int getRelatedPort() {
        return this._relatedPort;
    }

    public ProtocolType getTurnProtocol() {
        return this.__turnTransportProtocol;
    }

    public CandidateType getType() {
        return this._type;
    }

    private ProtocolType protocolTypeFromString(String protocolTypeString) {
        String _var0 = protocolTypeString;
        if (_var0.equals("udp")) {
            return ProtocolType.Udp;
        }
        if (_var0.equals("tcp")) {
            return ProtocolType.Tcp;
        }
        return ProtocolType.Unknown;
    }

    private String protocolTypeToString(ProtocolType protocolType) {
        ProtocolType _var0 = protocolType;
        if (_var0 == ProtocolType.Udp) {
            return "udp";
        }
        if (_var0 == ProtocolType.Tcp) {
            return "tcp";
        }
        return "unknown";
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        if (this.getIPAddress() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "ipAddress", JsonSerializer.serializeString(this.getIPAddress()));
        }
        if (this.getPort() != 0) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "port", JsonSerializer.serializeInteger(new NullableInteger(this.getPort())));
        }
        if (this.getRelatedIPAddress() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "relatedIPAddress", JsonSerializer.serializeString(this.getRelatedIPAddress()));
        }
        if (this.getRelatedPort() != 0) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "relatedPort", JsonSerializer.serializeInteger(new NullableInteger(this.getRelatedPort())));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "protocol", JsonSerializer.serializeString(this.protocolTypeToString(this.getProtocol())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "type", JsonSerializer.serializeString(this.typeToString(this.getType())));
        if (Global.equals((Object)this.getType(), (Object)CandidateType.Relayed)) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "turnProtocol", JsonSerializer.serializeString(this.protocolTypeToString(this.getTurnProtocol())));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "priority", JsonSerializer.serializeLong(new NullableLong(this.getPriority())));
    }

    void setIPAddress(String value) {
        this._ipAddress = value;
    }

    void setPort(int value) {
        this._port = value;
    }

    void setPriority(long value) {
        this._priority = value;
    }

    void setProtocol(ProtocolType value) {
        this._protocol = value;
    }

    void setRelatedIPAddress(String value) {
        this._relatedIPAddress = value;
    }

    void setRelatedPort(int value) {
        this._relatedPort = value;
    }

    void setTurnProtocol(ProtocolType value) {
        this.__turnTransportProtocol = value;
    }

    void setType(CandidateType value) {
        this._type = value;
    }

    public static String toJson(CandidateStats candidate) {
        return JsonSerializer.serializeObject(candidate, new IAction2<CandidateStats, HashMap<String, String>>(){

            @Override
            public void invoke(CandidateStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public String toJson() {
        return CandidateStats.toJson(this);
    }

    public static String toJsonArray(CandidateStats[] candidates) {
        return JsonSerializer.serializeObjectArray(candidates, new IFunctionDelegate1<CandidateStats, String>(){

            @Override
            public String getId() {
                return "fm.icelink.CandidateStats.toJson";
            }

            @Override
            public String invoke(CandidateStats candidate) {
                return CandidateStats.toJson(candidate);
            }
        });
    }

    private CandidateType typeFromString(String typeString) {
        String _var0 = typeString;
        if (_var0.equals("host")) {
            return CandidateType.Host;
        }
        if (_var0.equals("srflx")) {
            return CandidateType.ServerReflexive;
        }
        if (_var0.equals("relay")) {
            return CandidateType.Relayed;
        }
        if (_var0.equals("prflx")) {
            return CandidateType.PeerReflexive;
        }
        return CandidateType.Unknown;
    }

    private String typeToString(CandidateType type) {
        CandidateType _var0 = type;
        if (_var0 == CandidateType.Host) {
            return "host";
        }
        if (_var0 == CandidateType.ServerReflexive) {
            return "srflx";
        }
        if (_var0 == CandidateType.Relayed) {
            return "relay";
        }
        if (_var0 == CandidateType.PeerReflexive) {
            return "prflx";
        }
        return "unknown";
    }
}

