/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.ArrayExtensions;
import fm.icelink.openh264.ComplexityMode;
import fm.icelink.openh264.EncoderSpatialLayerConfig;
import fm.icelink.openh264.NativeEncoderConfig;
import fm.icelink.openh264.ParameterSetStrategy;
import fm.icelink.openh264.RateControlMode;
import fm.icelink.openh264.UsageType;

public class EncoderConfig {
    private ComplexityMode __complexityMode;
    private NativeEncoderConfig __config = new NativeEncoderConfig();
    private ParameterSetStrategy __parameterSetStrategy;
    private RateControlMode __rcMode;
    private UsageType __usageType;
    private EncoderSpatialLayerConfig[] _spatialLayers;

    public EncoderConfig deepCopy() {
        EncoderConfig config = new EncoderConfig();
        config.__usageType = this.__usageType;
        config.__rcMode = this.__rcMode;
        config.__complexityMode = this.__complexityMode;
        config.__parameterSetStrategy = this.__parameterSetStrategy;
        for (int i = 0; i < ArrayExtensions.getLength((Object[])this.getSpatialLayers()); ++i) {
            config.getSpatialLayers()[i] = this.getSpatialLayers()[i].deepCopy();
        }
        config.__config = this.__config.deepCopy();
        return config;
    }

    public EncoderConfig() {
        this.setSpatialLayers(new EncoderSpatialLayerConfig[4]);
        for (int i = 0; i < ArrayExtensions.getLength((Object[])this.getSpatialLayers()); ++i) {
            this.getSpatialLayers()[i] = new EncoderSpatialLayerConfig();
        }
        this.setUsageType(UsageType.getCameraVideoRealTime());
        this.setRcMode(RateControlMode.getBitrateMode());
        this.setComplexityMode(ComplexityMode.getMedium());
        this.setSpsPpsIdStrategy(ParameterSetStrategy.getConstantId());
    }

    public ComplexityMode getComplexityMode() {
        return this.__complexityMode;
    }

    public boolean getEnableAdaptiveQuant() {
        return this.__config.getEnableAdaptiveQuant() == 1;
    }

    public boolean getEnableBackgroundDetection() {
        return this.__config.getEnableBackgroundDetection() == 1;
    }

    public boolean getEnableDenoise() {
        return this.__config.getEnableDenoise() == 1;
    }

    public boolean getEnableFrameCroppingFlag() {
        return this.__config.getEnableFrameCroppingFlag() == 1;
    }

    public boolean getEnableFrameSkip() {
        return this.__config.getEnableFrameSkip() == 1;
    }

    public boolean getEnableLongTermReference() {
        return this.__config.getEnableLongTermReference() == 1;
    }

    public boolean getEnableSceneChangeDetect() {
        return this.__config.getEnableSceneChangeDetect() == 1;
    }

    public boolean getEnableSsei() {
        return this.__config.getEnableSsei() == 1;
    }

    public int getEntropyCodingModeFlag() {
        return this.__config.getEntropyCodingModeFlag();
    }

    public int getIntraPeriod() {
        return this.__config.getIntraPeriod();
    }

    public boolean getIsLosslessLink() {
        return this.__config.getIsLosslessLink() == 1;
    }

    public int getLoopFilterAlphaC0Offset() {
        return this.__config.getLoopFilterAlphaC0Offset();
    }

    public int getLoopFilterBetaOffset() {
        return this.__config.getLoopFilterBetaOffset();
    }

    public int getLoopFilterDisableIdc() {
        return this.__config.getLoopFilterDisableIdc();
    }

    public int getLtrMarkPeriod() {
        return this.__config.getLtrMarkPeriod();
    }

    public int getLtrRefNum() {
        return this.__config.getLtrNumber();
    }

    public float getMaxFrameRate() {
        return this.__config.getMaxFrameRate();
    }

    public int getMaxNalSize() {
        return this.__config.getMaxNalSize();
    }

    public int getMaxQP() {
        return this.__config.getMaxQP();
    }

    public int getMinQP() {
        return this.__config.getMinQP();
    }

    public int getMultipleThreadIdc() {
        return this.__config.getMultipleThreadIdc();
    }

    NativeEncoderConfig getNativeConfig() {
        return this.__config;
    }

    public int getNumRefFrame() {
        return this.__config.getNumRefFrame();
    }

    public boolean getPaddingFlag() {
        return this.__config.getPaddingFlag() == 1;
    }

    public boolean getPrefixNalAddingControl() {
        return this.__config.getPrefixNalAddingControl() == 1;
    }

    public RateControlMode getRcMode() {
        return this.__rcMode;
    }

    public boolean getSimulcastAvc() {
        return this.__config.getSimulcastAvc() == 1;
    }

    public int getSpatialLayerNum() {
        return this.__config.getSpatialLayers();
    }

    public EncoderSpatialLayerConfig[] getSpatialLayers() {
        return this._spatialLayers;
    }

    public ParameterSetStrategy getSpsPpsIdStrategy() {
        return this.__parameterSetStrategy;
    }

    public int getTemporalLayerNum() {
        return this.__config.getTemporalLayers();
    }

    public UsageType getUsageType() {
        return this.__usageType;
    }

    public boolean getUseLoadBalancing() {
        return this.__config.getUseLoadBalancing() == 1;
    }

    public void setComplexityMode(ComplexityMode value) {
        this.__complexityMode = value;
        this.__config.setComplexityMode(value.getValue());
    }

    public void setEnableAdaptiveQuant(boolean value) {
        this.__config.setEnableAdaptiveQuant(value ? 1 : 0);
    }

    public void setEnableBackgroundDetection(boolean value) {
        this.__config.setEnableBackgroundDetection(value ? 1 : 0);
    }

    public void setEnableDenoise(boolean value) {
        this.__config.setEnableDenoise(value ? 1 : 0);
    }

    public void setEnableFrameCroppingFlag(boolean value) {
        this.__config.setEnableFrameCroppingFlag(value ? 1 : 0);
    }

    public void setEnableFrameSkip(boolean value) {
        this.__config.setEnableFrameSkip(value ? 1 : 0);
    }

    public void setEnableLongTermReference(boolean value) {
        this.__config.setEnableLongTermReference(value ? 1 : 0);
    }

    public void setEnableSceneChangeDetect(boolean value) {
        this.__config.setEnableSceneChangeDetect(value ? 1 : 0);
    }

    public void setEnableSsei(boolean value) {
        this.__config.setEnableSsei(value ? 1 : 0);
    }

    public void setEntropyCodingModeFlag(int value) {
        this.__config.setEntropyCodingModeFlag(value);
    }

    public void setIntraPeriod(int value) {
        this.__config.setIntraPeriod(value);
    }

    public void setIsLosslessLink(boolean value) {
        this.__config.setIsLosslessLink(value ? 1 : 0);
    }

    public void setLoopFilterAlphaC0Offset(int value) {
        this.__config.setLoopFilterAlphaC0Offset(value);
    }

    public void setLoopFilterBetaOffset(int value) {
        this.__config.setLoopFilterBetaOffset(value);
    }

    public void setLoopFilterDisableIdc(int value) {
        this.__config.setLoopFilterDisableIdc(value);
    }

    public void setLtrMarkPeriod(int value) {
        this.__config.setLtrMarkPeriod(value);
    }

    public void setLtrRefNum(int value) {
        this.__config.setLtrNumber(value);
    }

    public void setMaxFrameRate(float value) {
        this.__config.setMaxFrameRate(value);
    }

    public void setMaxNalSize(int value) {
        this.__config.setMaxNalSize(value);
    }

    public void setMaxQP(int value) {
        this.__config.setMaxQP(value);
    }

    public void setMinQP(int value) {
        this.__config.setMinQP(value);
    }

    public void setMultipleThreadIdc(int value) {
        this.__config.setMultipleThreadIdc(value);
    }

    public void setNumRefFrame(int value) {
        this.__config.setNumRefFrame(value);
    }

    public void setPaddingFlag(boolean value) {
        this.__config.setPaddingFlag(value ? 1 : 0);
    }

    public void setPrefixNalAddingControl(boolean value) {
        this.__config.setPrefixNalAddingControl(value ? 1 : 0);
    }

    public void setRcMode(RateControlMode value) {
        this.__rcMode = value;
        this.__config.setRcMode(value.getValue());
    }

    public void setSimulcastAvc(boolean value) {
        this.__config.setSimulcastAvc(value ? 1 : 0);
    }

    public void setSpatialLayerNum(int value) {
        this.__config.setSpatialLayers(value);
    }

    private void setSpatialLayers(EncoderSpatialLayerConfig[] value) {
        this._spatialLayers = value;
    }

    public void setSpsPpsIdStrategy(ParameterSetStrategy value) {
        this.__parameterSetStrategy = value;
        this.__config.setParameterStrategy(value.getValue());
    }

    public void setTemporalLayerNum(int value) {
        this.__config.setTemporalLayers(value);
    }

    public void setUsageType(UsageType value) {
        this.__usageType = value;
        this.__config.setUsageType(value.getValue());
    }

    public void setUseLoadBalancing(boolean value) {
        this.__config.setUseLoadBalancing(value ? 1 : 0);
    }
}

